/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.cohesion;

import com.ibm.rsaz.analysis.codereview.java.AbstractRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.CohesionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class CohesionInformation
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        CohesionInfo projectCohesionInfo = projectData.getCohesionInfo();
        ClassInfo info = projectData.getClassInfo();
        int total = info.getTotalClassCount() + info.getTotalInterfaceCount();
        projectCohesionInfo.setLcom1DoubleValue(0.0);
        projectCohesionInfo.setLcom2(0.0);
        projectCohesionInfo.setLcom3(0.0);
        if (total != 0) {
            for (PackageData pd : projectData.getPackageDataCollection()) {
                for (ClassData cd : pd.getClassDataList()) {
                    CohesionInfo cinfo = cd.getCohesionInfo();
                    projectCohesionInfo.addLcom1DoubleValue(cinfo.getLcom1DoubleValue());
                    projectCohesionInfo.addLcom2(cinfo.getLcom2());
                    projectCohesionInfo.addLcom3(cinfo.getLcom3());
                }
            }
            projectCohesionInfo.setLcom1DoubleValue(projectCohesionInfo.getLcom1DoubleValue() / (double)total);
            projectCohesionInfo.setLcom2(projectCohesionInfo.getLcom2() / (double)total);
            projectCohesionInfo.setLcom3(projectCohesionInfo.getLcom3() / (double)total);
        }
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        CohesionInfo packageCohesionInfo = packageData.getCohesionInfo();
        ClassInfo info = packageData.getClassInfo();
        int total = info.getTotalClassCount() + info.getTotalInterfaceCount();
        packageCohesionInfo.setLcom1DoubleValue(0.0);
        packageCohesionInfo.setLcom2(0.0);
        packageCohesionInfo.setLcom3(0.0);
        if (total != 0) {
            for (ClassData cd : packageData.getClassDataList()) {
                CohesionInfo cinfo = cd.getCohesionInfo();
                packageCohesionInfo.addLcom1DoubleValue(cinfo.getLcom1DoubleValue());
                packageCohesionInfo.addLcom2(cinfo.getLcom2());
                packageCohesionInfo.addLcom3(cinfo.getLcom3());
            }
            packageCohesionInfo.setLcom1DoubleValue(packageCohesionInfo.getLcom1DoubleValue() / (double)total);
            packageCohesionInfo.setLcom2(packageCohesionInfo.getLcom2() / (double)total);
            packageCohesionInfo.setLcom3(packageCohesionInfo.getLcom3() / (double)total);
        }
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        if (!td.isInterface()) {
            List<ASTNode> attributeList = resource.getTypedNodeList((ASTNode)td, 59);
            List<ASTNode> methodList = resource.getTypedNodeList((ASTNode)td, 31);
            int p = 0;
            int q = 0;
            int numberOfAttributes = attributeList.size();
            int numberOfMethods = methodList.size();
            int numberOfMethodsWithAttribute = 0;
            Map<MethodDeclaration, Set<String>> methodAttributeMap = this.createMethodAttributeMap(resource, methodList, attributeList);
            int index = 0;
            while (index < numberOfMethods) {
                MethodDeclaration methodOne = (MethodDeclaration)methodList.get(index);
                Set<String> methodOneNames = methodAttributeMap.get(methodOne);
                numberOfMethodsWithAttribute += methodOneNames.size();
                int index2 = index + 1;
                while (index2 < numberOfMethods) {
                    MethodDeclaration methodTwo = (MethodDeclaration)methodList.get(index2);
                    Set<String> methodTwoNames = methodAttributeMap.get(methodTwo);
                    boolean found = false;
                    Iterator<String> mTwoIterator = methodTwoNames.iterator();
                    while (!found && mTwoIterator.hasNext()) {
                        found = methodOneNames.contains(mTwoIterator.next());
                    }
                    if (found) {
                        ++q;
                    } else {
                        ++p;
                    }
                    ++index2;
                }
                ++index;
            }
            CohesionInfo info = classData.getCohesionInfo();
            info.setLcom1DoubleValue(p > q ? (double)(p - q) : 0.0);
            if (numberOfAttributes * numberOfMethods > 0) {
                info.setLcom2(1.0 - (double)numberOfMethodsWithAttribute / (double)(numberOfAttributes * numberOfMethods));
            }
            if (numberOfMethods > 1 && numberOfAttributes > 1) {
                info.setLcom3(((double)numberOfMethods - (double)numberOfMethodsWithAttribute / (double)numberOfAttributes) / ((double)numberOfMethods - 1.0));
            }
        }
    }

    private Map<MethodDeclaration, Set<String>> createMethodAttributeMap(MetricsResource resource, List<ASTNode> methodList, List<ASTNode> attributeList) {
        HashMap<MethodDeclaration, Set<String>> methodAttributeMap = new HashMap<MethodDeclaration, Set<String>>(methodList.size());
        FieldAccessFilter fieldFilter = new FieldAccessFilter(attributeList, true);
        for (ASTNode node : methodList) {
            List<ASTNode> nameNodes = resource.getTypedNodeList(node, 42);
            ASTHelper.satisfy(nameNodes, (IRuleFilter)fieldFilter);
            HashSet<String> names = new HashSet<String>(nameNodes.size());
            for (ASTNode nameNode : nameNodes) {
                String n = ((SimpleName)nameNode).getIdentifier();
                names.add(n);
            }
            methodAttributeMap.put((MethodDeclaration)node, names);
        }
        return methodAttributeMap;
    }

    public class FieldAccessFilter
    extends AbstractRuleFilter {
        List<Object> attributes;

        public FieldAccessFilter(List<?> attributes, boolean inclusive) {
            super(inclusive);
            this.attributes = new ArrayList<Object>(attributes.size());
            for (VariableDeclarationFragment vdf : attributes) {
                this.attributes.add(vdf.getName().getIdentifier());
            }
        }

        public boolean satisfies(ASTNode node) {
            super.setSuccess(true);
            SimpleName name = (SimpleName)node;
            return this.attributes.indexOf(name.getIdentifier()) != -1;
        }
    }
}

