/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.basic;

import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import java.util.List;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class MethodInformation
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        MethodInfo projectMethodInfo = projectData.getMethodInfo();
        MethodInfo packageMethodInfo = packageData.getMethodInfo();
        projectMethodInfo.addAbstractMethodCount(packageMethodInfo.getAbstractMethodCount());
        projectMethodInfo.addFinalMethodCount(packageMethodInfo.getFinalMethodCount());
        projectMethodInfo.addPrivateMethodCount(packageMethodInfo.getPrivateMethodCount());
        projectMethodInfo.addProtectedMethodCount(packageMethodInfo.getProtectedMethodCount());
        projectMethodInfo.addPublicMethodCount(packageMethodInfo.getPublicMethodCount());
        projectMethodInfo.addPrivateConstructorCount(packageMethodInfo.getPrivateConstructorCount());
        projectMethodInfo.addProtectedConstructorCount(packageMethodInfo.getProtectedConstructorCount());
        projectMethodInfo.addPublicConstructorCount(packageMethodInfo.getPublicConstructorCount());
        projectMethodInfo.addStaticMethodCount(packageMethodInfo.getStaticMethodCount());
        projectMethodInfo.addTotalConstructorCount(packageMethodInfo.getTotalConstructorCount());
        projectMethodInfo.addTotalMethodCount(packageMethodInfo.getTotalMethodCount());
        projectMethodInfo.addTotalParameterCount(packageMethodInfo.getTotalParameterCount());
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        MethodInfo packageMethodInfo = packageData.getMethodInfo();
        MethodInfo classMethodInfo = classData.getMethodInfo();
        packageMethodInfo.addAbstractMethodCount(classMethodInfo.getAbstractMethodCount());
        packageMethodInfo.addFinalMethodCount(classMethodInfo.getFinalMethodCount());
        packageMethodInfo.addPrivateMethodCount(classMethodInfo.getPrivateMethodCount());
        packageMethodInfo.addProtectedMethodCount(classMethodInfo.getProtectedMethodCount());
        packageMethodInfo.addPublicMethodCount(classMethodInfo.getPublicMethodCount());
        packageMethodInfo.addPrivateConstructorCount(classMethodInfo.getPrivateConstructorCount());
        packageMethodInfo.addProtectedConstructorCount(classMethodInfo.getProtectedConstructorCount());
        packageMethodInfo.addPublicConstructorCount(classMethodInfo.getPublicConstructorCount());
        packageMethodInfo.addStaticMethodCount(classMethodInfo.getStaticMethodCount());
        packageMethodInfo.addTotalConstructorCount(classMethodInfo.getTotalConstructorCount());
        packageMethodInfo.addTotalMethodCount(classMethodInfo.getTotalMethodCount());
        packageMethodInfo.addTotalParameterCount(classMethodInfo.getTotalParameterCount());
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        MethodInfo classMethodInfo = classData.getMethodInfo();
        for (MethodData methodData : classData.getMethodDataList()) {
            MethodInfo mi = methodData.getMethodInfo();
            classMethodInfo.addAbstractMethodCount(mi.getAbstractMethodCount());
            classMethodInfo.addFinalMethodCount(mi.getFinalMethodCount());
            classMethodInfo.addPrivateMethodCount(mi.getPrivateMethodCount());
            classMethodInfo.addProtectedMethodCount(mi.getProtectedMethodCount());
            classMethodInfo.addPublicMethodCount(mi.getPublicMethodCount());
            classMethodInfo.addPrivateConstructorCount(mi.getPrivateConstructorCount());
            classMethodInfo.addProtectedConstructorCount(mi.getProtectedConstructorCount());
            classMethodInfo.addPublicConstructorCount(mi.getPublicConstructorCount());
            classMethodInfo.addStaticMethodCount(mi.getStaticMethodCount());
            classMethodInfo.addTotalConstructorCount(mi.getTotalConstructorCount());
            classMethodInfo.addTotalMethodCount(mi.getTotalMethodCount());
            classMethodInfo.addTotalParameterCount(mi.getTotalParameterCount());
        }
    }

    @Override
    public void methodMeasure(MetricsResource resource, MethodData methodData, MethodDeclaration md) {
        MethodInfo mi = methodData.getMethodInfo();
        int modifiers = md.getModifiers();
        if (md.isConstructor()) {
            mi.addTotalConstructorCount(1);
            if (Modifier.isPrivate((int)modifiers)) {
                mi.addPrivateConstructorCount(1);
            } else if (Modifier.isPublic((int)modifiers)) {
                mi.addPublicConstructorCount(1);
            } else if (Modifier.isProtected((int)modifiers)) {
                mi.addProtectedConstructorCount(1);
            }
        } else {
            mi.addTotalMethodCount(1);
            if (Modifier.isPrivate((int)modifiers)) {
                mi.addPrivateMethodCount(1);
            } else if (Modifier.isPublic((int)modifiers)) {
                mi.addPublicMethodCount(1);
            } else if (Modifier.isProtected((int)modifiers)) {
                mi.addProtectedMethodCount(1);
            }
            if (Modifier.isFinal((int)modifiers)) {
                mi.setFinalMethodCount(1);
            }
            if (Modifier.isAbstract((int)modifiers)) {
                mi.setAbstractMethodCount(1);
            }
            if (Modifier.isStatic((int)modifiers)) {
                mi.setStaticMethodCount(1);
            }
        }
        List parameters = md.parameters();
        if (parameters != null) {
            mi.setTotalParameterCount(parameters.size());
        }
    }
}

