/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.basic;

import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.LineInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.MetricUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class MeasureLine
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        LineInfo lineInfo = projectData.getLineInfo();
        LineInfo packageLineInfo = packageData.getLineInfo();
        lineInfo.addEmptyLines(packageLineInfo.getEmptyLines());
        lineInfo.addLinesWithCode(packageLineInfo.getLinesWithCode());
        lineInfo.addTotalComments(packageLineInfo.getTotalComments());
        lineInfo.addTotalLines(packageLineInfo.getTotalLines());
        lineInfo.addMethodLinesWithCode(packageLineInfo.getMethodLinesWithCode());
        lineInfo.addImportStatements(packageLineInfo.getImportStatements());
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        LineInfo packageLineInfo = packageData.getLineInfo();
        LineInfo classLineInfo = classData.getLineInfo();
        packageLineInfo.addEmptyLines(classLineInfo.getEmptyLines());
        packageLineInfo.addLinesWithCode(classLineInfo.getLinesWithCode());
        packageLineInfo.addTotalComments(classLineInfo.getTotalComments());
        packageLineInfo.addTotalLines(classLineInfo.getTotalLines());
        packageLineInfo.addMethodLinesWithCode(classLineInfo.getMethodLinesWithCode());
        packageLineInfo.addImportStatements(classLineInfo.getImportStatements());
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        CompilationUnit cu = resource.getResourceCompUnit();
        LineInfo info = MetricUtils.getLineInfo(resource, (ASTNode)cu);
        LineInfo classLineInfo = classData.getLineInfo();
        classLineInfo.setEmptyLines(info.getEmptyLines());
        classLineInfo.setLinesWithCode(info.getLinesWithCode());
        classLineInfo.setTotalComments(info.getTotalComments());
        classLineInfo.setTotalLines(info.getTotalLines());
        classLineInfo.setImportStatements(cu.imports().size());
        classLineInfo.setMethodLinesWithCode(0);
        for (MethodData methodData : classData.getMethodDataList()) {
            LineInfo mli = methodData.getLineInfo();
            classLineInfo.setMethodLinesWithCode(mli.getLinesWithCode());
        }
    }

    @Override
    public void methodMeasure(MetricsResource resource, MethodData methodData, MethodDeclaration md) {
        LineInfo info = MetricUtils.getLineInfo(resource, (ASTNode)md);
        LineInfo methodLineInfo = methodData.getLineInfo();
        methodLineInfo.setEmptyLines(info.getEmptyLines());
        methodLineInfo.setLinesWithCode(info.getLinesWithCode());
        methodLineInfo.setMethodLinesWithCode(info.getMethodLinesWithCode());
        methodLineInfo.setTotalComments(info.getTotalComments());
        methodLineInfo.setTotalLines(info.getTotalLines());
    }
}

