/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.basic;

import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ClassInformation
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        ClassInfo pci = projectData.getClassInfo();
        ClassInfo ci = packageData.getClassInfo();
        pci.addAbstractClassCount(ci.getAbstractClassCount());
        pci.addFinalClassCount(ci.getFinalClassCount());
        pci.addTotalInterfaceCount(ci.getTotalInterfaceCount());
        pci.addPrivateClassCount(ci.getPrivateClassCount());
        pci.addProtectedClassCount(ci.getProtectedClassCount());
        pci.addPublicClassCount(ci.getPublicClassCount());
        pci.addStaticClassCount(ci.getStaticClassCount());
        pci.addTotalClassCount(ci.getTotalClassCount());
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        ClassInfo pci = packageData.getClassInfo();
        ClassInfo ci = classData.getClassInfo();
        pci.addAbstractClassCount(ci.getAbstractClassCount());
        pci.addFinalClassCount(ci.getFinalClassCount());
        pci.addTotalInterfaceCount(ci.getTotalInterfaceCount());
        pci.addPrivateClassCount(ci.getPrivateClassCount());
        pci.addProtectedClassCount(ci.getProtectedClassCount());
        pci.addPublicClassCount(ci.getPublicClassCount());
        pci.addStaticClassCount(ci.getStaticClassCount());
        pci.addTotalClassCount(ci.getTotalClassCount());
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        ClassInfo ci = classData.getClassInfo();
        int modifiers = td.getModifiers();
        if (td.isInterface()) {
            ci.addTotalInterfaceCount(1);
        } else {
            if (Modifier.isPrivate((int)modifiers)) {
                ci.addPrivateClassCount(1);
            } else if (Modifier.isPublic((int)modifiers)) {
                ci.addPublicClassCount(1);
            } else if (Modifier.isProtected((int)modifiers)) {
                ci.addProtectedClassCount(1);
            }
            if (Modifier.isStatic((int)modifiers)) {
                ci.addStaticClassCount(1);
            }
            if (Modifier.isAbstract((int)modifiers)) {
                ci.addAbstractClassCount(1);
            }
            if (Modifier.isFinal((int)modifiers)) {
                ci.addFinalClassCount(1);
            }
            ci.addTotalClassCount(1);
        }
    }
}

