/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.basic;

import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.AttributeInfo;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class AttributeInformation
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        AttributeInfo projectAttributeInfo = projectData.getAttributeInfo();
        AttributeInfo packageAttributeInfo = packageData.getAttributeInfo();
        projectAttributeInfo.addFinalAttributeCount(packageAttributeInfo.getFinalAttributeCount());
        projectAttributeInfo.addPrivateAttributeCount(packageAttributeInfo.getPrivateAttributeCount());
        projectAttributeInfo.addProtectedAttributeCount(packageAttributeInfo.getProtectedAttributeCount());
        projectAttributeInfo.addPublicAttributeCount(packageAttributeInfo.getPublicAttributeCount());
        projectAttributeInfo.addStaticAttributeCount(packageAttributeInfo.getStaticAttributeCount());
        projectAttributeInfo.addTotalAttributeCount(packageAttributeInfo.getTotalAttributeCount());
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        AttributeInfo packageAttributeInfo = packageData.getAttributeInfo();
        AttributeInfo classAttributeInfo = classData.getAttributeInfo();
        packageAttributeInfo.addFinalAttributeCount(classAttributeInfo.getFinalAttributeCount());
        packageAttributeInfo.addPrivateAttributeCount(classAttributeInfo.getPrivateAttributeCount());
        packageAttributeInfo.addProtectedAttributeCount(classAttributeInfo.getProtectedAttributeCount());
        packageAttributeInfo.addPublicAttributeCount(classAttributeInfo.getPublicAttributeCount());
        packageAttributeInfo.addStaticAttributeCount(classAttributeInfo.getStaticAttributeCount());
        packageAttributeInfo.addTotalAttributeCount(classAttributeInfo.getTotalAttributeCount());
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        AttributeInfo ai = classData.getAttributeInfo();
        FieldDeclaration[] fields = td.getFields();
        ai.addTotalAttributeCount(fields.length);
        int iCtr = 0;
        while (iCtr < fields.length) {
            FieldDeclaration fd = fields[iCtr];
            int modifiers = fd.getModifiers();
            if (Modifier.isPrivate((int)modifiers)) {
                ai.addPrivateAttributeCount(1);
            } else if (Modifier.isPublic((int)modifiers)) {
                ai.addPublicAttributeCount(1);
            } else if (Modifier.isProtected((int)modifiers)) {
                ai.addProtectedAttributeCount(1);
            }
            if (Modifier.isFinal((int)modifiers)) {
                ai.addFinalAttributeCount(1);
            }
            if (Modifier.isStatic((int)modifiers)) {
                ai.addStaticAttributeCount(1);
            }
            ++iCtr;
        }
    }
}

