/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.export;

import com.ibm.rsaz.analysis.core.AnalysisConstants;
import com.ibm.rsaz.analysis.core.reporting.AbstractReportXMLWriter;
import com.ibm.xtools.analysis.metrics.java.internal.export.MetricsImageWriter;
import com.ibm.xtools.analysis.metrics.java.internal.model.MetricsResultByRuleModel;
import java.io.IOException;
import java.io.Writer;

public abstract class MetricsXMLWriter
extends AbstractReportXMLWriter {
    private final String OPEN_RESULTTYPES_TAG = "\t<resultTypes>";
    private final String CLOSE_RESULTTYPES_TAG = "\t</resultTypes>";
    private final String RESULTTYPE_TAG_1 = "\t\t<resultType type=\"";
    private final String RESULTTYPE_TAG_2 = "\" image=\"";
    private final String RESULTTYPE_TAG_3 = "\" color=\"";
    private final String RESULTTYPE_TAG_4 = "\" />";
    public static final String PACKAGE_INFO = "A0";
    public static final String PACKAGE_MINOR = "A1";
    public static final String PACKAGE_MAJOR = "A2";
    public static final String PACKAGE_CRITICAL = "A3";
    public static final String PACKAGE_BLOCKER = "A4";
    public static final String CLASS_INFO = "B00";
    public static final String CLASS_MINOR = "B01";
    public static final String CLASS_MAJOR = "B02";
    public static final String CLASS_CRITICAL = "B03";
    public static final String CLASS_BLOCKER = "B04";
    public static final String INTERFACE_INFO = "B10";
    public static final String INTERFACE_MINOR = "B11";
    public static final String INTERFACE_MAJOR = "B12";
    public static final String INTERFACE_CRITICAL = "B13";
    public static final String INTERFACE_BLOCKER = "B14";
    public static final String METHOD_INFO = "C00";
    public static final String METHOD_MINOR = "C01";
    public static final String METHOD_MAJOR = "C02";
    public static final String METHOD_CRITICAL = "C03";
    public static final String METHOD_BLOCKER = "C04";
    public static final String PROTECTED_METHOD_INFO = "C10";
    public static final String PROTECTED_METHOD_MINOR = "C11";
    public static final String PROTECTED_METHOD_MAJOR = "C12";
    public static final String PROTECTED_METHOD_CRITICAL = "C13";
    public static final String PROTECTED_METHOD_BLOCKER = "C14";
    public static final String PRIVATE_METHOD_INFO = "C20";
    public static final String PRIVATE_METHOD_MINOR = "C21";
    public static final String PRIVATE_METHOD_MAJOR = "C22";
    public static final String PRIVATE_METHOD_CRITICAL = "C23";
    public static final String PRIVATE_METHOD_BLOCKER = "C24";
    public static final String DARK_RED = "dark red";
    public static final String RED = "red";
    public static final String YELLOW = "yellow";
    public static final String DARK_YELLOW = "dark yellow";
    public static final String GREEN = "green";
    private final String[] COLORS = new String[]{"green", "yellow", "dark yellow", "red", "dark red"};
    private final String[] PACKAGE_TYPES = new String[]{"A0", "A1", "A2", "A3", "A4"};
    private final String[] CLASS_TYPES = new String[]{"B00", "B01", "B02", "B03", "B04", "B10", "B11", "B12", "B13", "B14"};
    private final String[] METHOD_TYPES = new String[]{"C00", "C01", "C02", "C03", "C04", "C10", "C11", "C12", "C13", "C14", "C20", "C21", "C22", "C23", "C24"};
    public static final String TAG_PROVIDER_START = "<provider name=\"{0}\" id=\"{1}\" datapath=\"{2}\" title=\"{3}\">";
    public static final String TAG_PROVIDER_END = "</provider>";
    public static final String TAG_RULE_START = "\t\t<rule name=\"{0}\" id=\"{1}\" metric=\"{2}{3}\" image=\"{4}\">";
    public static final String TAG_RULE_END = "\t\t</rule>";
    public static final String TAG_PACKAGE_START = "\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />";
    protected MetricsResultByRuleModel model;
    protected int currentResultId = 0;

    protected void writeResultTypes(Writer writer) throws IOException {
        writer.write("\t<resultTypes>" + AnalysisConstants.LINE_SEPARATOR);
        int i = 0;
        while (i < this.PACKAGE_TYPES.length) {
            writer.write("\t\t<resultType type=\"" + this.PACKAGE_TYPES[i] + "\" image=\"" + "/icons/" + "package_obj.png" + "\" color=\"" + this.COLORS[i] + "\" />" + AnalysisConstants.LINE_SEPARATOR);
            ++i;
        }
        i = 0;
        while (i < this.CLASS_TYPES.length) {
            writer.write("\t\t<resultType type=\"" + this.CLASS_TYPES[i] + "\" image=\"" + (i <= 2 ? "/icons/class_obj.png" : "/icons/int_default_obj.png") + "\" color=\"" + this.COLORS[i % 3] + "\" />" + AnalysisConstants.LINE_SEPARATOR);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.METHOD_TYPES.length) {
            String image = i2 <= 2 ? "/icons/methpub_obj.png" : (i2 <= 5 ? "/icons/methpro_obj.png" : "/icons/methpri_obj.png");
            writer.write("\t\t<resultType type=\"" + this.METHOD_TYPES[i2] + "\" image=\"" + image + "\" color=\"" + this.COLORS[i2 % 3] + "\" />" + AnalysisConstants.LINE_SEPARATOR);
            ++i2;
        }
        writer.write("\t</resultTypes>" + AnalysisConstants.LINE_SEPARATOR);
    }

    protected void writeImages() {
        MetricsImageWriter.writeEclipseImage("package_obj.png");
        MetricsImageWriter.writeEclipseImage("class_obj.png");
        MetricsImageWriter.writeEclipseImage("int_default_obj.png");
        MetricsImageWriter.writeEclipseImage("methpub_obj.png");
        MetricsImageWriter.writeEclipseImage("methpro_obj.png");
        MetricsImageWriter.writeEclipseImage("methpri_obj.png");
    }
}

