/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.export;

import com.ibm.rsaz.analysis.core.AnalysisConstants;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.rsaz.analysis.core.category.DefaultAnalysisCategory;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.provider.AbstractAnalysisProvider;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.xtools.analysis.metrics.java.Messages;
import com.ibm.xtools.analysis.metrics.java.MetricsResult;
import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.export.ExportAllByCategory;
import com.ibm.xtools.analysis.metrics.java.internal.util.ImageWriterUtil;
import com.ibm.xtools.analysis.metrics.java.model.BaseElement;
import com.ibm.xtools.analysis.metrics.java.model.ClassElement;
import com.ibm.xtools.analysis.metrics.java.model.MethodElement;
import com.ibm.xtools.analysis.metrics.java.model.PackageElement;
import com.ibm.xtools.analysis.metrics.java.model.ProjectElement;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExportSevereByCategory
extends ExportAllByCategory {
    @Override
    protected void exportProvider(IProgressMonitor monitor, Writer writer, AnalysisHistory history, AbstractAnalysisProvider provider, String title) throws IOException {
        this.writeImages();
        String line = Messages.bind((String)"<provider name=\"{0}\" id=\"{1}\" datapath=\"{2}\" title=\"{3}\">", (Object[])new Object[]{AnalysisCorePlugin.encodeForXML((String)provider.getLabel()), provider.getId(), AnalysisCorePlugin.getDefault().getStateLocation().toOSString(), Messages.reportSevereByCategoryTitle});
        writer.write(line);
        writer.write(AnalysisConstants.LINE_SEPARATOR);
        List elements = provider.getOwnedElements();
        if (elements != null) {
            for (AbstractAnalysisElement element : elements) {
                DefaultAnalysisCategory child = (DefaultAnalysisCategory)element;
                if (!history.containsAnalysisElement((AbstractAnalysisElement)child)) continue;
                this.exportTopLevelCategory(monitor, writer, history, child);
            }
        }
        writer.write("</provider>");
        writer.write(AnalysisConstants.LINE_SEPARATOR);
    }

    @Override
    protected void exportRule(Writer writer, AnalysisHistory history, AbstractAnalysisRule rule) throws IOException {
        MetricsRule metricsRule = (MetricsRule)rule;
        ProjectElement projectElement = this.model.getProjectElement(metricsRule);
        if (projectElement != null) {
            MetricsResult metricsResult = projectElement.getResult();
            String severityImage = "/icons/ruleblocker_obj.gif";
            String color = this.findRuleColor(history, (MetricsRule)rule);
            if ("dark red".equals(color)) {
                String units = metricsResult.getUnitsOfMeasure();
                if (units == null) {
                    units = "";
                }
                String line = Messages.bind((String)"\t\t<rule name=\"{0}\" id=\"{1}\" metric=\"{2}{3}\" image=\"{4}\">", (Object[])new Object[]{AnalysisCorePlugin.encodeForXML((String)metricsRule.getLabelWithParameters()), metricsRule.getId(), metricsResult.getMetricValue(), units, ImageWriterUtil.writeImage(AnalysisCorePlugin.getPluginId(), AnalysisCorePlugin.getDefault().getStateLocation().toOSString(), severityImage)});
                writer.write(line);
                writer.write(AnalysisConstants.LINE_SEPARATOR);
                writer.write(this.calculateProjectValues(projectElement));
                writer.write("\t\t</rule>");
                writer.write(AnalysisConstants.LINE_SEPARATOR);
            }
        }
    }

    @Override
    protected String calculateProjectValues(ProjectElement element) {
        List<BaseElement> elements;
        StringBuffer result = new StringBuffer();
        if (element != null && (elements = element.getOwnedElements()) != null) {
            for (PackageElement packageElement : elements) {
                String line;
                String units;
                MetricsResult metricsResult = packageElement.getResult();
                String packageName = packageElement.getPackageData().getName();
                String color = this.findPackageColor(packageElement);
                if ("dark red".equals(color)) {
                    units = metricsResult.getUnitsOfMeasure();
                    if (units == null) {
                        units = "";
                    }
                    line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{"A4", packageName, metricsResult.getMetricValue(), units, this.currentResultId});
                    ++this.currentResultId;
                    result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                    result.append(this.calculatePackageValues(packageElement));
                    continue;
                }
                if ("red".equals(color)) {
                    units = metricsResult.getUnitsOfMeasure();
                    if (units == null) {
                        units = "";
                    }
                    line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{"A3", packageName, metricsResult.getMetricValue(), units, this.currentResultId});
                    ++this.currentResultId;
                    result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                    result.append(this.calculatePackageValues(packageElement));
                    continue;
                }
                if (!"dark yellow".equals(color)) continue;
                units = metricsResult.getUnitsOfMeasure();
                if (units == null) {
                    units = "";
                }
                line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{"A2", packageName, metricsResult.getMetricValue(), units, this.currentResultId});
                ++this.currentResultId;
                result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                result.append(this.calculatePackageValues(packageElement));
            }
        }
        return result.toString();
    }

    @Override
    protected String calculatePackageValues(PackageElement element) {
        List<BaseElement> elements;
        StringBuffer result = new StringBuffer();
        if (element != null && (elements = element.getOwnedElements()) != null) {
            for (ClassElement classElement : elements) {
                String line;
                String units;
                boolean isClass;
                String className;
                MetricsResult metricsResult = classElement.getResult();
                ClassData classData = classElement.getClassData();
                ClassInfo info = classData.getClassInfo();
                String color = this.findClassColor(classElement);
                if ("dark red".equals(color)) {
                    className = classData.getName();
                    isClass = info.getTotalClassCount() > 0;
                    units = metricsResult.getUnitsOfMeasure();
                    if (units == null) {
                        units = "";
                    }
                    line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{isClass ? "B04" : "B14", className, metricsResult.getMetricValue(), units, this.currentResultId});
                    ++this.currentResultId;
                    result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                    result.append(this.calculateClassValues(classElement));
                    continue;
                }
                if ("red".equals(color)) {
                    className = classData.getName();
                    isClass = info.getTotalClassCount() > 0;
                    units = metricsResult.getUnitsOfMeasure();
                    if (units == null) {
                        units = "";
                    }
                    line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{isClass ? "B03" : "B13", className, metricsResult.getMetricValue(), units, this.currentResultId});
                    ++this.currentResultId;
                    result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                    result.append(this.calculateClassValues(classElement));
                    continue;
                }
                if (!"dark yellow".equals(color)) continue;
                className = classData.getName();
                isClass = info.getTotalClassCount() > 0;
                units = metricsResult.getUnitsOfMeasure();
                if (units == null) {
                    units = "";
                }
                line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{isClass ? "B02" : "B12", className, metricsResult.getMetricValue(), units, this.currentResultId});
                ++this.currentResultId;
                result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                result.append(this.calculateClassValues(classElement));
            }
        }
        return result.toString();
    }

    @Override
    protected String calculateClassValues(ClassElement element) {
        List<BaseElement> elements;
        StringBuffer result = new StringBuffer();
        if (element != null && (elements = element.getOwnedElements()) != null) {
            for (MethodElement methodElement : elements) {
                String line;
                String units;
                String type;
                String methodName;
                MetricsResult metricsResult = methodElement.getResult();
                MethodData methodData = methodElement.getMethodData();
                MethodInfo info = methodData.getMethodInfo();
                String color = this.findMethodColor(methodElement);
                if ("dark red".equals(color)) {
                    methodName = methodData.getName();
                    type = info.getPublicMethodCount() > 0 || info.getPublicConstructorCount() > 0 ? "C04" : (info.getProtectedMethodCount() > 0 || info.getProtectedConstructorCount() > 0 ? "C14" : "C24");
                    units = metricsResult.getUnitsOfMeasure();
                    if (units == null) {
                        units = "";
                    }
                    line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{type, methodName, metricsResult.getMetricValue(), units, this.currentResultId});
                    ++this.currentResultId;
                    result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                    continue;
                }
                if ("red".equals(color)) {
                    methodName = methodData.getName();
                    type = info.getPublicMethodCount() > 0 || info.getPublicConstructorCount() > 0 ? "C03" : (info.getProtectedMethodCount() > 0 || info.getProtectedConstructorCount() > 0 ? "C13" : "C23");
                    units = metricsResult.getUnitsOfMeasure();
                    if (units == null) {
                        units = "";
                    }
                    line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{type, methodName, metricsResult.getMetricValue(), units, this.currentResultId});
                    ++this.currentResultId;
                    result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                    continue;
                }
                if (!"dark yellow".equals(color)) continue;
                methodName = methodData.getName();
                type = info.getPublicMethodCount() > 0 || info.getPublicConstructorCount() > 0 ? "C02" : (info.getProtectedMethodCount() > 0 || info.getProtectedConstructorCount() > 0 ? "C12" : "C22");
                units = metricsResult.getUnitsOfMeasure();
                if (units == null) {
                    units = "";
                }
                line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{type, methodName, metricsResult.getMetricValue(), units, this.currentResultId});
                ++this.currentResultId;
                result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
            }
        }
        return result.toString();
    }
}

