/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.export;

import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.rsaz.analysis.core.CoreMessages;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.element.AbstractLightWeightAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.manager.AnalysisProviderManager;
import com.ibm.rsaz.analysis.core.provider.AbstractAnalysisProvider;
import com.ibm.xtools.analysis.metrics.java.MetricsResult;
import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.internal.export.MetricsXMLWriter;
import com.ibm.xtools.analysis.metrics.java.internal.model.MetricsResultByRuleModel;
import com.ibm.xtools.analysis.metrics.java.model.BaseElement;
import com.ibm.xtools.analysis.metrics.java.model.ClassElement;
import com.ibm.xtools.analysis.metrics.java.model.MethodElement;
import com.ibm.xtools.analysis.metrics.java.model.PackageElement;
import com.ibm.xtools.analysis.metrics.java.model.ProjectElement;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class ExportBasic
extends MetricsXMLWriter {
    private static final String FIELD_VALUE = "%value%";
    private static final String FIELD_NAME = "%name%";
    public static final String PROP_ELEMENT_MODEL = "reportingElementModel";
    private static final String TAG_TITLE = "<title name=\"%name%\" />";
    private static final String TAG = "<value name=\"%name%\" value=\"%value%\" />";
    private int high = 0;
    private int medium_high = 0;
    private int medium = 0;
    private int medium_low = 0;
    private int low = 0;
    public static final String IMAGE_BLOCKER = "/icons/ruleblocker_obj.gif";
    public static final String IMAGE_MAJOR = "/icons/rulemajor_obj.gif";
    public static final String IMAGE_CRITICAL = "/icons/rulecritical_obj.gif";
    public static final String IMAGE_MINOR = "/icons/ruleminor_obj.gif";
    public static final String IMAGE_INFO = "/icons/ruleinfo_obj.gif";
    public static final String IMAGE_SEVERE = "/icons/rulesevere_obj.gif";
    public static final String IMAGE_WARNING = "/icons/rulewarn_obj.gif";
    public static final String IMAGE_RCMD = "/icons/rulercmdation_obj.gif";

    public void exportReportElements(IProgressMonitor monitor, Writer writer, AnalysisHistory history, AbstractAnalysisProvider provider, String title) throws IOException {
        this.calculateTotals(history);
    }

    protected void exportProvider(IProgressMonitor monitor, Writer writer, AnalysisHistory history, AbstractAnalysisProvider provider, String title) throws IOException {
        this.writeProviderHeader(writer, (AbstractAnalysisElement)provider, title);
        writer.write(AnalysisCorePlugin.replace((String)TAG_TITLE, (String)FIELD_NAME, (String)title));
        boolean severity5 = InstanceScope.INSTANCE.getNode(AnalysisCorePlugin.getPluginId()).getBoolean("com.ibm.rsaz.analysis.core.analysisSeverityLevels", false);
        if (severity5) {
            writer.write(AnalysisCorePlugin.replace((String)AnalysisCorePlugin.replace((String)TAG, (String)FIELD_NAME, (String)CoreMessages.label_parameter_severity_blocker), (String)FIELD_VALUE, (String)("" + this.high)));
            writer.write(AnalysisCorePlugin.replace((String)AnalysisCorePlugin.replace((String)TAG, (String)FIELD_NAME, (String)CoreMessages.label_parameter_severity_critical), (String)FIELD_VALUE, (String)("" + this.medium_high)));
            writer.write(AnalysisCorePlugin.replace((String)AnalysisCorePlugin.replace((String)TAG, (String)FIELD_NAME, (String)CoreMessages.label_parameter_severity_major), (String)FIELD_VALUE, (String)("" + this.medium)));
            writer.write(AnalysisCorePlugin.replace((String)AnalysisCorePlugin.replace((String)TAG, (String)FIELD_NAME, (String)CoreMessages.label_parameter_severity_minor), (String)FIELD_VALUE, (String)("" + this.medium_low)));
            writer.write(AnalysisCorePlugin.replace((String)AnalysisCorePlugin.replace((String)TAG, (String)FIELD_NAME, (String)CoreMessages.label_parameter_severity_info), (String)FIELD_VALUE, (String)("" + this.low)));
        } else {
            writer.write(AnalysisCorePlugin.replace((String)AnalysisCorePlugin.replace((String)TAG, (String)FIELD_NAME, (String)CoreMessages.label_parameter_severity_severe), (String)FIELD_VALUE, (String)("" + this.high + this.medium_high + this.medium)));
            writer.write(AnalysisCorePlugin.replace((String)AnalysisCorePlugin.replace((String)TAG, (String)FIELD_NAME, (String)CoreMessages.label_parameter_severity_warning), (String)FIELD_VALUE, (String)("" + this.medium_low)));
            writer.write(AnalysisCorePlugin.replace((String)AnalysisCorePlugin.replace((String)TAG, (String)FIELD_NAME, (String)CoreMessages.label_parameter_severity_recommendation), (String)FIELD_VALUE, (String)("" + this.low)));
        }
        this.writeFooter(writer, (AbstractLightWeightAnalysisElement)provider);
    }

    private void calculateTotals(AnalysisHistory history) {
        MetricsResultByRuleModel model = (MetricsResultByRuleModel)history.getProviderPropertyHash().get(PROP_ELEMENT_MODEL);
        MetricsRule rule = (MetricsRule)AnalysisProviderManager.getInstance().getAnalysisElement(this.getId());
        if (rule != null) {
            ProjectElement projectElement = model.getProjectElement(rule);
            this.calculateProjectValues(projectElement);
        }
    }

    private void calculateProjectValues(ProjectElement element) {
        List<BaseElement> elements;
        if (element != null && (elements = element.getOwnedElements()) != null) {
            Iterator<BaseElement> it = elements.iterator();
            while (it.hasNext()) {
                this.calculatePackageValues((PackageElement)it.next());
            }
        }
    }

    private void calculatePackageValues(PackageElement element) {
        MetricsResult result = element.getResult();
        if (result != null) {
            this.calculateResultValues(result);
        }
        Iterator<BaseElement> it = element.getOwnedElements().iterator();
        while (it.hasNext()) {
            this.calculateClassValues((ClassElement)it.next());
        }
    }

    private void calculateClassValues(ClassElement element) {
        MetricsResult result = element.getResult();
        if (result != null) {
            this.calculateResultValues(result);
        }
        Iterator<BaseElement> it = element.getOwnedElements().iterator();
        while (it.hasNext()) {
            this.calculateMethodValues((MethodElement)it.next());
        }
    }

    private void calculateMethodValues(MethodElement element) {
        MetricsResult result = element.getResult();
        if (result != null) {
            this.calculateResultValues(result);
        }
    }

    private void calculateResultValues(MetricsResult result) {
        if (result.isHighSeverity()) {
            ++this.high;
        } else if (result.isMediumHighSeverity()) {
            ++this.medium_high;
        } else if (result.isMediumSeverity()) {
            ++this.medium;
        } else if (result.isMediumLowSeverity()) {
            ++this.medium_low;
        } else {
            ++this.low;
        }
    }
}

