/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.export;

import com.ibm.rsaz.analysis.core.AnalysisConstants;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.rsaz.analysis.core.category.DefaultAnalysisCategory;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.provider.AbstractAnalysisProvider;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.xtools.analysis.metrics.java.Messages;
import com.ibm.xtools.analysis.metrics.java.MetricsProvider;
import com.ibm.xtools.analysis.metrics.java.MetricsResult;
import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.internal.export.MetricsXMLWriter;
import com.ibm.xtools.analysis.metrics.java.internal.model.MetricsResultByRuleModel;
import com.ibm.xtools.analysis.metrics.java.internal.util.ImageWriterUtil;
import com.ibm.xtools.analysis.metrics.java.model.BaseElement;
import com.ibm.xtools.analysis.metrics.java.model.ClassElement;
import com.ibm.xtools.analysis.metrics.java.model.MethodElement;
import com.ibm.xtools.analysis.metrics.java.model.PackageElement;
import com.ibm.xtools.analysis.metrics.java.model.ProjectElement;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class ExportAllByCategoryNoMethods
extends MetricsXMLWriter {
    public void exportReportElements(IProgressMonitor monitor, Writer writer, AnalysisHistory history, AbstractAnalysisProvider provider, String title) throws IOException {
        this.model = (MetricsResultByRuleModel)history.getProviderPropertyHash().get("reportingElementModel");
        if (this.model == null) {
            this.model = new MetricsResultByRuleModel();
            this.model.init((MetricsProvider)provider, history);
            history.getProviderPropertyHash().put("reportingElementModel", this.model);
        }
    }

    protected void exportProvider(IProgressMonitor monitor, Writer writer, AnalysisHistory history, AbstractAnalysisProvider provider, String title) throws IOException {
        this.writeImages();
        String line = Messages.bind((String)"<provider name=\"{0}\" id=\"{1}\" datapath=\"{2}\" title=\"{3}\">", (Object[])new Object[]{AnalysisCorePlugin.encodeForXML((String)provider.getLabel()), provider.getId(), AnalysisCorePlugin.getDefault().getStateLocation().toOSString(), Messages.reportAllByCategoryTitleNoMethods});
        writer.write(line);
        writer.write(AnalysisConstants.LINE_SEPARATOR);
        List elements = provider.getOwnedElements();
        if (elements != null) {
            for (AbstractAnalysisElement element : elements) {
                DefaultAnalysisCategory child = (DefaultAnalysisCategory)element;
                if (!history.containsAnalysisElement((AbstractAnalysisElement)child)) continue;
                this.exportTopLevelCategory(monitor, writer, history, child);
            }
        }
        writer.write("</provider>");
        writer.write(AnalysisConstants.LINE_SEPARATOR);
        this.writeResultTypes(writer);
    }

    protected void exportRule(Writer writer, AnalysisHistory history, AbstractAnalysisRule rule) throws IOException {
        MetricsRule metricsRule = (MetricsRule)rule;
        ProjectElement projectElement = this.model.getProjectElement(metricsRule);
        if (projectElement != null) {
            MetricsResult metricsResult = projectElement.getResult();
            String color = this.findRuleColor(history, (MetricsRule)rule);
            boolean severity5 = InstanceScope.INSTANCE.getNode(AnalysisCorePlugin.getPluginId()).getBoolean("com.ibm.rsaz.analysis.core.analysisSeverityLevels", false);
            String severityImage = severity5 ? ("dark red".equals(color) ? "/icons/ruleblocker_obj.gif" : ("red".equals(color) ? "/icons/rulecritical_obj.gif" : ("dark yellow".equals(color) ? "/icons/rulemajor_obj.gif" : ("yellow".equals(color) ? "/icons/ruleminor_obj.gif" : "/icons/ruleinfo_obj.gif")))) : ("dark red".equals(color) || "red".equals(color) || "dark yellow".equals(color) ? "/icons/rulesevere_obj.gif" : ("yellow".equals(color) ? "/icons/rulewarn_obj.gif" : "/icons/rulercmdation_obj.gif"));
            String units = metricsResult.getUnitsOfMeasure();
            if (units == null) {
                units = "";
            }
            String line = Messages.bind((String)"\t\t<rule name=\"{0}\" id=\"{1}\" metric=\"{2}{3}\" image=\"{4}\">", (Object[])new Object[]{AnalysisCorePlugin.encodeForXML((String)metricsRule.getLabelWithParameters()), metricsRule.getId(), metricsResult.getMetricValue(), units, ImageWriterUtil.writeImage(AnalysisCorePlugin.getPluginId(), AnalysisCorePlugin.getDefault().getStateLocation().toOSString(), severityImage)});
            writer.write(line);
            writer.write(AnalysisConstants.LINE_SEPARATOR);
            writer.write(this.calculateProjectValues(projectElement));
            writer.write("\t\t</rule>");
            writer.write(AnalysisConstants.LINE_SEPARATOR);
        }
    }

    protected String calculateProjectValues(ProjectElement element) {
        List<BaseElement> elements;
        StringBuffer result = new StringBuffer();
        if (element != null && (elements = element.getOwnedElements()) != null) {
            for (PackageElement packageElement : elements) {
                String color;
                MetricsResult metricsResult = packageElement.getResult();
                String packageName = packageElement.getPackageData().getName();
                String units = metricsResult.getUnitsOfMeasure();
                if (units == null) {
                    units = "";
                }
                String type = (color = this.findPackageColor(packageElement)).equals("green") ? "A0" : (color.equals("yellow") ? "A1" : (color.equals("dark yellow") ? "A2" : (color.equals("red") ? "A3" : "A4")));
                String line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{type, packageName, metricsResult.getMetricValue(), units, this.currentResultId});
                ++this.currentResultId;
                result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
                result.append(this.calculatePackageValues(packageElement));
            }
        }
        return result.toString();
    }

    protected String calculatePackageValues(PackageElement element) {
        List<BaseElement> elements;
        StringBuffer result = new StringBuffer();
        if (element != null && (elements = element.getOwnedElements()) != null) {
            for (ClassElement classElement : elements) {
                String color;
                MetricsResult metricsResult = classElement.getResult();
                ClassData classData = classElement.getClassData();
                ClassInfo info = classData.getClassInfo();
                String className = classData.getName();
                boolean isClass = info.getTotalClassCount() > 0;
                String units = metricsResult.getUnitsOfMeasure();
                if (units == null) {
                    units = "";
                }
                String type = (color = this.findClassColor(classElement)).equals("green") ? (isClass ? "B00" : "B10") : (color.equals("yellow") ? (isClass ? "B01" : "B11") : (color.equals("dark yellow") ? (isClass ? "B02" : "B12") : (color.equals("red") ? (isClass ? "B03" : "B13") : (isClass ? "B04" : "B14"))));
                String line = Messages.bind((String)"\t\t\t<result type=\"{0}\" name=\"{1}\" metric=\"{2}{3}\" id=\"{4}\" />", (Object[])new Object[]{type, className, metricsResult.getMetricValue(), units, this.currentResultId});
                ++this.currentResultId;
                result.append(line).append(AnalysisConstants.LINE_SEPARATOR);
            }
        }
        return result.toString();
    }

    protected String getSeverityString(String severity) {
        String result = Messages.severityUnknown;
        if ("0".equals(severity)) {
            result = Messages.severityInsideThreshold;
        } else if ("1".equals(severity)) {
            result = Messages.severityNearThreshold;
        } else if ("2".equals(severity)) {
            result = Messages.severityOutsideThreshold;
        } else if ("3".equals(severity)) {
            result = Messages.severityOutsideThreshold;
        } else if ("4".equals(severity)) {
            result = Messages.severityOutsideThreshold;
        }
        return result;
    }

    protected String findRuleColor(AnalysisHistory history, MetricsRule rule) {
        Collection l = history.getResults((AbstractAnalysisElement)rule);
        String color = "green";
        for (AbstractAnalysisResult element : l) {
            MetricsResult result = (MetricsResult)element;
            if (result.isHighSeverity()) {
                return "dark red";
            }
            if (result.isMediumHighSeverity() && "green".equals(color)) {
                color = "red";
                continue;
            }
            if (result.isMediumSeverity() && "green".equals(color)) {
                color = "dark yellow";
                continue;
            }
            if (!result.isMediumLowSeverity() || !"green".equals(color)) continue;
            color = "yellow";
        }
        return color;
    }

    protected String findPackageColor(PackageElement element) {
        MetricsResult result = element.getResult();
        String color = "green";
        if (result != null && "dark red".equals(color = this.findResultColor(result))) {
            return "dark red";
        }
        for (ClassElement classElement : element.getOwnedElements()) {
            String c = this.findClassColor(classElement);
            if ("dark red".equals(c) || "red".equals(color)) {
                return "dark red";
            }
            if (!"yellow".equals(c) && !"dark yellow".equals(c) || !"green".equals(color)) continue;
            color = "yellow";
        }
        return color;
    }

    protected String findClassColor(ClassElement element) {
        MetricsResult result = element.getResult();
        String color = "green";
        if (result != null && ("dark red".equals(color = this.findResultColor(result)) || "red".equals(color))) {
            return "dark red";
        }
        for (MethodElement methodElement : element.getOwnedElements()) {
            String c = this.findMethodColor(methodElement);
            if ("dark red".equals(c) || "red".equals(c)) {
                return "dark red";
            }
            if (!"yellow".equals(c) && !"dark yellow".equals(c) || !"green".equals(color)) continue;
            color = "yellow";
        }
        return color;
    }

    protected String findMethodColor(MethodElement element) {
        return this.findResultColor(element.getResult());
    }

    protected String findResultColor(MetricsResult result) {
        if (result.isHighSeverity()) {
            return "dark red";
        }
        if (result.isMediumHighSeverity()) {
            return "red";
        }
        if (result.isMediumSeverity()) {
            return "dark yellow";
        }
        if (result.isMediumLowSeverity()) {
            return "yellow";
        }
        return "green";
    }
}

