/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.converter;

import com.ibm.common.components.staticanalysis.core.exceptions.SAImportException;
import com.ibm.common.components.staticanalysis.core.results.ISAFile;
import com.ibm.common.components.staticanalysis.core.results.ISAResult;
import com.ibm.common.components.staticanalysis.core.results.ISASource;
import com.ibm.common.components.staticanalysis.core.results.ISATreeItem;
import com.ibm.common.components.staticanalysis.core.results.importers.ISAImportComplexityRuleResult;
import com.ibm.common.components.staticanalysis.core.results.importers.ISAImportResult;
import com.ibm.common.components.staticanalysis.core.results.importers.ISAImportRule;
import com.ibm.common.components.staticanalysis.core.rules.ISARule;
import com.ibm.common.components.staticanalysis.internal.core.results.importers.SAImportComplexityRuleResult;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.provider.converter.AbstractSAProviderConverter;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.xtools.analysis.metrics.java.Messages;
import com.ibm.xtools.analysis.metrics.java.MetricsResult;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;

public class JavaSAMetricsProviderConverter
extends AbstractSAProviderConverter {
    protected void addRuleResult(AnalysisHistory history, ISAImportResult result, AbstractAnalysisRule saRule, ISAImportRule apiRule, Map<IResource, ISAFile> resourceMap) throws SAImportException {
        HashMap<ProjectData, SAImportComplexityRuleResult> dataResultMap = new HashMap<ProjectData, SAImportComplexityRuleResult>();
        for (AbstractAnalysisResult abstractAnalysisResult : history.getResults((AbstractAnalysisElement)saRule)) {
            MetricsResult mResult = (MetricsResult)abstractAnalysisResult;
            SAImportComplexityRuleResult compResult = null;
            IResource resource = mResult.getResource();
            ElementData data = null;
            String displayName = "";
            String name = "";
            switch (mResult.getElementType()) {
                case 1001: {
                    name = String.format("%s.%s", mResult.getPackageData().getProjectData().getName(), mResult.getPackageData().getName());
                    compResult = new SAImportComplexityRuleResult(this.nameToId(name.startsWith(".") ? name.substring(1) : name, (ISARule)apiRule), (ISAResult)result);
                    data = mResult.getPackageData();
                    displayName = mResult.getPackageData().getName();
                    if (resource != null) break;
                    resource = mResult.getPackageData().getResource();
                    break;
                }
                case 1002: {
                    name = String.format("%s.%s.%s", mResult.getClassData().getPackageData().getProjectData().getName(), mResult.getClassData().getPackageData().getName(), mResult.getClassData().getName());
                    name = name.startsWith(".") ? name.substring(1) : name;
                    name = name.startsWith(".") ? name.substring(1) : name;
                    compResult = new SAImportComplexityRuleResult(this.nameToId(name, (ISARule)apiRule), (ISAResult)result);
                    compResult.setClassType(mResult.getClassData().getClassInfo().getTotalClassCount() > 0 ? 2001 : 2002);
                    displayName = mResult.getClassData().getName();
                    if (resource == null) {
                        resource = mResult.getClassData().getResource();
                    }
                    data = mResult.getClassData();
                    break;
                }
                case 1003: {
                    name = String.format("%s.%s.%s.%s", mResult.getMethodData().getClassData().getPackageData().getProjectData().getName(), mResult.getMethodData().getClassData().getPackageData().getName(), mResult.getMethodData().getClassData().getName(), mResult.getMethodData().getName());
                    name = name.startsWith(".") ? name.substring(1) : name;
                    name = name.startsWith(".") ? name.substring(1) : name;
                    compResult = new SAImportComplexityRuleResult(this.nameToId(name, (ISARule)apiRule), (ISAResult)result);
                    compResult.setNodeEnd(mResult.getMethodData().getNodeStart() + mResult.getMethodData().getNodeLength());
                    compResult.setNodeStart(mResult.getMethodData().getNodeStart());
                    int methodType = 3003;
                    MethodInfo info = mResult.getMethodData().getMethodInfo();
                    if (info.getPrivateConstructorCount() > 0 || info.getPrivateMethodCount() > 0) {
                        methodType = 3001;
                    } else if (info.getProtectedConstructorCount() > 0 || info.getProtectedMethodCount() > 0) {
                        methodType = 3002;
                    } else if (info.getPublicConstructorCount() > 0 || info.getPublicMethodCount() > 0) {
                        methodType = 3004;
                    }
                    compResult.setMethodType(methodType);
                    displayName = mResult.getMethodData().getName();
                    if (resource == null) {
                        resource = mResult.getMethodData().getClassData().getResource();
                    }
                    data = mResult.getMethodData();
                    break;
                }
                case 1000: {
                    compResult = new SAImportComplexityRuleResult(this.nameToId(mResult.getProjectData().getName(), (ISARule)apiRule), (ISAResult)result);
                    if (resource == null) {
                        resource = ResourcesPlugin.getWorkspace().getRoot();
                    }
                    displayName = mResult.getProjectData().getName();
                    data = mResult.getProjectData();
                }
            }
            if (compResult != null) {
                dataResultMap.put((ProjectData)data, compResult);
                compResult.setDisplayName(displayName);
                compResult.setType(mResult.getElementType());
                compResult.setSeverity(Integer.parseInt(mResult.getSeverity()));
                compResult.setMetricsValue(mResult.getMetricDoubleValue());
                compResult.setUnits(mResult.getUnitsOfMeasure());
                compResult.setVisible(mResult.isVisible());
                compResult.setPrecision(2);
                compResult.addSource((ISASource)this.getSAFileFromResource(resource, resourceMap, result));
                if (apiRule.addChild((ISATreeItem)compResult)) continue;
                AnalysisCorePlugin.log((String)NLS.bind((String)Messages.result_id_exists, (Object)compResult.getName()));
                continue;
            }
            AnalysisCorePlugin.log((String)Messages.result_is_null);
        }
        for (Map.Entry entry : dataResultMap.entrySet()) {
            if (entry.getKey() instanceof MethodData) {
                ((ISAImportComplexityRuleResult)entry.getValue()).setParentResultID(((ISAImportComplexityRuleResult)dataResultMap.get(((MethodData)entry.getKey()).getClassData())).getID());
                continue;
            }
            if (entry.getKey() instanceof ClassData) {
                ((ISAImportComplexityRuleResult)entry.getValue()).setParentResultID(((ISAImportComplexityRuleResult)dataResultMap.get(((ClassData)entry.getKey()).getPackageData())).getID());
                continue;
            }
            if (entry.getKey() instanceof PackageData) {
                ((ISAImportComplexityRuleResult)entry.getValue()).setParentResultID(((ISAImportComplexityRuleResult)dataResultMap.get(((PackageData)entry.getKey()).getProjectData())).getID());
                continue;
            }
            if (!(entry.getKey() instanceof ProjectData)) continue;
            ((ISAImportComplexityRuleResult)entry.getValue()).setParentResultID(-1);
        }
    }

    private String nameToId(String name, ISARule apiRule) {
        String namei = String.format("%s.%d", name, 0);
        int i = 1;
        while (apiRule.getChild(namei) != null) {
            namei = String.format("%s.%d", name, i);
            ++i;
        }
        return namei;
    }
}

