/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.converter;

import com.ibm.common.components.staticanalysis.core.results.ISAFile;
import com.ibm.common.components.staticanalysis.core.results.ISAResult;
import com.ibm.common.components.staticanalysis.core.results.ISASource;
import com.ibm.common.components.staticanalysis.core.results.rules.ISAComplexityRuleResult;
import com.ibm.common.components.staticanalysis.core.results.rules.ISARuleResult;
import com.ibm.common.components.staticanalysis.core.rules.ISARuleProvider;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.manager.AnalysisProviderManager;
import com.ibm.rsaz.analysis.core.provider.converter.AbstractAPIProviderConverter;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.xtools.analysis.metrics.java.ClassMetricsResult;
import com.ibm.xtools.analysis.metrics.java.MethodMetricsResult;
import com.ibm.xtools.analysis.metrics.java.MetricsResult;
import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.PackageMetricsResult;
import com.ibm.xtools.analysis.metrics.java.ProjectMetricsResult;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ContainerData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;

public class JavaAPIMetricsProviderConverter
extends AbstractAPIProviderConverter {
    private Map<ISAComplexityRuleResult, ElementData> resultDataMap = new HashMap<ISAComplexityRuleResult, ElementData>();
    private Map<Integer, ISAComplexityRuleResult> compResultMap = new HashMap<Integer, ISAComplexityRuleResult>();
    private Map<IResource, Map<String, ElementData>> elementDataMap = new HashMap<IResource, Map<String, ElementData>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertAPIProvider(AnalysisHistory history, ISARuleProvider apiProvider, Map<ISAFile, IResource> fileResourceMap, ISAResult result) {
        Class<JavaAPIMetricsProviderConverter> clazz = JavaAPIMetricsProviderConverter.class;
        synchronized (JavaAPIMetricsProviderConverter.class) {
            this.resultDataMap.clear();
            this.compResultMap.clear();
            this.elementDataMap.clear();
            super.convertAPIProvider(history, apiProvider, fileResourceMap, result);
            this.linkElementData(this.resultDataMap, this.compResultMap);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected void addRuleResult(ISARuleResult apiResult, AnalysisHistory history, Map<ISAFile, IResource> fileResourceMap, ISAResult result) {
        ISAComplexityRuleResult compResult = (ISAComplexityRuleResult)apiResult;
        AbstractAnalysisRule rule = (AbstractAnalysisRule)AnalysisProviderManager.getInstance().getAnalysisElement(compResult.getRule().getName());
        MetricsResult saMetricsResult = null;
        IResource resource = null;
        Assert.isTrue((compResult.getSourceFiles().size() == 1 ? 1 : 0) != 0);
        for (ISASource src : compResult.getSourceFiles()) {
            resource = fileResourceMap.get(src.getSourceFile());
        }
        this.compResultMap.put(compResult.getID(), compResult);
        switch (compResult.getType()) {
            case 1000: {
                ProjectData projectData = (ProjectData)this.getElementData(resource, compResult, 1000);
                ((MetricsRule)rule).setElementDataValue(projectData, compResult.getMetrics());
                this.resultDataMap.put(compResult, projectData);
                saMetricsResult = new ProjectMetricsResult(rule, resource, String.valueOf(compResult.getSeverity()), projectData);
                break;
            }
            case 1001: {
                PackageData packageData = (PackageData)this.getElementData(resource, compResult, 1001);
                this.resultDataMap.put(compResult, packageData);
                ((MetricsRule)rule).setElementDataValue(packageData, compResult.getMetrics());
                saMetricsResult = new PackageMetricsResult(rule, resource, String.valueOf(compResult.getSeverity()), packageData);
                break;
            }
            case 1002: {
                ClassData classData = (ClassData)this.getElementData(resource, compResult, 1002);
                classData.getClassInfo().setTotalClassCount(compResult.getClassType() == 2001 ? 1 : 0);
                ((MetricsRule)rule).setElementDataValue(classData, compResult.getMetrics());
                this.resultDataMap.put(compResult, classData);
                saMetricsResult = new ClassMetricsResult(rule, resource, String.valueOf(compResult.getSeverity()), classData);
                break;
            }
            case 1003: {
                MethodData methodData = (MethodData)this.getElementData(resource, compResult, 1003);
                methodData.setNodeStart(compResult.getNodeStart());
                methodData.setNodeLength(compResult.getNodeEnd() - compResult.getNodeStart());
                ((MetricsRule)rule).setElementDataValue(methodData, compResult.getMetrics());
                this.resultDataMap.put(compResult, methodData);
                saMetricsResult = new MethodMetricsResult(rule, resource, String.valueOf(compResult.getSeverity()), methodData);
            }
        }
        if (saMetricsResult != null) {
            saMetricsResult.setResultValue(compResult.getMetrics());
            saMetricsResult.setVisible(compResult.isVisible());
            history.addResult(rule, (AbstractAnalysisResult)saMetricsResult);
        }
    }

    private ElementData getElementData(IResource resource, ISAComplexityRuleResult compResult, int elementDataType) {
        if (!this.elementDataMap.containsKey(resource)) {
            this.elementDataMap.put(resource, new HashMap());
        }
        if (!this.elementDataMap.get(resource).containsKey(compResult.getName())) {
            ElementData data = null;
            switch (elementDataType) {
                case 1000: {
                    data = new ProjectData();
                    ((ContainerData)data).setResource(resource);
                    break;
                }
                case 1001: {
                    data = new PackageData();
                    ((ContainerData)data).setResource(resource);
                    break;
                }
                case 1002: {
                    data = new ClassData();
                    ((ContainerData)data).setResource(resource);
                    break;
                }
                case 1003: {
                    data = new MethodData();
                    break;
                }
            }
            data.setName(compResult.getDisplayName());
            this.elementDataMap.get(resource).put(compResult.getName(), data);
        }
        return this.elementDataMap.get(resource).get(compResult.getName());
    }

    private void linkElementData(Map<ISAComplexityRuleResult, ElementData> resultDataMap, Map<Integer, ISAComplexityRuleResult> compResultMap) {
        HashSet<ElementData> addedData = new HashSet<ElementData>();
        for (Map.Entry<ISAComplexityRuleResult, ElementData> entry : resultDataMap.entrySet()) {
            switch (entry.getKey().getType()) {
                case 1000: {
                    break;
                }
                case 1001: {
                    PackageData packageData = (PackageData)entry.getValue();
                    ProjectData projectData = (ProjectData)resultDataMap.get(compResultMap.get(entry.getKey().getParentResultID()));
                    if (addedData.contains(packageData)) break;
                    projectData.addPackageData(packageData);
                    addedData.add(packageData);
                    break;
                }
                case 1002: {
                    ClassData classData = (ClassData)entry.getValue();
                    PackageData packageData = (PackageData)resultDataMap.get(compResultMap.get(entry.getKey().getParentResultID()));
                    if (addedData.contains(classData)) break;
                    addedData.add(classData);
                    packageData.addClassData(classData);
                    break;
                }
                case 1003: {
                    MethodData methodData = (MethodData)entry.getValue();
                    ClassData classData = (ClassData)resultDataMap.get(compResultMap.get(entry.getKey().getParentResultID()));
                    int methodType = entry.getKey().getMethodType();
                    boolean isConstructor = methodData.getName().equals(classData.getName());
                    switch (methodType) {
                        case 3001: {
                            if (isConstructor) {
                                methodData.getMethodInfo().setPrivateConstructorCount(1);
                                break;
                            }
                            methodData.getMethodInfo().setPrivateMethodCount(1);
                            break;
                        }
                        case 3002: {
                            if (isConstructor) {
                                methodData.getMethodInfo().setProtectedConstructorCount(1);
                                break;
                            }
                            methodData.getMethodInfo().setProtectedMethodCount(1);
                            break;
                        }
                        case 3004: {
                            if (isConstructor) {
                                methodData.getMethodInfo().setPublicConstructorCount(1);
                                break;
                            }
                            methodData.getMethodInfo().setPublicMethodCount(1);
                            break;
                        }
                    }
                    if (addedData.contains(methodData)) break;
                    addedData.add(methodData);
                    classData.addMethodData(methodData);
                }
            }
        }
    }
}

