/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal;

import com.ibm.rsaz.analysis.architecture.core.data.TypeData;
import com.ibm.rsaz.analysis.architecture.core.data.collections.TypesDataMap;
import com.ibm.rsaz.analysis.core.data.AnalysisDataCollectorsManager;
import com.ibm.rsaz.analysis.core.data.DataCollector;
import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.Messages;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class DataManager {
    private static final String PLUGIN_PROP_CLASS = "class";
    private static final String PLUGIN_PROP_ID = "id";
    private static final String MEASUREMENTS_EXT = "com.ibm.xtools.analysis.metrics.java.measurement";
    private ProjectData projectData;
    private PackageData currentPackageData = null;
    private static List<AbstractMeasurement> measurements = new ArrayList<AbstractMeasurement>(10);
    private List<AbstractMeasurement> activeMeasurments = new ArrayList<AbstractMeasurement>(10);
    private boolean requireCouplingAnalysis = false;

    static {
        DataManager.loadMeasures();
    }

    public DataManager() {
        this.initialize();
    }

    private final void initialize() {
        this.initializeData();
        this.requireCouplingAnalysis = true;
        this.activeMeasurments.addAll(measurements);
    }

    private void initializeData() {
        this.projectData = new ProjectData();
    }

    public final void initialize(AnalysisHistory history) {
        this.initializeData();
        this.updateCouplingFlag(history);
        this.updateActiveMeasurments();
    }

    private void updateCouplingFlag(AnalysisHistory history) {
        Collection elements = history.getSelectAnalysisElements();
        this.requireCouplingAnalysis = false;
        Iterator it = elements.iterator();
        while (it.hasNext() && !this.requireCouplingAnalysis) {
            AbstractAnalysisElement element = (AbstractAnalysisElement)it.next();
            if (!(element instanceof MetricsRule)) continue;
            MetricsRule rule = (MetricsRule)element;
            this.requireCouplingAnalysis = rule.getRequireCouplingInformation();
        }
    }

    public final void clear() {
        this.projectData = null;
        this.currentPackageData = null;
    }

    public boolean requireCouplingAnalysis() {
        return this.requireCouplingAnalysis;
    }

    private static final void loadMeasures() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(MEASUREMENTS_EXT);
        IExtension[] extensions = extensionPoint.getExtensions();
        int iCtr = 0;
        while (iCtr < extensions.length) {
            IConfigurationElement[] elements = extensions[iCtr].getConfigurationElements();
            int jCtr = 0;
            while (jCtr < elements.length) {
                String id = elements[jCtr].getAttribute(PLUGIN_PROP_ID);
                try {
                    AbstractMeasurement measureClass = (AbstractMeasurement)elements[jCtr].createExecutableExtension(PLUGIN_PROP_CLASS);
                    measurements.add(measureClass);
                }
                catch (CoreException coreException) {
                    Log.severe((String)("Java Metrics: Invalid measurement:" + id));
                }
                ++jCtr;
            }
            ++iCtr;
        }
    }

    private void updateActiveMeasurments() {
        this.activeMeasurments.clear();
        for (AbstractMeasurement measurement : measurements) {
            if (!this.isMeasurmentActive(measurement)) continue;
            this.activeMeasurments.add(measurement);
        }
    }

    private boolean isMeasurmentActive(AbstractMeasurement measureClass) {
        boolean bRetVal = false;
        if (this.requireCouplingAnalysis || !measureClass.collectingCouplingInformation()) {
            bRetVal = true;
        }
        return bRetVal;
    }

    private PackageData getPackage(String name) {
        PackageData packageData = this.projectData.getPackageData(name);
        if (packageData == null) {
            packageData = new PackageData();
            packageData.setName(name);
            this.projectData.addPackageData(packageData);
        }
        return packageData;
    }

    public final void collectProjectMetrics() {
        for (PackageData packageData : this.projectData.getPackageDataCollection()) {
            for (AbstractMeasurement measure : this.activeMeasurments) {
                measure.projectMeasure(this.projectData, packageData);
            }
        }
        if (this.currentPackageData != null) {
            this.currentPackageData.getHalsteadInfo().cleanTemporaryData();
            this.currentPackageData = null;
        }
    }

    public final void sortResources(List<IResource> resources) {
        Collections.sort(resources, new ResourcePackageComparator());
    }

    public final void collectMetrics(MetricsResource resource) {
        CompilationUnit cu = resource.getResourceCompUnit();
        List<ASTNode> packageList = resource.getTypedNodeList((ASTNode)cu, 35);
        if (packageList != null) {
            PackageData packageData = null;
            packageData = packageList.size() == 0 ? this.getPackage(Messages.defaultPackage) : this.getPackage(((PackageDeclaration)packageList.get(0)).getName().getFullyQualifiedName());
            packageData.setResource((IResource)resource.getIResource().getParent());
            List<ASTNode> tdList = resource.getTypedNodeList((ASTNode)cu, 55, false);
            for (TypeDeclaration typeDeclaration : tdList) {
                ClassData classData = new ClassData();
                packageData.addClassData(classData);
                classData.setResource(resource.getIResource());
                classData.setName(typeDeclaration.getName().getFullyQualifiedName());
                List<ASTNode> mdList = resource.getTypedNodeList((ASTNode)typeDeclaration, 31);
                for (MethodDeclaration methodDeclaration : mdList) {
                    MethodData methodData = new MethodData();
                    classData.addMethodData(methodData);
                    SimpleName name = methodDeclaration.getName();
                    methodData.setName(name.getIdentifier());
                    methodData.setNodeStart(name.getStartPosition());
                    methodData.setNodeLength(name.getLength());
                    for (AbstractMeasurement measurement : this.activeMeasurments) {
                        measurement.methodMeasure(resource, methodData, methodDeclaration);
                    }
                }
                for (AbstractMeasurement measurement : this.activeMeasurments) {
                    measurement.classMeasure(resource, classData, typeDeclaration);
                    measurement.packageMeasure(resource, packageData, classData);
                }
                classData.getHalsteadInfo().cleanTemporaryData();
                if (this.currentPackageData != null && this.currentPackageData != packageData) {
                    this.currentPackageData.getHalsteadInfo().cleanTemporaryData();
                }
                this.currentPackageData = packageData;
            }
        }
    }

    public final Collection<PackageData> getPackageDataCollection() {
        return this.getProjectData().getPackageDataCollection();
    }

    public final ProjectData getProjectData() {
        if (this.projectData == null) {
            this.projectData = new ProjectData();
        }
        return this.projectData;
    }

    public Collection<TypeData> getTypeDependencies(IType type) {
        TypesDataMap tdMap;
        Collection<Object> dependencies = Collections.emptySet();
        DataCollector typeDataCollector = AnalysisDataCollectorsManager.getDataCollector((String)"com.ibm.rsaz.analysis.architecture.java.collector.TypeDataCollector");
        if (typeDataCollector != null && (tdMap = (TypesDataMap)typeDataCollector.getAnalysisData()) != null) {
            dependencies = ((TypeData)tdMap.get((Object)type)).getDependencies();
        }
        return dependencies;
    }

    public Collection<TypeData> getTypeDependants(IType type) {
        TypesDataMap tdMap;
        Collection<Object> dependents = Collections.emptySet();
        DataCollector typeDataCollector = AnalysisDataCollectorsManager.getDataCollector((String)"com.ibm.rsaz.analysis.architecture.java.collector.TypeDataCollector");
        if (typeDataCollector != null && (tdMap = (TypesDataMap)typeDataCollector.getAnalysisData()) != null) {
            dependents = ((TypeData)tdMap.get((Object)type)).getDependents();
        }
        return dependents;
    }

    class ResourcePackageComparator
    implements Comparator<IResource> {
        ResourcePackageComparator() {
        }

        @Override
        public int compare(IResource resource1, IResource resource2) {
            IJavaElement element1 = JavaCore.create((IResource)resource1);
            IJavaElement element2 = JavaCore.create((IResource)resource2);
            ICompilationUnit cu1 = (ICompilationUnit)element1;
            ICompilationUnit cu2 = (ICompilationUnit)element2;
            try {
                IPackageDeclaration pD1 = cu1.getPackageDeclarations()[0];
                IPackageDeclaration pD2 = cu2.getPackageDeclarations()[0];
                return pD1.getElementName().compareTo(pD2.getElementName());
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        }
    }
}

