/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java;

import com.ibm.rsaz.analysis.core.element.AnalysisParameter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.xtools.analysis.metrics.java.ClassMetricsResult;
import com.ibm.xtools.analysis.metrics.java.MethodMetricsResult;
import com.ibm.xtools.analysis.metrics.java.PackageMetricsResult;
import com.ibm.xtools.analysis.metrics.java.ProjectMetricsResult;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.internal.DataManager;
import org.eclipse.core.resources.IResource;

public abstract class MetricsRule
extends AbstractAnalysisRule {
    public static final String METRIC_ABBREVITION_PARAMETER = "ABBREVIATION";
    public static final String METRIC_UNITS_PARAMETER = "UNITS";
    public static final String INTERNAL_PACKAGE_FRAGMENT = ".internal";
    private DataManager manager;
    private AnalysisHistory history;
    private String abbreviation;
    private String unitsOfMeasure = null;

    public void analyze(AnalysisHistory historyValue, DataManager managerValue) {
        this.history = historyValue;
        this.manager = managerValue;
        this.analyzeProject();
    }

    public final void analyze(AnalysisHistory _history) {
    }

    public void analyzeProject() {
        ProjectData projectData = this.manager.getProjectData();
        for (PackageData packageData : projectData.getPackageDataCollection()) {
            this.analyzePackage(projectData, packageData);
        }
    }

    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        for (ClassData classData : packageData.getClassDataList()) {
            this.analyzeClass(projectData, packageData, classData);
        }
    }

    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        for (MethodData methodData : classData.getMethodDataList()) {
            this.analyzeMethod(projectData, packageData, classData, methodData);
        }
    }

    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, int displayIntValue, int nodeStart, int nodeLength) {
        ProjectMetricsResult result = new ProjectMetricsResult(this, resource, severity, projectData);
        result.setResultValue(displayIntValue);
        result.createMarker(nodeStart, nodeLength);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, double displayDoubleValue, int nodeStart, int nodeLength) {
        ProjectMetricsResult result = new ProjectMetricsResult(this, resource, severity, projectData);
        result.setResultValue(displayDoubleValue);
        result.createMarker(nodeStart, nodeLength);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData, int displayIntValue, int nodeStart, int nodeLength) {
        MethodMetricsResult result = new MethodMetricsResult(this, resource, severity, methodData);
        result.setResultValue(displayIntValue);
        result.createMarker(nodeStart, nodeLength);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData, double displayDoubleValue, int nodeStart, int nodeLength) {
        MethodMetricsResult result = new MethodMetricsResult(this, resource, severity, methodData);
        result.setResultValue(displayDoubleValue);
        result.createMarker(nodeStart, nodeLength);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, PackageData packageData, ClassData classData, int displayIntValue) {
        ClassMetricsResult result = new ClassMetricsResult(this, resource, severity, classData);
        result.setResultValue(displayIntValue);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, PackageData packageData, ClassData classData, double displayDoubleValue) {
        ClassMetricsResult result = new ClassMetricsResult(this, resource, severity, classData);
        result.setResultValue(displayDoubleValue);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, PackageData packageData, int displayIntValue) {
        PackageMetricsResult result = new PackageMetricsResult(this, resource, severity, packageData);
        result.setResultValue(displayIntValue);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, PackageData packageData, double displayDoubleValue) {
        PackageMetricsResult result = new PackageMetricsResult(this, resource, severity, packageData);
        result.setResultValue(displayDoubleValue);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public final void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, int displayIntValue) {
        ProjectMetricsResult result = new ProjectMetricsResult(this, resource, severity, projectData);
        result.setResultValue(displayIntValue);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    public void generateResultsForASTNode(IResource resource, String severity, ProjectData projectData, double displayDoubleValue) {
        ProjectMetricsResult result = new ProjectMetricsResult(this, resource, severity, projectData);
        result.setResultValue(displayDoubleValue);
        this.addHistoryResultSet(this.history.getHistoryId(), (AbstractAnalysisResult)result);
    }

    protected final String getMinimumSeverity(double value, double minimum) {
        String severity = "0";
        if (value < minimum / 4.0) {
            severity = "4";
        } else if (value < minimum / 2.0) {
            severity = "3";
        } else if (value < minimum) {
            severity = "2";
        } else if (value < 2.0 * minimum) {
            severity = "1";
        }
        return severity;
    }

    protected final String getMinimumSeverity(int value, int minimum) {
        String severity = "0";
        if (value < minimum / 4) {
            severity = "4";
        } else if (value < minimum / 2) {
            severity = "3";
        } else if (value < minimum) {
            severity = "2";
        } else if (value < minimum * 2) {
            severity = "1";
        }
        return severity;
    }

    protected final String getMaximumSeverity(int value, int maximum) {
        String severity = "0";
        if (value > 4 * maximum) {
            severity = "4";
        } else if (value > 2 * maximum) {
            severity = "3";
        } else if (value > maximum) {
            severity = "2";
        } else if (value > maximum / 2) {
            severity = "1";
        }
        return severity;
    }

    protected final String getMaximumSeverity(double value, double maximum) {
        String severity = "0";
        if (value > 4.0 * maximum) {
            severity = "4";
        } else if (value > 2.0 * maximum) {
            severity = "3";
        } else if (value > maximum) {
            severity = "2";
        } else if (value > maximum / 2.0) {
            severity = "1";
        }
        return severity;
    }

    protected final String getMinMaxSeverity(double value, double minimum, double maximum) {
        String severity = "0";
        if (4.0 * maximum > minimum / 4.0 && (value > 4.0 * maximum || value < minimum / 4.0)) {
            severity = "4";
        } else if (2.0 * maximum > minimum / 2.0 && (value > 2.0 * maximum || value < minimum / 2.0)) {
            severity = "3";
        } else if (maximum > minimum && (value > maximum || value < minimum)) {
            severity = "2";
        } else if (maximum / 2.0 > 2.0 * minimum && (value > maximum / 2.0 || value < 2.0 * minimum)) {
            severity = "1";
        }
        return severity;
    }

    protected final String getMinMaxSeverity(int value, int minimum, int maximum) {
        String severity = "0";
        if (maximum * 4 > minimum / 4 && (value > maximum * 4 || value < minimum / 4)) {
            severity = "4";
        } else if (2 * maximum > minimum / 2 && (value > 2 * maximum || value < minimum / 2)) {
            severity = "3";
        } else if (maximum > minimum && (value > maximum || value < minimum)) {
            severity = "2";
        } else if (maximum / 2 > 2 * minimum && (value > maximum / 2 || value < 2 * minimum)) {
            severity = "1";
        }
        return severity;
    }

    public final String getUnitsOfMeasure() {
        if (this.unitsOfMeasure == null) {
            String units;
            this.unitsOfMeasure = "";
            AnalysisParameter param = this.getParameter(METRIC_UNITS_PARAMETER);
            if (param != null && (units = param.getValue()) != null) {
                this.unitsOfMeasure = units;
            }
        }
        return this.unitsOfMeasure;
    }

    public final AnalysisHistory getHistory() {
        return this.history;
    }

    public final DataManager getManager() {
        return this.manager;
    }

    public final String getAbbreviation() {
        if (this.abbreviation == null) {
            String value;
            this.abbreviation = "";
            AnalysisParameter param = this.getParameter(METRIC_ABBREVITION_PARAMETER);
            if (param != null && (value = param.getValue()) != null) {
                this.abbreviation = value;
            }
        }
        return this.abbreviation;
    }

    public boolean getRequireCouplingInformation() {
        return false;
    }

    public abstract void setElementDataValue(ElementData var1, double var2);
}

