/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.rsaz.analysis.core.element.AnalysisParameter;
import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.rsaz.analysis.core.reporting.tabulatedmodel.AbstractTabulatedAnalysisResult;
import com.ibm.rsaz.analysis.core.reporting.tabulatedmodel.MetricsTabulatedResult;
import com.ibm.rsaz.analysis.core.result.ResourceAnalysisResult;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.xtools.analysis.metrics.java.Messages;
import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.export.MetricsImageWriter;
import com.ibm.xtools.analysis.metrics.java.internal.util.MarkerPool;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class MetricsResult
extends ResourceAnalysisResult {
    private static DecimalFormat formatter = new DecimalFormat("0.00");
    private double displayDoubleValue = Double.NaN;
    private String severity;
    public static final int PROJECT_RESULT = 1000;
    public static final int PACKAGE_RESULT = 1001;
    public static final int CLASS_RESULT = 1002;
    public static final int METHOD_RESULT = 1003;

    public MetricsResult(IResource resourceValue) {
        super(resourceValue);
    }

    public final String getResourceName() {
        return this.getResource().getName();
    }

    public final String getResourcePath() {
        return this.getResource().getFullPath().toOSString();
    }

    public final void setResultValue(double displayFloatValue) {
        this.displayDoubleValue = displayFloatValue;
    }

    public final void setResultValue(int displayIntValue) {
        this.displayDoubleValue = displayIntValue;
    }

    public final void createMarker(int nodeStart, int nodeLength) {
        this.markerInfo = MarkerPool.createMarkerInfo(nodeStart, nodeLength);
    }

    private String getDisplaySeverity() {
        AnalysisParameter parameter = ((AbstractAnalysisRule)this.getOwner()).getParameter("SEVERITY");
        String displaySeverity = "0";
        if (parameter != null) {
            displaySeverity = parameter.getValue();
        }
        return displaySeverity;
    }

    private final void forceCreateMarker(int nodeStart, int nodeLength) {
        String displaySeverity = this.getDisplaySeverity();
        boolean severity5 = InstanceScope.INSTANCE.getNode(AnalysisCorePlugin.getPluginId()).getBoolean("com.ibm.rsaz.analysis.core.analysisSeverityLevels", false);
        this.marker = severity5 ? ("4".equals(displaySeverity) ? MarkerPool.createMarker(this.getResource(), "com.ibm.rsaz.analysis.core.analysisBaseBlockerMarker", nodeStart, nodeLength) : ("3".equals(displaySeverity) ? MarkerPool.createMarker(this.getResource(), "com.ibm.rsaz.analysis.core.analysisBaseCriticalMarker", nodeStart, nodeLength) : ("2".equals(displaySeverity) ? MarkerPool.createMarker(this.getResource(), "com.ibm.rsaz.analysis.core.analysisBaseMajorMarker", nodeStart, nodeLength) : ("1".equals(displaySeverity) ? MarkerPool.createMarker(this.getResource(), "com.ibm.rsaz.analysis.core.analysisBaseMinorMarker", nodeStart, nodeLength) : MarkerPool.createMarker(this.getResource(), "com.ibm.rsaz.analysis.core.analysisBaseInfoMarker", nodeStart, nodeLength))))) : ("4".equals(displaySeverity) || "3".equals(displaySeverity) || "2".equals(displaySeverity) ? MarkerPool.createMarker(this.getResource(), "com.ibm.rsaz.analysis.core.analysisSevereMarker", nodeStart, nodeLength) : ("1".equals(displaySeverity) ? MarkerPool.createMarker(this.getResource(), "com.ibm.rsaz.analysis.core.analysisWarningMarker", nodeStart, nodeLength) : MarkerPool.createMarker(this.getResource(), "com.ibm.rsaz.analysis.core.analysisRecommendationMarker", nodeStart, nodeLength)));
    }

    public void createMarker() {
        if (this.marker == null && this.markerInfo != null) {
            this.forceCreateMarker(this.markerInfo.getStartPosition(), this.markerInfo.getLength());
            MarkerPool.releaseMarkerInfo(this.markerInfo.getStartPosition(), this.markerInfo.getLength());
            this.markerInfo = null;
        }
    }

    public void removeMarker() {
        if (this.marker != null && this.marker.exists()) {
            int startPosition = 0;
            try {
                Object startObject = this.marker.getAttribute("charStart");
                if (startObject instanceof Integer) {
                    startPosition = (Integer)startObject;
                }
            }
            catch (CoreException e) {
                Log.severe((String)"", (Throwable)e);
            }
            int length = 0;
            try {
                Object endObject = this.marker.getAttribute("charEnd");
                if (endObject instanceof Integer) {
                    length = (Integer)endObject - startPosition;
                }
            }
            catch (CoreException e) {
                Log.severe((String)"", (Throwable)e);
            }
            this.markerInfo = MarkerPool.createMarkerInfo(startPosition, length);
            MarkerPool.releaseMarker(this.marker);
        }
    }

    public final String getMetricValue() {
        if (this.displayDoubleValue != Double.NaN) {
            return formatter.format(this.displayDoubleValue);
        }
        return "";
    }

    public final double getMetricDoubleValue() {
        return this.displayDoubleValue;
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        ProjectData projectData = this.getProjectData();
        PackageData packageData = this.getPackageData();
        ClassData classData = this.getClassData();
        MethodData methodData = this.getMethodData();
        if (projectData != null) {
            if (packageData != null) {
                String packageName = packageData.getName();
                if (classData != null) {
                    String className = classData.getName();
                    if (methodData != null) {
                        String methodName = methodData.getName();
                        sb.append(Messages.bind((String)Messages.metric_long_result_label, (Object[])new Object[]{packageName, className, methodName}));
                    } else {
                        sb.append(Messages.bind((String)Messages.metric_medium_result_label, (Object[])new Object[]{packageName, className}));
                    }
                } else {
                    sb.append(Messages.bind((String)Messages.metric_short_result_label, (Object[])new Object[]{packageName}));
                }
            } else {
                sb.append(Messages.metric_short_result_label);
            }
        }
        return sb.toString();
    }

    public String getUnitsOfMeasure() {
        return ((MetricsRule)this.getOwner()).getUnitsOfMeasure();
    }

    public final String getSeverity() {
        return this.severity;
    }

    public final boolean isError() {
        return this.isHighSeverity() || this.isMediumHighSeverity() || this.isMediumSeverity();
    }

    public final boolean isHighSeverity() {
        return "4".equals(this.severity);
    }

    public final boolean isMediumHighSeverity() {
        return "3".equals(this.severity);
    }

    public final boolean isMediumSeverity() {
        return "2".equals(this.severity);
    }

    public final boolean isMediumLowSeverity() {
        return "1".equals(this.severity);
    }

    public final boolean isLowSeverity() {
        return "0".equals(this.severity);
    }

    public final boolean isWarning() {
        return this.isMediumLowSeverity();
    }

    public final boolean isOK() {
        return "0".equals(this.severity);
    }

    public ClassData getClassData() {
        return null;
    }

    public MethodData getMethodData() {
        return null;
    }

    public PackageData getPackageData() {
        return null;
    }

    public ProjectData getProjectData() {
        return null;
    }

    public void dispose() {
        if (this.marker != null) {
            MarkerPool.releaseMarker(this.marker);
        }
        if (this.markerInfo != null) {
            MarkerPool.releaseMarkerInfo(this.markerInfo.getStartPosition(), this.markerInfo.getLength());
        }
        super.dispose();
    }

    protected void setSeverity(String severityValue) {
        this.setResultSeverity(severityValue);
        this.severity = severityValue;
    }

    public AbstractTabulatedAnalysisResult tabulate() {
        ProjectData projectData = this.getProjectData();
        PackageData packageData = this.getPackageData();
        ClassData classData = this.getClassData();
        MethodData methodData = this.getMethodData();
        String packageName = "";
        String className = "";
        String methodName = "";
        if (projectData != null && packageData != null) {
            packageName = packageData.getName();
            if (classData != null) {
                className = classData.getName();
                if (methodData != null) {
                    methodName = methodData.getName();
                }
            }
        }
        int severity = this.isOK() ? 0 : (this.isWarning() ? 1 : 2);
        String icon = "";
        if (this.getElementType() == 1001) {
            icon = MetricsImageWriter.writeEclipseImage("package_obj.png");
        } else if (this.getElementType() == 1002) {
            boolean isClass = false;
            if (classData != null) {
                isClass = classData.getClassInfo().getTotalClassCount() > 0;
            }
            icon = isClass ? MetricsImageWriter.writeEclipseImage("class_obj.png") : MetricsImageWriter.writeEclipseImage("int_default_obj.png");
        } else if (this.getElementType() == 1003 && methodData != null) {
            MethodInfo info = methodData.getMethodInfo();
            icon = info.getPublicMethodCount() > 0 || info.getPublicConstructorCount() > 0 ? MetricsImageWriter.writeEclipseImage("methpub_obj.png") : (info.getProtectedMethodCount() > 0 || info.getProtectedConstructorCount() > 0 ? MetricsImageWriter.writeEclipseImage("methpro_obj.png") : MetricsImageWriter.writeEclipseImage("methpri_obj.png"));
        }
        icon = String.valueOf(AnalysisCorePlugin.getDefault().getStateLocation().toOSString()) + icon;
        return new MetricsTabulatedResult(packageName, className, methodName, this.getMetricValue(), icon, severity);
    }
}

