/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java;

import com.ibm.rsaz.analysis.codereview.java.CodeReviewVisitor;
import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.xtools.analysis.metrics.java.MetricsNodeCounterVisitor;
import com.ibm.xtools.analysis.metrics.java.MetricsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class MetricsResource {
    private CompilationUnit resourceCompUnit = null;
    private MetricsProvider provider;
    private IResource resource;
    private Map<ASTQuery, List<ASTNode>> cacheMap;
    private String sourceCode;

    public MetricsResource(MetricsProvider providerValue, IResource resourceValue) {
        this.resource = resourceValue;
        this.provider = providerValue;
        this.cacheMap = new HashMap<ASTQuery, List<ASTNode>>();
        this.init();
    }

    private void init() {
        ASTParser parser = ASTParser.newParser((int)8);
        ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)this.resource);
        parser.setSource((ICompilationUnit)JavaCore.create((IResource)this.resource));
        parser.setResolveBindings(true);
        try {
            this.sourceCode = cu.getSource();
        }
        catch (JavaModelException javaModelException) {
            Log.severe((String)("Unable to load source for:" + this.resource.getName()));
        }
        this.resourceCompUnit = (CompilationUnit)parser.createAST(null);
    }

    public List<ASTNode> getTypedNodeList(ASTNode node, int nodeType) {
        return this.getTypedNodeList(node, nodeType, true, false);
    }

    public List<ASTNode> getTypedNodeList(ASTNode node, int nodeType, boolean searchChildren) {
        return this.getTypedNodeList(node, nodeType, searchChildren, false, false);
    }

    public List<ASTNode> getTypedNodeList(ASTNode node, int nodeType, boolean searchChildren, boolean searchJavaDoc) {
        return this.getTypedNodeList(node, nodeType, searchChildren, false, searchJavaDoc);
    }

    public List<ASTNode> getTypedNodeList(ASTNode node, int nodeType, boolean searchChildren, boolean includeRoot, boolean searchJavaDoc) {
        ASTQuery query = new ASTQuery(node, nodeType, searchChildren, searchJavaDoc);
        List result = this.cacheMap.get(query);
        if (result == null) {
            CodeReviewVisitor visitor = new CodeReviewVisitor(nodeType, searchChildren, searchJavaDoc);
            node.accept((ASTVisitor)visitor);
            result = visitor.getAstNodeList();
            if (!includeRoot) {
                result.remove(node);
            }
            this.cacheMap.put(query, result);
        }
        ArrayList<ASTNode> output = new ArrayList<ASTNode>(result.size());
        output.addAll(result);
        return output;
    }

    public List<ASTNode> getTypedNodeList(ASTNode node, int[] nodeTypes) {
        return this.getTypedNodeList(node, nodeTypes, true);
    }

    public List<ASTNode> getTypedNodeList(ASTNode node, int[] nodeTypes, boolean searchChildren) {
        CodeReviewVisitor visitor = new CodeReviewVisitor(nodeTypes, searchChildren);
        node.accept((ASTVisitor)visitor);
        List list = visitor.getAstNodeList();
        list.remove(node);
        return list;
    }

    public int countTypedNodes(ASTNode node, int nodeType) {
        MetricsNodeCounterVisitor visitor = new MetricsNodeCounterVisitor(nodeType);
        node.accept((ASTVisitor)visitor);
        return visitor.getNumberOfNodes();
    }

    public int countTypedNodes(ASTNode node, int[] nodeTypes) {
        MetricsNodeCounterVisitor visitor = new MetricsNodeCounterVisitor(nodeTypes);
        node.accept((ASTVisitor)visitor);
        return visitor.getNumberOfNodes();
    }

    public int countTypedNodes(ASTNode node, int[] nodeTypes, boolean visitChildren) {
        MetricsNodeCounterVisitor visitor = new MetricsNodeCounterVisitor(nodeTypes, visitChildren);
        node.accept((ASTVisitor)visitor);
        return visitor.getNumberOfNodes();
    }

    public int countTypedNodes(ASTNode node, int nodeType, boolean visitChildren) {
        MetricsNodeCounterVisitor visitor = new MetricsNodeCounterVisitor(nodeType, visitChildren);
        node.accept((ASTVisitor)visitor);
        return visitor.getNumberOfNodes();
    }

    public IResource getIResource() {
        return this.resource;
    }

    public CompilationUnit getResourceCompUnit() {
        return this.resourceCompUnit;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public MetricsProvider getProvider() {
        return this.provider;
    }

    private class ASTQuery {
        private ASTNode node;
        private int nodeType;
        private byte flags;

        public ASTQuery(ASTNode nodeValue, int nodeTypeValue, boolean visitChildrenValue, boolean searchJavaDocValue) {
            this.node = nodeValue;
            this.nodeType = nodeTypeValue;
            if (visitChildrenValue) {
                this.flags = (byte)(this.flags | 1);
            }
            if (searchJavaDocValue) {
                this.flags = (byte)(this.flags | 2);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ASTQuery) {
                ASTQuery query = (ASTQuery)obj;
                if (this.getFlags() == query.getFlags() && this.getNodeType() == query.getNodeType() && this.getNode().equals((Object)query.getNode())) {
                    return true;
                }
            }
            return super.equals(obj);
        }

        public int hashCode() {
            int nodeHashCode = this.node.hashCode();
            return nodeHashCode + 17 * this.nodeType + 289 * this.flags;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public int getNodeType() {
            return this.nodeType;
        }

        public byte getFlags() {
            return this.flags;
        }
    }
}

