/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.xmlent.mapping.codegen.ui.internal.editor;

import com.ibm.etools.xmlent.mapping.codegen.ui.internal.MappingUIPlugin;
import com.ibm.etools.xmlent.mapping.codegen.ui.internal.Messages;
import com.ibm.etools.xmlent.mapping.codegen.ui.internal.actions.MigrationOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class MappingMigrationEditor
extends EditorPart {
    final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    public static final Image ICON_ERROR = MappingUIPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    public static String FORM_TAG = "<form>";
    public static String FORM_END_TAG = "</form>";
    public static String BOLD_TAG = "<b>";
    public static String BOLD_END_TAG = "</b>";
    public static String LIST_TAG_ITEM1 = "<li style=\"text\" value=\"1.\">";
    public static String LIST_TAG_ITEM2 = "<li style=\"text\" value=\"2.\">";
    public static String LIST_TAG_ITEM3 = "<li style=\"text\" value=\"3.\">";
    public static String LIST_END_TAG = "</li>";
    public static String IMAGE_ID = "image";
    public static String IMAGE_HREF = "<form><p><img href=\"image\"/> </p></form>";
    public static String COLOR_TAGS = "<form><p><span color=\"header\">";
    public static String COLOR_END_TAGS = "</span></p></form>";
    public static String COLOR_ID = "header";
    private FormToolkit toolkit;
    private ScrolledForm form;
    private IFile iCMXFile = null;
    private Text fFilenameText;
    private Button fMigrateButton;
    private Text fContainerText = null;
    private IStatusLineManager statusLine;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            if (input instanceof IFileEditorInput) {
                this.iCMXFile = ((IFileEditorInput)input).getFile();
            }
        }
        catch (Exception exception) {}
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        try {
            this.toolkit = new FormToolkit(parent.getDisplay());
            this.form = this.toolkit.createScrolledForm(parent);
            this.form.setText(Messages.MIGRATION_TITLE);
            TableWrapLayout layout = new TableWrapLayout();
            this.form.getBody().setLayout((Layout)layout);
            layout.numColumns = 2;
            this.createStepsSection(this.form);
            this.createMigrationSection(this.form);
        }
        catch (Exception exception) {}
    }

    private void createMigrationSection(final ScrolledForm form) {
        try {
            if (form != null) {
                Section section = this.toolkit.createSection(form.getBody(), 194);
                TableWrapData td = new TableWrapData(128);
                td.colspan = 2;
                section.setLayoutData((Object)td);
                section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        form.reflow(true);
                    }
                });
                section.setText(Messages.MIGRATION_MSECTION_TITLE);
                this.toolkit.createCompositeSeparator((Composite)section);
                section.setDescription(String.valueOf(Messages.MIGRATION_MSECTION_DESCRIPTION) + this.iCMXFile.getName());
                Composite sectionClient = this.toolkit.createComposite((Composite)section);
                GridLayout gridLayout = new GridLayout();
                sectionClient.setLayout((Layout)gridLayout);
                gridLayout.numColumns = 3;
                this.fContainerText = this.toolkit.createText((Composite)section, this.getDefaultParentFolder());
                this.fContainerText.setVisible(false);
                FormText ftext = this.toolkit.createFormText(sectionClient, true);
                StringBuffer sb = new StringBuffer();
                sb.append(COLOR_TAGS);
                sb.append(Messages.MIGRATION_MSECTION_FILE_LABEL);
                sb.append(COLOR_END_TAGS);
                ftext.setText(sb.toString(), true, false);
                ftext.setColor(COLOR_ID, this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                this.fFilenameText = this.toolkit.createText(sectionClient, this.getDefaultFileNameNoExt());
                this.addFilenameModifyListener();
                ftext = this.toolkit.createFormText(sectionClient, true);
                sb = new StringBuffer();
                sb.append(COLOR_TAGS);
                sb.append(".mapping");
                sb.append(COLOR_END_TAGS);
                ftext.setText(sb.toString(), true, false);
                ftext.setColor(COLOR_ID, this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                ftext.setLayoutData((Object)new GridData(4, 0, true, false));
                this.fFilenameText.setLayoutData((Object)new GridData(4, 0, true, false));
                this.fMigrateButton = this.toolkit.createButton(sectionClient, Messages.MIGRATION_MSECTION_BUTTON_MIGRATE, 8);
                this.addMigrateButtonListener();
                section.setClient((Control)sectionClient);
            }
        }
        catch (Exception exception) {}
    }

    private void createStepsSection(final ScrolledForm form) {
        try {
            if (form != null) {
                Section section = this.toolkit.createSection(form.getBody(), 194);
                TableWrapData td = new TableWrapData(128);
                td.colspan = 2;
                section.setLayoutData((Object)td);
                section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        form.reflow(true);
                    }
                });
                section.setText(Messages.MIGRATION_STEPS_SECTION_TITLE);
                this.toolkit.createCompositeSeparator((Composite)section);
                section.setDescription(Messages.MIGRATION_STEPS_SECTION_DESCRIPTION);
                Composite sectionClient = this.toolkit.createComposite((Composite)section);
                GridLayout gridLayout = new GridLayout();
                sectionClient.setLayout((Layout)gridLayout);
                gridLayout.numColumns = 2;
                FormText ftext = this.toolkit.createFormText(sectionClient, true);
                ftext.setText(IMAGE_HREF, true, false);
                ftext.setImage(IMAGE_ID, MappingUIPlugin.getImageDescriptor("icons/wizban/migration_wiz.gif").createImage());
                ftext = this.toolkit.createFormText(sectionClient, true);
                StringBuffer sb = new StringBuffer();
                sb.append(FORM_TAG);
                sb.append(String.valueOf(LIST_TAG_ITEM1) + Messages.MIGRATION_STEPS_SECTION_STEP2 + LIST_END_TAG);
                sb.append(String.valueOf(LIST_TAG_ITEM2) + Messages.MIGRATION_STEPS_SECTION_STEP3A + BOLD_TAG);
                sb.append(String.valueOf(Messages.MIGRATION_STEPS_SECTION_STEP3B) + BOLD_END_TAG + "  ");
                sb.append(String.valueOf(Messages.MIGRATION_STEPS_SECTION_STEP3C) + LIST_END_TAG);
                sb.append(FORM_END_TAG);
                ftext.setText(sb.toString(), true, false);
                section.setClient((Control)sectionClient);
            }
        }
        catch (Exception exception) {}
    }

    protected void addMigrateButtonListener() {
        this.fMigrateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MappingMigrationEditor.this.handleMigrateButtonSelected();
            }
        });
    }

    private void handleMigrateButtonSelected() {
        IFile mappingFile = this.getMappingFile();
        IPath containerPath = this.getContainerFullPath();
        if (containerPath != null && mappingFile != null && this.iCMXFile != null && this.validateFileName() && this.validateContainer()) {
            try {
                MigrationOperation op = new MigrationOperation(containerPath, mappingFile, this.iCMXFile);
                op.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {}
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IDE.openEditor((IWorkbenchPage)page, (IFile)mappingFile);
            }
            catch (Exception exception) {}
        }
    }

    private String getDefaultFileNameNoExt() {
        String result = "";
        try {
            if (this.iCMXFile != null) {
                IPath ipath = this.iCMXFile.getFullPath();
                ipath = ipath.removeFileExtension();
                result = ipath.lastSegment();
            }
        }
        catch (Exception exception) {
            result = "";
        }
        return result;
    }

    private String getDefaultFileName() {
        String result = "";
        try {
            if (this.iCMXFile != null) {
                IPath ipath = this.iCMXFile.getFullPath();
                ipath = ipath.removeFileExtension().addFileExtension("mapping");
                result = ipath.lastSegment();
            }
        }
        catch (Exception exception) {
            result = "";
        }
        return result;
    }

    private String getDefaultParentFolder() {
        String result = "";
        try {
            if (this.iCMXFile != null) {
                result = this.iCMXFile.getParent().getFullPath().makeRelative().toPortableString();
            }
        }
        catch (Exception exception) {
            result = "";
        }
        return result;
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }

    public String getFileName() {
        String result = this.getDefaultFileName();
        try {
            if (this.fFilenameText != null) {
                result = String.valueOf(this.fFilenameText.getText()) + "." + "mapping";
            }
        }
        catch (Exception exception) {
            result = this.getDefaultFileName();
        }
        return result;
    }

    public IFile getMappingFile() {
        IFile result = null;
        String fileName = this.getFileName();
        try {
            if (this.getContainerFullPath() != null && fileName != null && fileName.length() > 0) {
                if (new Path(fileName).getFileExtension() == null) {
                    fileName = fileName.concat(".mapping");
                }
                result = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(fileName));
            }
        }
        catch (Exception exception) {
            result = null;
        }
        return result;
    }

    protected boolean validateFileName() {
        String filename = this.getFileName();
        String fileExtension = new Path(filename).getFileExtension();
        if (fileExtension != null) {
            if (fileExtension.compareTo("mapping") != 0) {
                this.setErrorMessage(Messages.ERROR_BAD_FILENAME_EXTENSION);
                return false;
            }
        } else {
            filename = String.valueOf(filename) + "." + "mapping";
        }
        if (this.getContainerFullPath() != null && !this.getContainerFullPath().isEmpty() && this.getFileName().compareTo("") != 0) {
            Path fullPath = new Path(String.valueOf(this.getContainerFullPath().toString()) + '/' + this.getFileName() + "." + "mapping");
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)fullPath);
            if (resource != null) {
                this.setErrorMessage(Messages.ERROR_FILE_ALREADY_EXISTS);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean validateContainer() {
        IPath path = this.getContainerFullPath();
        if (path == null) {
            this.setErrorMessage(Messages.ERROR_FOLDER_EMPTY);
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = path.segment(0);
        if (projectName == null || !workspace.getRoot().getProject(projectName).exists()) {
            this.setErrorMessage(Messages.ERROR_NO_PROJECT);
            return false;
        }
        IWorkspaceRoot root = workspace.getRoot();
        while (path.segmentCount() > 1) {
            if (root.getFile(path).exists()) {
                this.setErrorMessage(Messages.ERROR_PATH_OCCUPIED);
                return false;
            }
            path = path.removeLastSegments(1);
        }
        this.setErrorMessage(null);
        return true;
    }

    public IPath getContainerFullPath() {
        IPath result = null;
        try {
            String pathName = this.fContainerText.getText();
            if (pathName != null && pathName.length() > 0) {
                result = new Path(pathName).makeAbsolute();
            }
        }
        catch (Exception exception) {
            result = null;
        }
        return result;
    }

    public void setErrorMessage(String text) {
        IStatusLineManager statusLine = this.getStatusLineManager();
        if (statusLine != null) {
            if (text == null || text.length() < 1) {
                statusLine.setErrorMessage(null);
            } else {
                statusLine.setErrorMessage(ICON_ERROR, text);
            }
            if (statusLine instanceof SubContributionManager) {
                ((SubContributionManager)statusLine).setVisible(true);
            }
            statusLine.update(true);
        }
    }

    private IStatusLineManager getStatusLineManager() {
        if (this.statusLine == null && this.getEditorSite() != null) {
            this.statusLine = this.getEditorSite().getActionBars().getStatusLineManager();
            if (this.statusLine instanceof SubStatusLineManager) {
                ((SubStatusLineManager)this.statusLine).setVisible(true);
            }
        }
        return this.statusLine;
    }

    private void addFilenameModifyListener() {
        this.fFilenameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingMigrationEditor.this.validateFileName();
            }
        });
    }

    private void addContainerModifyListener() {
        this.fContainerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingMigrationEditor.this.validateContainer();
            }
        });
    }
}

