/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.xmlent.mapping.codegen.ui.internal.actions;

import com.ibm.ccl.mapping.MappingFactory;
import com.ibm.ccl.mapping.MappingPackage;
import com.ibm.etools.xmlent.mapping.codegen.internal.migration.Migrator;
import com.ibm.etools.xmlent.mapping.codegen.internal.util.MappingUtils;
import com.ibm.etools.xmlent.mapping.codegen.ui.internal.util.MappingUIUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.w3c.dom.Document;

public class MigrationOperation
extends WorkspaceModifyOperation {
    protected ResourceSet fResourceSet = null;
    protected MappingFactory mappingFactory;
    protected IFile fMAPFile = null;
    protected IFile fCMXFile = null;
    protected IPath fContainerFullPath = null;

    public MigrationOperation(IPath container, IFile mapFile, IFile cmxFile) {
        this.fContainerFullPath = container;
        this.fMAPFile = mapFile;
        this.fCMXFile = cmxFile;
        this.fResourceSet = new ResourceSetImpl();
        this.fResourceSet.getPackageRegistry().put((Object)"http://www.ibm.com/2006/ccl/Mapping", (Object)MappingPackage.eINSTANCE);
        this.mappingFactory = MappingFactory.eINSTANCE;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        block6: {
            try {
                try {
                    monitor.beginTask("wizard.generate.mapping.file", 100);
                    MappingUIUtils.checkAndCreateContainer(this.fContainerFullPath);
                    Resource resource = this.migrateMappingFile();
                    InputStream stream = MappingUtils.createMapStream((Resource)resource, (String)"UTF-8");
                    if (this.fMAPFile.exists()) {
                        this.fMAPFile.setContents(stream, false, true, (IProgressMonitor)new NullProgressMonitor());
                        break block6;
                    }
                    this.fMAPFile.create(stream, false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private Resource migrateMappingFile() {
        Resource result = null;
        try {
            URI cmxURI = URI.createFileURI((String)this.fCMXFile.getLocation().toOSString());
            URI mapURI = URI.createFileURI((String)this.fMAPFile.getLocation().toOSString());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Document cmxDocument = documentBuilderFactory.newDocumentBuilder().parse(cmxURI.toFileString());
            Migrator m = new Migrator(mapURI);
            result = m.migrate(cmxDocument);
        }
        catch (Exception exception) {
            result = null;
        }
        return result;
    }
}

