/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.RemoteJarExporterUtil;
import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.rse.internal.subsystems.files.core.model.RemotePathUtil;
import org.eclipse.rse.subsystems.files.core.model.IRemotePath;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.widgets.Shell;

public class RemoteJarWriter {
    private JarOutputStream fJarOutputStream;
    private RemoteJarPackageData fJarPackage;

    public RemoteJarWriter(RemoteJarPackageData jarPackage, Shell parent) throws CoreException {
        Assert.isNotNull((Object)((Object)jarPackage), (String)"The JAR specification is null");
        this.fJarPackage = jarPackage;
        Assert.isTrue((boolean)this.fJarPackage.isValid(), (String)"The JAR package specification is invalid");
        if (!this.canCreateJar(parent)) {
            throw new OperationCanceledException();
        }
        IRemotePath location = this.fJarPackage.getRemoteJarLocation();
        IPath tempPath = RemotePathUtil.getInstance().getClientTempLocationForFile(location);
        try {
            if (this.fJarPackage.usesManifest() && this.fJarPackage.areGeneratedFilesExported()) {
                Manifest manifest = this.fJarPackage.getManifestProvider().create((JarPackageData)this.fJarPackage);
                this.fJarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(tempPath.toOSString()), manifest);
            } else {
                this.fJarOutputStream = new JarOutputStream(new FileOutputStream(tempPath.toOSString()));
            }
            String comment = jarPackage.getComment();
            if (comment != null) {
                this.fJarOutputStream.setComment(comment);
            }
        }
        catch (IOException ex) {
            throw RemoteJarExporterUtil.createCoreException(ex.getLocalizedMessage(), ex);
        }
    }

    public void close() throws CoreException {
        if (this.fJarOutputStream != null) {
            try {
                this.fJarOutputStream.close();
            }
            catch (IOException ex) {
                throw RemoteJarExporterUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    public void write(IFile resource, IPath destinationPath) throws CoreException {
        ByteArrayOutputStream output = null;
        BufferedInputStream contentStream = null;
        try {
            try {
                int count;
                output = new ByteArrayOutputStream();
                if (!resource.isLocal(0)) {
                    String message = MessageFormat.format(JarPackagerMessages.JarFileExportOperation_errorReadingFile, resource.getFullPath());
                    throw RemoteJarExporterUtil.createCoreException(message, null);
                }
                contentStream = new BufferedInputStream(resource.getContents(false));
                int chunkSize = 4096;
                byte[] readBuffer = new byte[chunkSize];
                while ((count = contentStream.read(readBuffer, 0, chunkSize)) != -1) {
                    output.write(readBuffer, 0, count);
                }
            }
            catch (IOException ex) {
                throw RemoteJarExporterUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (contentStream != null) {
                    contentStream.close();
                }
            }
            catch (IOException ex) {
                throw RemoteJarExporterUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
        try {
            File file;
            IPath fileLocation = resource.getLocation();
            long lastModified = System.currentTimeMillis();
            if (fileLocation != null && (file = new File(fileLocation.toOSString())).exists()) {
                lastModified = file.lastModified();
            }
            this.write(destinationPath, output.toByteArray(), lastModified);
        }
        catch (IOException ex) {
            String message = null;
            message = ex.getLocalizedMessage() != null ? MessageFormat.format(JarPackagerMessages.JarWriter_writeProblemWithMessage, resource.getFullPath(), ex.getLocalizedMessage()) : MessageFormat.format(JarPackagerMessages.JarWriter_writeProblem, resource.getFullPath());
            throw RemoteJarExporterUtil.createCoreException(message, ex);
        }
    }

    protected void write(IPath path, byte[] contents, long lastModified) throws IOException {
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        if (this.fJarPackage.isCompressed()) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            newEntry.setSize(contents.length);
            CRC32 checksumCalculator = new CRC32();
            checksumCalculator.update(contents);
            newEntry.setCrc(checksumCalculator.getValue());
        }
        newEntry.setTime(lastModified);
        this.fJarOutputStream.putNextEntry(newEntry);
        this.fJarOutputStream.write(contents);
    }

    protected boolean canCreateJar(Shell parent) {
        IRemotePath path = this.fJarPackage.getRemoteJarLocation();
        if (path == null) {
            return false;
        }
        IRemoteFile file = path.toRemoteFile();
        if (file != null && file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fJarPackage.allowOverwrite()) {
                return true;
            }
            return parent != null && RemoteJarExporterUtil.askForRemoteOverwritePermission(parent, path.getAbsolutePath(), file.getParentRemoteFileSubSystem().getHost().getHostName());
        }
        return true;
    }

    private void registerInWorkspaceIfNeeded() {
        Path jarPath = new Path(this.fJarPackage.getRemoteJarLocation().getAbsolutePath());
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            boolean isInProject;
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            boolean bl = isInProject = projectLocation != null && projectLocation.isPrefixOf((IPath)jarPath);
            if (isInProject) {
                try {
                    jarPath = jarPath.removeFirstSegments(projectLocation.segmentCount());
                    jarPath = jarPath.removeLastSegments(1);
                    IResource containingFolder = project.findMember((IPath)jarPath);
                    if (containingFolder != null && containingFolder.isAccessible()) {
                        containingFolder.refreshLocal(1, null);
                    }
                }
                catch (CoreException ex) {
                    JavaPlugin.log((Throwable)ex);
                }
            }
            ++i;
        }
    }
}

