/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.IRemoteJarDescriptionWriter;
import com.ibm.etools.systems.importexport.jar.IRemoteJarExportRunnable;
import com.ibm.etools.systems.importexport.jar.RemoteJarExporterUtil;
import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import com.ibm.etools.systems.remoteJava.RemoteJavaBusyIndicatorRunnableContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.jarpackager.IJarBuilder;
import org.eclipse.jdt.ui.jarpackager.IJarBuilderExtension;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.rse.internal.importexport.RemoteImportExportUtil;
import org.eclipse.rse.subsystems.files.core.model.IRemotePath;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RemoteJarFileExportOperation
extends WorkspaceModifyOperation
implements IRemoteJarExportRunnable {
    private IJarBuilder fJarBuilder;
    private RemoteJarPackageData fJarPackage;
    private RemoteJarPackageData[] fJarPackages;
    private Shell fParentShell;
    private Map<String, ArrayList<IResource>> fJavaNameToClassFilesMap;
    private IContainer fClassFilesMapContainer;
    private Set fExportedClassContainers;
    private MessageMultiStatus fStatus;
    private StandardJavaElementContentProvider fJavaElementContentProvider;
    private boolean fFilesSaved;

    public RemoteJarFileExportOperation(RemoteJarPackageData jarPackage, Shell parent) {
        this(new RemoteJarPackageData[]{jarPackage}, parent);
    }

    public RemoteJarFileExportOperation(RemoteJarPackageData[] jarPackages, Shell parent) {
        this(parent);
        this.fJarPackages = jarPackages;
    }

    private RemoteJarFileExportOperation(Shell parent) {
        this.fParentShell = parent;
        this.fStatus = new MessageMultiStatus(JavaPlugin.getPluginId(), 0, "", null);
        this.fJavaElementContentProvider = new StandardJavaElementContentProvider();
    }

    protected void addToStatus(CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            message = JarPackagerMessages.JarFileExportOperation_coreErrorDuringExport;
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), message, (Throwable)ex);
        }
        this.fStatus.add(status);
    }

    protected void addInfo(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(1, JavaPlugin.getPluginId(), 10001, message, error));
    }

    protected void addWarning(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(2, JavaPlugin.getPluginId(), 10001, message, error));
    }

    protected void addError(String message, Throwable error) {
        this.fStatus.add((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, error));
    }

    protected int countSelectedElements() {
        HashSet<IJavaProject> enclosingJavaProjects = new HashSet<IJavaProject>(10);
        int count = 0;
        int n = this.fJarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            block10: {
                IResource resource;
                block12: {
                    Object element;
                    block11: {
                        element = this.fJarPackage.getElements()[i];
                        IJavaProject javaProject = this.getEnclosingJavaProject(element);
                        if (javaProject != null) {
                            enclosingJavaProjects.add(javaProject);
                        }
                        resource = null;
                        if (!(element instanceof IJavaElement)) break block11;
                        IJavaElement je = (IJavaElement)element;
                        try {
                            resource = je.getUnderlyingResource();
                        }
                        catch (JavaModelException javaModelException) {
                            break block10;
                        }
                        if (resource != null) break block12;
                        break block10;
                    }
                    resource = (IResource)element;
                }
                count = resource.getType() == 1 ? ++count : (count += this.getTotalChildCount((IContainer)resource));
            }
            ++i;
        }
        if (this.fJarPackage.areOutputFoldersExported()) {
            if (!this.fJarPackage.areJavaFilesExported()) {
                count = 0;
            }
            for (IJavaProject javaProject : enclosingJavaProjects) {
                IContainer[] outputContainers;
                try {
                    outputContainers = this.getOutputContainers(javaProject);
                }
                catch (CoreException ex) {
                    this.addToStatus(ex);
                    continue;
                }
                int i2 = 0;
                while (i2 < outputContainers.length) {
                    count += this.getTotalChildCount(outputContainers[i2]);
                    ++i2;
                }
            }
        }
        return count;
    }

    private int getClassFileCount(IJavaElement[] children) throws JavaModelException {
        int result = 0;
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IClassFile) {
                ++result;
            } else if (children[i] instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)children[i];
                result += this.getClassFileCount(fragment.getChildren());
            }
            ++i;
        }
        return result;
    }

    private int getTotalChildCount(IContainer container) {
        IResource[] members;
        try {
            members = container.members();
        }
        catch (CoreException coreException) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < members.length) {
            count = members[i].getType() == 1 ? ++count : (count += this.getTotalChildCount((IContainer)members[i]));
            ++i;
        }
        return count;
    }

    protected void exportElement(Object element, IProgressMonitor progressMonitor) throws InterruptedException {
        IJavaElement je;
        int leadSegmentsToRemove = 1;
        IPackageFragmentRoot pkgRoot = null;
        boolean isInJavaProject = false;
        IResource resource = null;
        ITypeRoot typeRootElement = null;
        IJavaProject jProject = null;
        if (element instanceof IJavaElement) {
            isInJavaProject = true;
            je = (IJavaElement)element;
            if (!(je instanceof ITypeRoot)) {
                this.exportJavaElement(progressMonitor, je);
                return;
            }
            typeRootElement = (ITypeRoot)je;
            jProject = typeRootElement.getJavaProject();
            pkgRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)je);
            resource = typeRootElement.getResource();
        } else if (element instanceof IResource) {
            resource = (IResource)element;
        } else {
            return;
        }
        if (!resource.isAccessible()) {
            this.addWarning(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_resourceNotFound, resource.getFullPath()), null);
            return;
        }
        if (resource.getType() == 1) {
            if (!isInJavaProject) {
                try {
                    isInJavaProject = resource.getProject().hasNature("org.eclipse.jdt.core.javanature");
                }
                catch (CoreException ex) {
                    this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_projectNatureNotDeterminable, (Object)BasicElementLabels.getPathLabel((IPath)resource.getFullPath(), (boolean)false)), ex);
                    return;
                }
                if (isInJavaProject) {
                    je = JavaCore.create((IResource)resource);
                    if (je instanceof ITypeRoot && je.exists()) {
                        this.exportElement(je, progressMonitor);
                        return;
                    }
                    jProject = JavaCore.create((IProject)resource.getProject());
                    try {
                        IPackageFragment pkgFragment = jProject.findPackageFragment(resource.getFullPath().removeLastSegments(1));
                        pkgRoot = pkgFragment != null ? JavaModelUtil.getPackageFragmentRoot((IJavaElement)pkgFragment) : this.findPackageFragmentRoot(jProject, resource.getFullPath().removeLastSegments(1));
                    }
                    catch (JavaModelException ex) {
                        this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_javaPackageNotDeterminable, (Object)BasicElementLabels.getPathLabel((IPath)resource.getFullPath(), (boolean)false)), ex);
                        return;
                    }
                }
            }
            if (pkgRoot != null && jProject != null) {
                leadSegmentsToRemove = pkgRoot.getPath().segmentCount();
                boolean isOnBuildPath = jProject.isOnClasspath(resource);
                if (!isOnBuildPath || this.mustUseSourceFolderHierarchy() && !"".equals(pkgRoot.getElementName())) {
                    --leadSegmentsToRemove;
                }
            }
            IPath destinationPath = resource.getFullPath().removeFirstSegments(leadSegmentsToRemove);
            if (typeRootElement != null) {
                this.exportClassFiles(progressMonitor, typeRootElement, destinationPath);
            }
            this.exportResource(progressMonitor, pkgRoot, isInJavaProject, resource, destinationPath);
            progressMonitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
        } else {
            this.exportContainer(progressMonitor, (IContainer)resource);
        }
    }

    private void exportJavaElement(IProgressMonitor progressMonitor, IJavaElement je) throws InterruptedException {
        if (je.getElementType() == 3 && ((IPackageFragmentRoot)je).isArchive()) {
            block19: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)je;
                ZipFile jarFile = null;
                try {
                    try {
                        jarFile = JarPackagerUtil.getArchiveFile((IPath)root.getPath());
                        this.fJarBuilder.writeArchive(jarFile, progressMonitor);
                    }
                    catch (CoreException e) {
                        this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_OpenZipFileError_message, (Object[])new Object[]{JavaElementLabels.getElementLabel((IJavaElement)root, (long)JavaElementLabels.ALL_DEFAULT), e.getLocalizedMessage()}), e);
                        try {
                            if (jarFile != null) {
                                jarFile.close();
                            }
                            break block19;
                        }
                        catch (IOException e2) {
                            this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_CloseZipFileError_message, (Object[])new Object[]{JavaElementLabels.getElementLabel((IJavaElement)root, (long)JavaElementLabels.ALL_DEFAULT), e2.getLocalizedMessage()}), e2);
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException e) {
                        this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_CloseZipFileError_message, (Object[])new Object[]{JavaElementLabels.getElementLabel((IJavaElement)root, (long)JavaElementLabels.ALL_DEFAULT), e.getLocalizedMessage()}), e);
                    }
                    throw throwable;
                }
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException e) {
                    this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_CloseZipFileError_message, (Object[])new Object[]{JavaElementLabels.getElementLabel((IJavaElement)root, (long)JavaElementLabels.ALL_DEFAULT), e.getLocalizedMessage()}), e);
                }
            }
            return;
        }
        if (je.getElementType() == 3 && ((IPackageFragmentRoot)je).isExternal()) {
            if (this.fJarBuilder instanceof IJarBuilderExtension) {
                this.exportExternalClassFolder((IPackageFragmentRoot)je, progressMonitor);
            } else {
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_canNotExportExternalClassFolder_warning, (Object)BasicElementLabels.getPathLabel((IPath)je.getPath(), (boolean)true)), null);
            }
            return;
        }
        Object[] objectArray = this.fJavaElementContentProvider.getChildren((Object)je);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.exportElement(child, progressMonitor);
            ++n2;
        }
    }

    private void exportExternalClassFolder(IPackageFragmentRoot classFolder, IProgressMonitor progressMonitor) throws InterruptedException {
        try {
            IJavaElement[] iJavaElementArray = classFolder.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.exportExternalClassFolderElement(child, classFolder.getPath(), progressMonitor);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            this.addToStatus((CoreException)((Object)e));
        }
    }

    private void exportExternalClassFolderElement(IJavaElement javaElement, IPath classFolderPath, IProgressMonitor progressMonitor) throws JavaModelException, InterruptedException {
        if (javaElement instanceof IClassFile) {
            IClassFile classFile = (IClassFile)javaElement;
            IPath path = classFile.getPath();
            IPath destination = path.removeFirstSegments(classFolderPath.segmentCount()).setDevice(null);
            try {
                try {
                    ((IJarBuilderExtension)this.fJarBuilder).writeFile(path.toFile(), destination);
                }
                catch (CoreException e) {
                    this.handleCoreExceptionOnExport(e);
                    progressMonitor.worked(1);
                    ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                }
            }
            finally {
                progressMonitor.worked(1);
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
            }
        } else if (javaElement instanceof IPackageFragment) {
            IJavaElement[] iJavaElementArray = ((IPackageFragment)javaElement).getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.exportExternalClassFolderElement(child, classFolderPath, progressMonitor);
                ++n2;
            }
        }
    }

    private void exportResource(IProgressMonitor progressMonitor, IResource resource, int leadingSegmentsToRemove) throws InterruptedException {
        block9: {
            block8: {
                IResource[] children;
                if (!(resource instanceof IContainer)) break block8;
                IContainer container = (IContainer)resource;
                try {
                    children = container.members();
                }
                catch (CoreException e) {
                    this.addWarning(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_errorDuringExport, container.getFullPath()), e);
                    return;
                }
                int i = 0;
                while (i < children.length) {
                    this.exportResource(progressMonitor, children[i], leadingSegmentsToRemove);
                    ++i;
                }
                break block9;
            }
            if (!(resource instanceof IFile)) break block9;
            try {
                try {
                    IPath destinationPath = resource.getFullPath().removeFirstSegments(leadingSegmentsToRemove);
                    progressMonitor.subTask(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_exporting, destinationPath.toString()));
                    this.fJarBuilder.writeFile((IFile)resource, destinationPath);
                }
                catch (CoreException ex) {
                    this.handleCoreExceptionOnExport(ex);
                    progressMonitor.worked(1);
                    ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
                }
            }
            finally {
                progressMonitor.worked(1);
                ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
            }
        }
    }

    private void exportContainer(IProgressMonitor progressMonitor, IContainer container) throws InterruptedException {
        if (container.getType() == 2 && this.isOutputFolder((IFolder)container)) {
            return;
        }
        IResource[] children = null;
        try {
            children = container.members();
        }
        catch (CoreException e) {
            this.addWarning(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_errorDuringExport, container.getFullPath()), e);
        }
        if (children != null) {
            IJavaProject javaProject = JavaCore.create((IProject)container.getProject());
            boolean isOnCP = javaProject.isOnClasspath((IResource)container);
            IResource[] iResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (isOnCP || !javaProject.isOnClasspath(child) || this.isInternalJar(child)) {
                    this.exportElement(child, progressMonitor);
                }
                ++n2;
            }
        }
    }

    private boolean isInternalJar(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        IJavaElement je = JavaCore.create((IResource)resource);
        if (je == null || je.getElementType() != 3) {
            return false;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)je;
        return root.isArchive() && !root.isExternal();
    }

    private IPackageFragmentRoot findPackageFragmentRoot(IJavaProject jProject, IPath path) throws JavaModelException {
        if (jProject == null || path == null || path.segmentCount() <= 0) {
            return null;
        }
        IPackageFragmentRoot pkgRoot = jProject.findPackageFragmentRoot(path);
        if (pkgRoot != null) {
            return pkgRoot;
        }
        return this.findPackageFragmentRoot(jProject, path.removeLastSegments(1));
    }

    private void exportResource(IProgressMonitor progressMonitor, IPackageFragmentRoot pkgRoot, boolean isInJavaProject, IResource resource, IPath destinationPath) {
        if (this.fJarPackage.areClassFilesExported() && destinationPath.toString().equals("META-INF/MANIFEST.MF")) {
            if (this.fJarPackage.isManifestGenerated()) {
                this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_didNotAddManifestToJar, (Object[])new Object[]{resource.getFullPath()}), null);
            }
            return;
        }
        boolean isNonJavaResource = !isInJavaProject || pkgRoot == null;
        boolean isInClassFolder = false;
        try {
            isInClassFolder = pkgRoot != null && !pkgRoot.isArchive() && pkgRoot.getKind() == 2;
        }
        catch (JavaModelException ex) {
            this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_cantGetRootKind, (Object[])new Object[]{resource.getFullPath()}), ex);
        }
        if (this.fJarPackage.areClassFilesExported() && (isNonJavaResource || pkgRoot != null && !this.isJavaFile(resource) && !this.isClassFile(resource) || isInClassFolder && this.isClassFile(resource)) || this.fJarPackage.areJavaFilesExported() && (isNonJavaResource || pkgRoot != null && !this.isClassFile(resource) || isInClassFolder && this.isClassFile(resource) && !this.fJarPackage.areClassFilesExported())) {
            try {
                progressMonitor.subTask(Messages.format((String)JarPackagerMessages.JarFileExportOperation_exporting, (Object[])new Object[]{resource.getFullPath()}));
                this.fJarBuilder.writeFile((IFile)resource, destinationPath);
            }
            catch (CoreException ex) {
                this.handleCoreExceptionOnExport(ex);
            }
        }
    }

    private boolean isOutputFolder(IFolder folder) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)folder.getProject());
            IPath outputFolderPath = javaProject.getOutputLocation();
            return folder.getFullPath().equals((Object)outputFolderPath);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void exportClassFiles(IProgressMonitor progressMonitor, ITypeRoot typeRootElement, IPath destinationPath) {
        if (this.fJarPackage.areClassFilesExported()) {
            try {
                if (!typeRootElement.exists()) {
                    return;
                }
                Iterator<? extends IResource> iter = this.filesOnClasspath(typeRootElement, destinationPath, progressMonitor);
                IPath baseDestinationPath = destinationPath.removeLastSegments(1);
                while (iter.hasNext()) {
                    IFile file = (IFile)iter.next();
                    IPath classFilePath = baseDestinationPath.append(file.getName());
                    progressMonitor.subTask(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_exporting, classFilePath.toString()));
                    try {
                        this.fJarBuilder.writeFile(file, classFilePath);
                    }
                    catch (CoreException ex) {
                        this.handleCoreExceptionOnExport(ex);
                    }
                }
            }
            catch (CoreException ex) {
                this.addToStatus(ex);
            }
        }
    }

    protected void exportSelectedElements(IProgressMonitor progressMonitor) throws InterruptedException {
        this.fExportedClassContainers = new HashSet(10);
        HashSet<IJavaProject> enclosingJavaProjects = new HashSet<IJavaProject>(10);
        int n = this.fJarPackage.getElements().length;
        int i = 0;
        while (i < n) {
            IJavaProject javaProject;
            Object element = this.fJarPackage.getElements()[i];
            this.exportElement(element, progressMonitor);
            if (this.fJarPackage.areOutputFoldersExported() && (javaProject = this.getEnclosingJavaProject(element)) != null) {
                enclosingJavaProjects.add(javaProject);
            }
            ++i;
        }
        if (this.fJarPackage.areOutputFoldersExported()) {
            this.exportOutputFolders(progressMonitor, enclosingJavaProjects);
        }
    }

    private IJavaProject getEnclosingJavaProject(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getJavaProject();
        }
        if (element instanceof IResource) {
            IProject project = ((IResource)element).getProject();
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException ex) {
                this.addWarning(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_projectNatureNotDeterminable, project.getFullPath()), ex);
            }
        }
        return null;
    }

    private void exportOutputFolders(IProgressMonitor progressMonitor, Set javaProjects) throws InterruptedException {
        if (javaProjects == null) {
            return;
        }
        for (IJavaProject javaProject : javaProjects) {
            IContainer[] outputContainers;
            try {
                outputContainers = this.getOutputContainers(javaProject);
            }
            catch (CoreException ex) {
                this.addToStatus(ex);
                continue;
            }
            int i = 0;
            while (i < outputContainers.length) {
                this.exportResource(progressMonitor, (IResource)outputContainers[i], outputContainers[i].getFullPath().segmentCount());
                ++i;
            }
        }
    }

    private IContainer[] getOutputContainers(IJavaProject javaProject) throws CoreException {
        HashSet<IPath> outputPaths = new HashSet<IPath>();
        boolean includeDefaultOutputPath = false;
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IClasspathEntry cpEntry;
            if (roots[i] != null && (cpEntry = roots[i].getRawClasspathEntry()).getEntryKind() == 3) {
                IPath location = cpEntry.getOutputLocation();
                if (location != null) {
                    outputPaths.add(location);
                } else {
                    includeDefaultOutputPath = true;
                }
            }
            ++i;
        }
        if (includeDefaultOutputPath) {
            outputPaths.add(javaProject.getOutputLocation());
        }
        HashSet<Object> outputContainers = new HashSet<Object>(outputPaths.size());
        for (IPath path : outputPaths) {
            if (javaProject.getProject().getFullPath().equals((Object)path)) {
                outputContainers.add(javaProject.getProject());
                continue;
            }
            IFolder outputFolder = this.createFolderHandle(path);
            if (outputFolder == null || !outputFolder.isAccessible()) {
                String msg = JarPackagerMessages.JarFileExportOperation_outputContainerNotAccessible;
                this.addToStatus(new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, msg, null)));
                continue;
            }
            outputContainers.add(outputFolder);
        }
        return outputContainers.toArray(new IContainer[outputContainers.size()]);
    }

    private Iterator<? extends IResource> filesOnClasspath(ITypeRoot typeRootElement, IPath pathInJar, IProgressMonitor progressMonitor) throws CoreException {
        ArrayList<IResource> classFileList;
        String msg;
        String lastSegment;
        IProject outputContainer;
        IClasspathEntry cpEntry;
        IFile file = (IFile)typeRootElement.getResource();
        IJavaProject javaProject = typeRootElement.getJavaProject();
        IPackageFragmentRoot pkgRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)typeRootElement);
        IFile[] classFiles = this.fJarPackage.findClassfilesFor(file);
        if (classFiles != null) {
            return Arrays.asList(classFiles).iterator();
        }
        if (!this.isJavaFile((IResource)file)) {
            return Collections.EMPTY_LIST.iterator();
        }
        IPath outputPath = null;
        if (pkgRoot != null && (cpEntry = pkgRoot.getRawClasspathEntry()).getEntryKind() == 3) {
            outputPath = cpEntry.getOutputLocation();
        }
        if (outputPath == null) {
            outputPath = javaProject.getOutputLocation();
        }
        if (javaProject.getProject().getFullPath().equals((Object)outputPath)) {
            outputContainer = javaProject.getProject();
        } else {
            outputContainer = this.createFolderHandle(outputPath);
            if (outputContainer == null || !outputContainer.isAccessible()) {
                String msg2 = JarPackagerMessages.JarFileExportOperation_outputContainerNotAccessible;
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, msg2, null));
            }
        }
        boolean hasErrors = this.hasCompileErrors((IResource)file);
        boolean hasWarnings = this.hasCompileWarnings((IResource)file);
        boolean canBeExported = this.canBeExported(hasErrors, hasWarnings);
        this.reportPossibleCompileProblems(file, hasErrors, hasWarnings, canBeExported);
        if (!canBeExported) {
            return Collections.EMPTY_LIST.iterator();
        }
        IProject classContainer = outputContainer;
        if (!(pathInJar.segmentCount() <= 1 || "module-info.java".equals(lastSegment = pathInJar.segment(pathInJar.segmentCount() - 1)) && JavaModelUtil.is9OrHigher((IJavaProject)javaProject))) {
            classContainer = outputContainer.getFolder(pathInJar.removeLastSegments(1));
        }
        if (this.fExportedClassContainers.contains(classContainer)) {
            return Collections.EMPTY_LIST.iterator();
        }
        if ("do not generate".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.debug.sourceFile", true))) {
            IRegion region = JavaCore.newRegion();
            region.add((IJavaElement)typeRootElement);
            IResource[] generatedResources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
            if (generatedResources.length > 0) {
                return Arrays.asList(generatedResources).iterator();
            }
        }
        if (this.fClassFilesMapContainer == null || !this.fClassFilesMapContainer.equals((Object)classContainer)) {
            this.fJavaNameToClassFilesMap = this.buildJavaToClassMap((IContainer)classContainer, progressMonitor);
            if (this.fJavaNameToClassFilesMap == null) {
                String containerName = BasicElementLabels.getPathLabel((IPath)classContainer.getFullPath(), (boolean)false);
                msg = Messages.format((String)JarPackagerMessages.JarFileExportOperation_missingSourceFileAttributeExportedAll, (Object)containerName);
                this.addInfo(msg, null);
                this.fExportedClassContainers.add(classContainer);
                return this.getClassesIn((IContainer)classContainer);
            }
            this.fClassFilesMapContainer = classContainer;
        }
        if ((classFileList = this.fJavaNameToClassFilesMap.get(file.getName())) == null || classFileList.isEmpty()) {
            msg = Messages.format((String)JarPackagerMessages.JarFileExportOperation_classFileOnClasspathNotAccessible, (Object)BasicElementLabels.getPathLabel((IPath)file.getFullPath(), (boolean)false));
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, msg, null));
        }
        return classFileList.iterator();
    }

    private Iterator getClassesIn(IContainer classContainer) throws CoreException {
        IResource[] resources = classContainer.members();
        ArrayList<IResource> files = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() == 1 && this.isClassFile(resources[i])) {
                files.add(resources[i]);
            }
            ++i;
        }
        return files.iterator();
    }

    boolean isJavaFile(IResource file) {
        return file != null && file.getType() == 1 && file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("java");
    }

    boolean isClassFile(IResource file) {
        return file != null && file.getType() == 1 && file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("class");
    }

    private Map<String, ArrayList<IResource>> buildJavaToClassMap(IContainer container, IProgressMonitor monitor) throws CoreException {
        if (container == null || !container.isAccessible()) {
            return new HashMap<String, ArrayList<IResource>>(0);
        }
        IClassFileReader cfReader = null;
        IResource[] members = container.members();
        HashMap<String, ArrayList<IResource>> map = new HashMap<String, ArrayList<IResource>>(members.length);
        int i = 0;
        while (i < members.length) {
            IFile classFile;
            URI location;
            if (this.isClassFile(members[i]) && (location = (classFile = (IFile)members[i]).getLocationURI()) != null) {
                InputStream contents = null;
                try {
                    contents = EFS.getStore((URI)location).openInputStream(0, monitor);
                    cfReader = ToolFactory.createDefaultClassFileReader((InputStream)contents, (int)17);
                }
                finally {
                    try {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, Messages.format((String)JarPackagerMessages.JarFileExportOperation_errorCannotCloseConnection, (Object)BasicElementLabels.getURLPart((String)Resources.getLocationString((IResource)classFile))), (Throwable)e));
                    }
                }
                if (cfReader != null) {
                    ISourceAttribute sourceAttribute = cfReader.getSourceFileAttribute();
                    if (sourceAttribute == null) {
                        this.addWarning(Messages.format((String)JarPackagerMessages.JarFileExportOperation_classFileWithoutSourceFileAttribute, (Object)BasicElementLabels.getURLPart((String)Resources.getLocationString((IResource)classFile))), null);
                        return null;
                    }
                    String javaName = new String(sourceAttribute.getSourceFileName());
                    ArrayList<IFile> classFiles = (ArrayList<IFile>)map.get(javaName);
                    if (classFiles == null) {
                        classFiles = new ArrayList<IFile>(3);
                        map.put(javaName, classFiles);
                    }
                    classFiles.add(classFile);
                }
            }
            ++i;
        }
        return map;
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        if (folderPath.isValidPath(folderPath.toString()) && folderPath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFolder(folderPath);
        }
        return null;
    }

    @Override
    public IStatus getStatus() {
        String message = null;
        switch (this.fStatus.getSeverity()) {
            case 0: {
                message = "";
                break;
            }
            case 1: {
                message = JarPackagerMessages.JarFileExportOperation_exportFinishedWithInfo;
                break;
            }
            case 2: {
                message = JarPackagerMessages.JarFileExportOperation_exportFinishedWithWarnings;
                break;
            }
            case 4: {
                if (this.fJarPackages.length > 1) {
                    message = JarPackagerMessages.JarFileExportOperation_creationOfSomeJARsFailed;
                    break;
                }
                message = JarPackagerMessages.JarFileExportOperation_jarCreationFailed;
                break;
            }
            default: {
                message = "";
            }
        }
        this.fStatus.setMessage(message);
        return this.fStatus;
    }

    protected boolean isDescendant(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendant(resources, (IResource)parent);
    }

    protected boolean canBeExported(boolean hasErrors, boolean hasWarnings) throws CoreException {
        return !hasErrors && !hasWarnings || hasErrors && this.fJarPackage.areErrorsExported() || hasWarnings && this.fJarPackage.exportWarnings();
    }

    protected void reportPossibleCompileProblems(IFile file, boolean hasErrors, boolean hasWarnings, boolean canBeExported) {
        if (hasErrors) {
            if (canBeExported) {
                this.addWarning(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_exportedWithCompileErrors, file.getFullPath()), null);
            } else {
                this.addWarning(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_notExportedDueToCompileErrors, file.getFullPath()), null);
            }
        }
        if (hasWarnings) {
            if (canBeExported) {
                this.addWarning(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_exportedWithCompileWarnings, file.getFullPath()), null);
            } else {
                this.addWarning(MessageFormat.format(JarPackagerMessages.JarFileExportOperation_notExportedDueToCompileWarnings, file.getFullPath()), null);
            }
        }
    }

    protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        int count = this.fJarPackages.length;
        progressMonitor.beginTask("", count);
        try {
            int i = 0;
            while (i < count) {
                SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 1, 4);
                this.fJarPackage = this.fJarPackages[i];
                if (this.fJarPackage != null) {
                    this.singleRun((IProgressMonitor)subProgressMonitor);
                }
                ++i;
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    /*
     * Exception decompiling
     */
    public void singleRun(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean preconditionsOK() {
        if (!this.fJarPackage.areGeneratedFilesExported() && !this.fJarPackage.areJavaFilesExported()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_noExportTypeChosen, null);
            return false;
        }
        if (this.fJarPackage.getElements() == null || this.fJarPackage.getElements().length == 0) {
            this.addError(JarPackagerMessages.JarFileExportOperation_noResourcesSelected, null);
            return false;
        }
        if (this.fJarPackage.getJarLocation() == null) {
            this.addError(JarPackagerMessages.JarFileExportOperation_invalidJarLocation, null);
            return false;
        }
        IRemotePath destLocation = this.fJarPackage.getRemoteJarLocation();
        IRemoteFile targetFile = destLocation.toRemoteFile();
        targetFile.markStale(true);
        targetFile = destLocation.toRemoteFile();
        if (targetFile != null && targetFile.exists() && !targetFile.canWrite()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_jarFileExistsAndNotWritable, null);
            return false;
        }
        if (!this.fJarPackage.isManifestAccessible()) {
            this.addError(JarPackagerMessages.JarFileExportOperation_manifestDoesNotExist, null);
            return false;
        }
        if (!this.fJarPackage.isMainClassValid(new RemoteJavaBusyIndicatorRunnableContext())) {
            this.addError(JarPackagerMessages.JarFileExportOperation_invalidMainClass, null);
            return false;
        }
        if (this.fParentShell == null) {
            return true;
        }
        if (this.fParentShell != null) {
            final boolean[] res = new boolean[1];
            this.fParentShell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    RefactoringSaveHelper refactoringSaveHelper = new RefactoringSaveHelper(1);
                    res[0] = refactoringSaveHelper.saveEditors(RemoteJarFileExportOperation.this.fParentShell);
                    RemoteJarFileExportOperation.this.fFilesSaved = refactoringSaveHelper.hasFilesSaved();
                }
            });
            if (!res[0]) {
                this.addError(JarPackagerMessages.JarFileExportOperation_fileUnsaved, null);
                return false;
            }
        }
        return true;
    }

    protected void saveFiles() {
        if (this.fJarPackage.areGeneratedFilesExported() && this.fJarPackage.isManifestGenerated() && this.fJarPackage.isManifestSaved()) {
            try {
                this.saveManifest();
            }
            catch (CoreException ex) {
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingManifest, ex);
            }
            catch (IOException ex) {
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingManifest, ex);
            }
        }
        if (this.fJarPackage.isDescriptionSaved()) {
            try {
                this.saveDescription();
            }
            catch (CoreException ex) {
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingDescription, ex);
            }
            catch (IOException ex) {
                this.addError(JarPackagerMessages.JarFileExportOperation_errorSavingDescription, ex);
            }
        }
    }

    protected void saveDescription() throws CoreException, IOException {
        if (this.fJarPackage.isManifestReused()) {
            this.fJarPackage.setGenerateManifest(false);
        }
        ByteArrayOutputStream objectStreamOutput = new ByteArrayOutputStream();
        IRemoteJarDescriptionWriter writer = this.fJarPackage.createJarDescriptionWriter(objectStreamOutput);
        ByteArrayInputStream fileInput = null;
        try {
            writer.write(this.fJarPackage);
            fileInput = new ByteArrayInputStream(objectStreamOutput.toByteArray());
            IFile descriptionFile = this.fJarPackage.getDescriptionFile();
            if (descriptionFile.isAccessible()) {
                if (this.fJarPackage.allowOverwrite() || RemoteJarExporterUtil.askForOverwritePermission(this.fParentShell, descriptionFile.getFullPath().toString())) {
                    descriptionFile.setContents((InputStream)fileInput, true, true, null);
                }
            } else {
                IResource variant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(descriptionFile.getFullPath());
                if (variant == null) {
                    IContainer parent = descriptionFile.getParent();
                    if (parent != null) {
                        IResource parentVariant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(parent.getFullPath());
                        if (parentVariant == null) {
                            descriptionFile.create((InputStream)fileInput, true, null);
                        } else {
                            IPath newPath = parentVariant.getFullPath().append(descriptionFile.getName());
                            IFile newDescriptionFile = RSEUIPlugin.getWorkspace().getRoot().getFile(newPath);
                            newDescriptionFile.create((InputStream)fileInput, true, null);
                        }
                    }
                } else if (variant instanceof IFile) {
                    ((IFile)variant).setContents((InputStream)fileInput, true, true, null);
                }
            }
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void saveManifest() throws CoreException, IOException {
        ByteArrayOutputStream manifestOutput = new ByteArrayOutputStream();
        ByteArrayInputStream fileInput = null;
        try {
            Manifest manifest = this.fJarPackage.getManifestProvider().create((JarPackageData)this.fJarPackage);
            manifest.write(manifestOutput);
            fileInput = new ByteArrayInputStream(manifestOutput.toByteArray());
            IFile manifestFile = this.fJarPackage.getManifestFile();
            if (manifestFile.isAccessible()) {
                if (this.fJarPackage.allowOverwrite() || RemoteJarExporterUtil.askForOverwritePermission(this.fParentShell, manifestFile.getFullPath().toString())) {
                    manifestFile.setContents((InputStream)fileInput, true, true, null);
                }
            } else {
                manifestFile.create((InputStream)fileInput, true, null);
            }
        }
        finally {
            if (manifestOutput != null) {
                manifestOutput.close();
            }
            if (fileInput != null) {
                fileInput.close();
            }
        }
    }

    private boolean isAutoBuilding() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    private void buildProjects(IProgressMonitor progressMonitor) {
        HashSet<IProject> builtProjects = new HashSet<IProject>(10);
        Object[] elements = this.fJarPackage.getElements();
        int i = 0;
        while (i < elements.length) {
            block10: {
                IProject project = null;
                Object element = elements[i];
                if (element instanceof IResource) {
                    project = ((IResource)element).getProject();
                } else if (element instanceof IJavaElement) {
                    project = ((IJavaElement)element).getJavaProject().getProject();
                }
                if (project != null && !builtProjects.contains(project)) {
                    try {
                        try {
                            project.build(10, progressMonitor);
                        }
                        catch (CoreException ex) {
                            String message = MessageFormat.format(JarPackagerMessages.JarFileExportOperation_errorDuringProjectBuild, project.getFullPath());
                            this.addError(message, ex);
                            builtProjects.add(project);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        builtProjects.add(project);
                        throw throwable;
                    }
                    builtProjects.add(project);
                }
            }
            ++i;
        }
    }

    private boolean hasCompileErrors(IResource resource) throws CoreException {
        IMarker[] problemMarkers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        int i = 0;
        while (i < problemMarkers.length) {
            if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleCoreExceptionOnExport(CoreException ex) {
        Throwable realEx = ex.getStatus().getException();
        if (realEx instanceof ZipException && realEx.getMessage() != null && realEx.getMessage().startsWith("duplicate entry:")) {
            this.addWarning(ex.getMessage(), realEx);
        } else {
            this.addToStatus(ex);
        }
    }

    private boolean hasCompileWarnings(IResource resource) throws CoreException {
        IMarker[] problemMarkers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        int i = 0;
        while (i < problemMarkers.length) {
            if (problemMarkers[i].getAttribute("severity", -1) == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean mustUseSourceFolderHierarchy() {
        return this.fJarPackage.useSourceFolderHierarchy() && this.fJarPackage.areJavaFilesExported() && !this.fJarPackage.areGeneratedFilesExported();
    }

    private static class MessageMultiStatus
    extends MultiStatus {
        MessageMultiStatus(String pluginId, int code, String message, Throwable exception) {
            super(pluginId, code, message, exception);
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }
    }
}

