/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import com.ibm.etools.systems.remoteJava.RemoteJavaPlugin;
import com.ibm.etools.systems.remoteJava.RemoteJavaResources;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.importexport.IRemoteImportExportConstants;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RemoteJarExporterUtil
implements IRemoteImportExportConstants {
    static final String JAR_EXTENSION = "jar";
    static final String DESCRIPTION_EXTENSION = "rmtjardesc";

    public static boolean askToCreateDirectory(Shell parent, File directory) {
        if (parent == null) {
            return false;
        }
        return RemoteJarExporterUtil.queryDialog(parent, JarPackagerMessages.JarPackage_confirmCreate_title, MessageFormat.format(JarPackagerMessages.JarPackage_confirmCreate_message, directory.toString()));
    }

    public static List asResources(Object[] fSelectedElements) {
        if (fSelectedElements == null) {
            return null;
        }
        ArrayList<Object> selectedResources = new ArrayList<Object>(fSelectedElements.length);
        int i = 0;
        while (i < fSelectedElements.length) {
            Object element = fSelectedElements[i];
            if (element instanceof IJavaElement) {
                selectedResources.add(((IJavaElement)element).getResource());
            } else if (element instanceof IResource) {
                selectedResources.add(element);
            }
            ++i;
        }
        return selectedResources;
    }

    public static boolean askForOverwritePermission(Shell parent, String filePath) {
        if (parent == null) {
            return false;
        }
        return RemoteJarExporterUtil.queryDialog(parent, JarPackagerMessages.JarPackage_confirmReplace_title, MessageFormat.format(JarPackagerMessages.JarPackage_confirmReplace_message, filePath));
    }

    public static boolean askForRemoteOverwritePermission(Shell parent, String filePath, String hostName) {
        if (parent == null) {
            return false;
        }
        String t1 = NLS.bind((String)RemoteJavaResources.RESID_EXPORT_OVERWRITE, (Object)filePath, (Object)hostName);
        String t2 = RemoteJavaResources.RESID_EXPORT_OVERWRITE_DETAILS;
        SimpleSystemMessage msg = new SimpleSystemMessage("com.ibm.etools.systems.remoteJava", 1, t1, t2);
        msg.setIndicator('Q');
        return RemoteJarExporterUtil.remoteQueryDialog(parent, (SystemMessage)msg);
    }

    static boolean canOverwrite(Shell parent, IFile file) {
        if (file.isAccessible()) {
            return true;
        }
        return RemoteJarExporterUtil.askForOverwritePermission(parent, file.getFullPath().toString());
    }

    static String getMainClassName(RemoteJarPackageData jarPackage) {
        if (jarPackage.getManifestMainClass() == null) {
            return "";
        }
        return jarPackage.getManifestMainClass().getFullyQualifiedName();
    }

    private static boolean queryDialog(final Shell parent, final String title, final String message) {
        Display display = parent.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] returnValue = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                returnValue[0] = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
            }
        };
        display.syncExec(runnable);
        return returnValue[0];
    }

    private static boolean remoteQueryDialog(final Shell parent, final SystemMessage message) {
        Display display = parent.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] returnValue = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SystemMessageDialog dialog = new SystemMessageDialog(parent, message);
                returnValue[0] = dialog.openQuestionNoException();
            }
        };
        display.syncExec(runnable);
        return returnValue[0];
    }

    public static CoreException createCoreException(String message, Exception ex) {
        if (message == null) {
            message = "";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 10001, message, (Throwable)ex));
    }

    public static boolean isMainClassValid(RemoteJarPackageData data, IRunnableContext context) {
        IType mainClass;
        block5: {
            if (data == null) {
                return false;
            }
            mainClass = data.getManifestMainClass();
            if (mainClass == null) {
                return true;
            }
            try {
                IFile file = (IFile)mainClass.getResource();
                if (file != null && RemoteJarExporterUtil.contains(RemoteJarExporterUtil.asResources(data.getElements()), file)) break block5;
                return false;
            }
            catch (JavaModelException e) {
                RemoteJavaPlugin.logError((String)e.getStatus().getMessage(), (Throwable)e.getStatus().getException());
                return false;
            }
        }
        return JavaModelUtil.hasMainMethod((IType)mainClass);
    }

    static boolean contains(List resources, IFile file) {
        if (resources == null || file == null) {
            return false;
        }
        if (resources.contains(file)) {
            return true;
        }
        for (IResource resource : resources) {
            if (resource == null || resource.getType() == 1) continue;
            List<IResource> children = null;
            try {
                children = Arrays.asList(((IContainer)resource).members());
            }
            catch (CoreException coreException) {
                continue;
            }
            if (children == null || !RemoteJarExporterUtil.contains(children, file)) continue;
            return true;
        }
        return false;
    }
}

