/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.IRemoteJarDescriptionWriter;
import com.ibm.etools.systems.importexport.jar.RemoteJarExporterUtil;
import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import com.ibm.etools.systems.remoteJava.RemoteJavaResources;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RemoteJarExportWriter
implements IRemoteJarDescriptionWriter {
    protected OutputStream fOutputStream;

    public RemoteJarExportWriter(OutputStream outputStream) {
        Assert.isNotNull((Object)outputStream);
        this.fOutputStream = new BufferedOutputStream(outputStream);
    }

    @Override
    public void write(RemoteJarPackageData jarPackage) throws CoreException {
        try {
            this.writeXML(jarPackage);
        }
        catch (IOException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, (Throwable)ex));
        }
    }

    public void writeXML(RemoteJarPackageData jarPackage) throws IOException {
        Assert.isNotNull((Object)((Object)jarPackage));
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(RemoteJavaResources.RemoteJarExportErrorCouldNotGetXmlBuilder);
        }
        Document document = docBuilder.newDocument();
        Element xmlJarDesc = document.createElement("rmtjardesc");
        document.appendChild(xmlJarDesc);
        this.xmlWriteJarLocation(jarPackage, document, xmlJarDesc);
        this.xmlWriteOptions(jarPackage, document, xmlJarDesc);
        if (jarPackage.areGeneratedFilesExported()) {
            this.xmlWriteManifest(jarPackage, document, xmlJarDesc);
        }
        this.xmlWriteSelectedElements(jarPackage, document, xmlJarDesc);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(this.fOutputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
            throw new IOException(RemoteJavaResources.RemoteJarExportErrorCouldNotTransformToXML);
        }
    }

    private void xmlWriteJarLocation(RemoteJarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element jar = document.createElement("jar");
        xmlJarDesc.appendChild(jar);
        jar.setAttribute("path", jarPackage.getRemoteJarLocation().getFullyQualifiedPath());
    }

    private void xmlWriteOptions(RemoteJarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element options = document.createElement("options");
        xmlJarDesc.appendChild(options);
        options.setAttribute("overwrite", "" + jarPackage.allowOverwrite());
        options.setAttribute("compress", "" + jarPackage.isCompressed());
        options.setAttribute("exportErrors", "" + jarPackage.areErrorsExported());
        options.setAttribute("exportWarnings", "" + jarPackage.exportWarnings());
        options.setAttribute("saveDescription", "" + jarPackage.isDescriptionSaved());
        options.setAttribute("descriptionLocation", jarPackage.getDescriptionLocation().toString());
        options.setAttribute("useSourceFolders", "" + jarPackage.useSourceFolderHierarchy());
        options.setAttribute("buildIfNeeded", "" + jarPackage.isBuildingIfNeeded());
    }

    private void xmlWriteManifest(RemoteJarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element manifest = document.createElement("manifest");
        xmlJarDesc.appendChild(manifest);
        manifest.setAttribute("manifestVersion", jarPackage.getManifestVersion());
        manifest.setAttribute("usesManifest", "" + jarPackage.usesManifest());
        manifest.setAttribute("reuseManifest", "" + jarPackage.isManifestReused());
        manifest.setAttribute("saveManifest", "" + jarPackage.isManifestSaved());
        manifest.setAttribute("generateManifest", "" + jarPackage.isManifestGenerated());
        manifest.setAttribute("manifestLocation", jarPackage.getManifestLocation().toString());
        if (jarPackage.getManifestMainClass() != null) {
            manifest.setAttribute("mainClassHandleIdentifier", jarPackage.getManifestMainClass().getHandleIdentifier());
        }
        this.xmlWriteSealingInfo(jarPackage, document, manifest);
    }

    private void xmlWriteSealingInfo(RemoteJarPackageData jarPackage, Document document, Element manifest) throws DOMException {
        Element sealing = document.createElement("sealing");
        manifest.appendChild(sealing);
        sealing.setAttribute("sealJar", "" + jarPackage.isJarSealed());
        Element packagesToSeal = document.createElement("packagesToSeal");
        sealing.appendChild(packagesToSeal);
        this.add(jarPackage.getPackagesToSeal(), packagesToSeal, document);
        Element packagesToUnSeal = document.createElement("packagesToUnSeal");
        sealing.appendChild(packagesToUnSeal);
        this.add(jarPackage.getPackagesToUnseal(), packagesToUnSeal, document);
    }

    private void xmlWriteSelectedElements(RemoteJarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element selectedElements = document.createElement("selectedElements");
        xmlJarDesc.appendChild(selectedElements);
        selectedElements.setAttribute("exportClassFiles", "" + jarPackage.areClassFilesExported());
        selectedElements.setAttribute("exportOutputFolder", "" + jarPackage.areOutputFoldersExported());
        selectedElements.setAttribute("exportJavaFiles", "" + jarPackage.areJavaFilesExported());
        Object[] elements = jarPackage.getElements();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IResource) {
                this.add((IResource)element, selectedElements, document);
            } else if (element instanceof IJavaElement) {
                this.add((IJavaElement)element, selectedElements, document);
            }
            ++i;
        }
    }

    public void writeString(RemoteJarPackageData jarPackage) throws IOException {
        Assert.isNotNull((Object)((Object)jarPackage));
        OutputStreamWriter streamWriter = new OutputStreamWriter(this.fOutputStream);
        BufferedWriter writer = new BufferedWriter(streamWriter);
        writer.write(RemoteJavaResources.RemoteJarExportOutputTitle);
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputExportBin, new Boolean(jarPackage.areClassFilesExported())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputExportOutputFolders, new Boolean(jarPackage.areOutputFoldersExported())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputExportJava, new Boolean(jarPackage.areJavaFilesExported())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputJarFileName, jarPackage.getRemoteJarLocation().getFullyQualifiedPath()));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputCompressed, new Boolean(jarPackage.isCompressed())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputOverwrite, new Boolean(jarPackage.allowOverwrite())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputSaveDescription, new Boolean(jarPackage.isDescriptionSaved())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputDescriptionFile, jarPackage.getDescriptionLocation()));
        writer.newLine();
        writer.write(RemoteJavaResources.RemoteJarExportOutputLineSeparator);
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputGenerateManifest, new Boolean(jarPackage.isManifestGenerated())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputSaveManifest, new Boolean(jarPackage.isManifestSaved())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputReuseManifest, new Boolean(jarPackage.isManifestReused())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputManifestName, jarPackage.getManifestLocation()));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputJarSealed, new Boolean(jarPackage.isJarSealed())));
        writer.newLine();
        writer.write(MessageFormat.format(RemoteJavaResources.RemoteJarExportOutputMainClass, RemoteJarExporterUtil.getMainClassName(jarPackage)));
        writer.flush();
    }

    @Override
    public void close() throws CoreException {
        if (this.fOutputStream != null) {
            try {
                this.fOutputStream.close();
            }
            catch (IOException ex) {
                String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, (Throwable)ex));
            }
        }
    }

    private void add(IResource resource, Element parent, Document document) {
        Element element = null;
        if (resource.getType() == 4) {
            element = document.createElement("project");
            parent.appendChild(element);
            element.setAttribute("name", resource.getName());
            return;
        }
        if (resource.getType() == 1) {
            element = document.createElement("file");
        } else if (resource.getType() == 2) {
            element = document.createElement("folder");
        }
        parent.appendChild(element);
        element.setAttribute("path", resource.getFullPath().toString());
    }

    private void add(IJavaElement javaElement, Element parent, Document document) {
        Element element = document.createElement("javaElement");
        parent.appendChild(element);
        element.setAttribute("handleIdentifier", javaElement.getHandleIdentifier());
    }

    private void add(IPackageFragment[] packages, Element parent, Document document) {
        int i = 0;
        while (i < packages.length) {
            Element pkg = document.createElement("package");
            parent.appendChild(pkg);
            pkg.setAttribute("handleIdentifier", packages[i].getHandleIdentifier());
            ++i;
        }
    }

    @Override
    public IStatus getStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    public void write(JarPackageData jarPackage) throws CoreException {
    }
}

