/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.IRemoteJarExportWizardPage;
import com.ibm.etools.systems.importexport.jar.RemoteJarExportWizard;
import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import com.ibm.etools.systems.remoteJava.RemoteJavaResources;
import com.ibm.etools.systems.remoteJava.RemoteJavaSWTUtil;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.internal.importexport.RemoteImportExportUtil;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class RemoteJarExportWizardOptionsPage
extends WizardPage
implements IRemoteJarExportWizardPage {
    private RemoteJarPackageData fJarPackage;
    private Button fExportErrorsCheckbox;
    private Button fExportWarningsCheckbox;
    private Button fUseSourceFoldersCheckbox;
    private Composite fDescriptionFileGroup;
    private Button fSaveDescriptionCheckbox;
    private Label fDescriptionFileLabel;
    private Text fDescriptionFileText;
    private Button fDescriptionFileBrowseButton;
    private Button fBuildIfNeededCheckbox;
    private static final String PAGE_NAME = "RemoteJarExportWizardOptionsPage";
    private static final String STORE_EXPORT_WARNINGS = "RemoteJarExportWizardOptionsPage.EXPORT_WARNINGS";
    private static final String STORE_EXPORT_ERRORS = "RemoteJarExportWizardOptionsPage.EXPORT_ERRORS";
    private static final String STORE_SAVE_DESCRIPTION = "RemoteJarExportWizardOptionsPage.SAVE_DESCRIPTION";
    private static final String STORE_DESCRIPTION_LOCATION = "RemoteJarExportWizardOptionsPage.DESCRIPTION_LOCATION";
    private static final String STORE_USE_SRC_FOLDERS = "RemoteJarExportWizardOptionsPage.STORE_USE_SRC_FOLDERS";
    private static final String STORE_BUILD_IF_NEEDED = "RemoteJarExportWizardOptionsPage.BUILD_IF_NEEDED";

    public RemoteJarExportWizardOptionsPage(RemoteJarPackageData jarPackage) {
        super(PAGE_NAME);
        this.setTitle(JarPackagerMessages.JarOptionsPage_title);
        this.setDescription(JarPackagerMessages.JarOptionsPage_description);
        this.fJarPackage = jarPackage;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.setControl((Control)composite);
        this.update();
        Dialog.applyDialogFont((Control)composite);
        RSEUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.jar_options_wizard_page_context");
    }

    protected void createOptionsGroup(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.createLabel(optionsGroup, JarPackagerMessages.JarOptionsPage_howTreatProblems_label, false);
        UntypedListener selectionListener = new UntypedListener();
        this.fExportErrorsCheckbox = new Button(optionsGroup, 16416);
        this.fExportErrorsCheckbox.setText(JarPackagerMessages.JarOptionsPage_exportErrors_text);
        this.fExportErrorsCheckbox.addListener(13, (Listener)selectionListener);
        this.fExportWarningsCheckbox = new Button(optionsGroup, 16416);
        this.fExportWarningsCheckbox.setText(JarPackagerMessages.JarOptionsPage_exportWarnings_text);
        this.fExportWarningsCheckbox.addListener(13, (Listener)selectionListener);
        this.createSpacer(optionsGroup);
        this.fUseSourceFoldersCheckbox = new Button(optionsGroup, 16416);
        this.fUseSourceFoldersCheckbox.setText(JarPackagerMessages.JarOptionsPage_useSourceFoldersHierarchy);
        this.fUseSourceFoldersCheckbox.addListener(13, (Listener)selectionListener);
        this.fUseSourceFoldersCheckbox.setEnabled(this.fJarPackage.areJavaFilesExported() && !this.fJarPackage.areGeneratedFilesExported());
        this.createSpacer(optionsGroup);
        this.fBuildIfNeededCheckbox = new Button(optionsGroup, 16416);
        this.fBuildIfNeededCheckbox.setText(JarPackagerMessages.JarOptionsPage_buildIfNeeded);
        this.fBuildIfNeededCheckbox.addListener(13, (Listener)selectionListener);
        this.createSpacer(optionsGroup);
        this.fSaveDescriptionCheckbox = new Button(optionsGroup, 16416);
        this.fSaveDescriptionCheckbox.setText(RemoteJavaResources.RESID_RMTJAREXP_SETTINGS_LABEL);
        this.fSaveDescriptionCheckbox.setToolTipText(RemoteJavaResources.RESID_RMTJAREXP_SETTINGS_TOOLTIP);
        this.fSaveDescriptionCheckbox.addListener(13, (Listener)selectionListener);
        this.createDescriptionFileGroup(parent);
    }

    public final void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_EXPORT_WARNINGS, this.fJarPackage.exportWarnings());
            settings.put(STORE_EXPORT_ERRORS, this.fJarPackage.areErrorsExported());
            settings.put(STORE_USE_SRC_FOLDERS, this.fJarPackage.useSourceFolderHierarchy());
            settings.put(STORE_BUILD_IF_NEEDED, this.fJarPackage.isBuildingIfNeeded());
            settings.put(STORE_SAVE_DESCRIPTION, this.fJarPackage.isDescriptionSaved());
            settings.put(STORE_DESCRIPTION_LOCATION, this.fJarPackage.getDescriptionLocation().toString());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((RemoteJarExportWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        this.fExportWarningsCheckbox.setSelection(this.fJarPackage.exportWarnings());
        this.fExportErrorsCheckbox.setSelection(this.fJarPackage.areErrorsExported());
        this.fBuildIfNeededCheckbox.setSelection(this.fJarPackage.isBuildingIfNeeded());
        this.fUseSourceFoldersCheckbox.setSelection(this.fJarPackage.useSourceFolderHierarchy());
        this.fSaveDescriptionCheckbox.setSelection(this.fJarPackage.isDescriptionSaved());
        this.fDescriptionFileText.setText(this.fJarPackage.getDescriptionLocation().toString());
    }

    protected void initializeJarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fJarPackage.setExportWarnings(settings.getBoolean(STORE_EXPORT_WARNINGS));
            this.fJarPackage.setExportErrors(settings.getBoolean(STORE_EXPORT_ERRORS));
            this.fJarPackage.setUseSourceFolderHierarchy(settings.getBoolean(STORE_USE_SRC_FOLDERS));
            this.fJarPackage.setSaveDescription(false);
            String pathStr = settings.get(STORE_DESCRIPTION_LOCATION);
            if (pathStr == null) {
                pathStr = "";
            }
            this.fJarPackage.setDescriptionLocation((IPath)new Path(pathStr));
            if (settings.get(STORE_BUILD_IF_NEEDED) != null) {
                this.fJarPackage.setBuildIfNeeded(settings.getBoolean(STORE_BUILD_IF_NEEDED));
            }
        }
    }

    private void update() {
        this.updateModel();
        this.updateWidgetEnablements();
        this.updatePageCompletion();
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        this.fJarPackage.setExportWarnings(this.fExportWarningsCheckbox.getSelection());
        this.fJarPackage.setExportErrors(this.fExportErrorsCheckbox.getSelection());
        this.fJarPackage.setBuildIfNeeded(this.fBuildIfNeededCheckbox.getSelection());
        this.fJarPackage.setSaveDescription(this.fSaveDescriptionCheckbox.getSelection());
        this.fJarPackage.setDescriptionLocation((IPath)new Path(this.fDescriptionFileText.getText()));
        this.fJarPackage.setUseSourceFolderHierarchy(this.fUseSourceFoldersCheckbox.getSelection());
    }

    protected void handleDescriptionFileBrowseButtonPressed() {
        SaveAsDialog dialog = new SaveAsDialog(this.getContainer().getShell());
        dialog.create();
        dialog.getShell().setText(JarPackagerMessages.JarOptionsPage_saveAsDialog_title);
        dialog.setMessage(JarPackagerMessages.JarOptionsPage_saveAsDialog_message);
        dialog.setOriginalFile(this.createFileHandle(this.fJarPackage.getDescriptionLocation()));
        if (dialog.open() == 0) {
            IPath path = dialog.getResult();
            path = path.removeFileExtension().addFileExtension("rmtjardesc");
            this.fDescriptionFileText.setText(path.toString());
        }
    }

    protected void updateWidgetEnablements() {
        boolean saveDescription = this.fSaveDescriptionCheckbox.getSelection();
        this.fDescriptionFileGroup.setEnabled(saveDescription);
        this.fDescriptionFileBrowseButton.setEnabled(saveDescription);
        this.fDescriptionFileText.setEnabled(saveDescription);
        this.fDescriptionFileLabel.setEnabled(saveDescription);
        boolean exportClassFiles = this.fJarPackage.areClassFilesExported() && !this.fJarPackage.areOutputFoldersExported();
        this.fExportWarningsCheckbox.setEnabled(exportClassFiles);
        this.fExportErrorsCheckbox.setEnabled(exportClassFiles);
        boolean isAutobuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        this.fBuildIfNeededCheckbox.setEnabled(exportClassFiles && !isAutobuilding);
        this.fUseSourceFoldersCheckbox.setEnabled(this.fJarPackage.areJavaFilesExported() && !this.fJarPackage.areGeneratedFilesExported());
    }

    public boolean isPageComplete() {
        if (this.fJarPackage.isDescriptionSaved()) {
            if (this.fJarPackage.getDescriptionLocation().toString().length() == 0) {
                this.setErrorMessage(null);
                return false;
            }
            IPath location = this.fJarPackage.getDescriptionLocation();
            if (!location.toString().startsWith("/")) {
                this.setErrorMessage(JarPackagerMessages.JarOptionsPage_error_descriptionMustBeAbsolute);
                return false;
            }
            IResource resource = this.findResource(location);
            if (resource != null && resource.getType() != 1) {
                this.setErrorMessage(JarPackagerMessages.JarOptionsPage_error_descriptionMustNotBeExistingContainer);
                return false;
            }
            resource = this.findResource(location.removeLastSegments(1));
            if (resource == null || resource.getType() == 1) {
                this.setErrorMessage(JarPackagerMessages.JarOptionsPage_error_descriptionContainerDoesNotExist);
                return false;
            }
            String fileExtension = this.fJarPackage.getDescriptionLocation().getFileExtension();
            if (fileExtension == null || !fileExtension.equals("rmtjardesc")) {
                this.setErrorMessage(MessageFormat.format(JarPackagerMessages.JarOptionsPage_error_invalidDescriptionExtension, "rmtjardesc"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.fJarPackage.areGeneratedFilesExported() && super.canFlipToNextPage();
    }

    protected void createDescriptionFileGroup(Composite parent) {
        this.fDescriptionFileGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.fDescriptionFileGroup.setLayout((Layout)layout);
        this.fDescriptionFileGroup.setLayoutData((Object)new GridData(784));
        this.fDescriptionFileLabel = new Label(this.fDescriptionFileGroup, 0);
        this.fDescriptionFileLabel.setText(JarPackagerMessages.JarOptionsPage_descriptionFile_label);
        this.fDescriptionFileText = new Text(this.fDescriptionFileGroup, 2052);
        this.fDescriptionFileText.addListener(24, (Listener)new UntypedListener());
        GridData data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.fDescriptionFileText.setLayoutData((Object)data);
        this.fDescriptionFileBrowseButton = new Button(this.fDescriptionFileGroup, 8);
        this.fDescriptionFileBrowseButton.setText(JarPackagerMessages.JarOptionsPage_browseButton_text);
        this.fDescriptionFileBrowseButton.setLayoutData((Object)new GridData(256));
        RemoteJavaSWTUtil.setButtonDimensionHint(this.fDescriptionFileBrowseButton);
        this.fDescriptionFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteJarExportWizardOptionsPage.this.handleDescriptionFileBrowseButtonPressed();
            }
        });
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return JavaPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        this.updateWidgetEnablements();
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    @Override
    public void finish() {
        this.saveWidgetValues();
    }

    protected Label createLabel(Composite parent, String text, boolean bold) {
        Label label = new Label(parent, 0);
        if (bold) {
            label.setFont(JFaceResources.getBannerFont());
        }
        label.setText(text);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = RSEUIPlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK()) {
            IWorkspaceRoot root = workspace.getRoot();
            if (root.exists(path)) {
                return root.findMember(path);
            }
            IResource variant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(path);
            if (variant != null) {
                return variant;
            }
        }
        return null;
    }

    private class UntypedListener
    implements Listener {
        private UntypedListener() {
        }

        public void handleEvent(Event e) {
            if (RemoteJarExportWizardOptionsPage.this.getControl() == null) {
                return;
            }
            RemoteJarExportWizardOptionsPage.this.update();
        }
    }
}

