/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.IRemoteJarExportWizardPage;
import com.ibm.etools.systems.importexport.jar.RemoteCheckboxTreeAndListGroup;
import com.ibm.etools.systems.importexport.jar.RemoteContainerFilter;
import com.ibm.etools.systems.importexport.jar.RemoteJarDestinationDialog;
import com.ibm.etools.systems.importexport.jar.RemoteJarExportWizard;
import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import com.ibm.etools.systems.remoteJava.RemoteJavaResources;
import com.ibm.etools.systems.remoteJava.RemoteJavaSWTUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.subsystems.files.core.model.RemotePath;
import org.eclipse.rse.subsystems.files.core.model.IRemotePath;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

public class RemoteJarExportWizardMainPage
extends WizardExportResourcesPage
implements IRemoteJarExportWizardPage {
    private RemoteJarPackageData fJarPackage;
    private IStructuredSelection fInitialSelection;
    private RemoteCheckboxTreeAndListGroup fInputGroup;
    private Text fSourceNameField;
    private Button fExportClassFilesCheckbox;
    private Button fExportOutputFoldersCheckbox;
    private Button fExportJavaFilesCheckbox;
    private Combo fDestinationNamesCombo;
    private Button fDestinationBrowseButton;
    private Button fCompressCheckbox;
    private Button fOverwriteCheckbox;
    private Text fDescriptionFileText;
    private static final String PAGE_NAME = "RemoteJarExportWizardMainPage";
    private static final String STORE_EXPORT_CLASS_FILES = "RemoteJarExportWizardMainPage.EXPORT_CLASS_FILES";
    private static final String STORE_EXPORT_OUTPUT_FOLDERS = "RemoteJarExportWizardMainPage.EXPORT_OUTPUT_FOLDER";
    private static final String STORE_EXPORT_JAVA_FILES = "RemoteJarExportWizardMainPage.EXPORT_JAVA_FILES";
    private static final String STORE_DESTINATION_NAMES = "RemoteJarExportWizardMainPage.DESTINATION_NAMES_ID";
    private static final String STORE_COMPRESS = "RemoteJarExportWizardMainPage.COMPRESS";
    private static final String STORE_OVERWRITE = "RemoteJarExportWizardMainPage.OVERWRITE";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 480;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;

    public RemoteJarExportWizardMainPage(RemoteJarPackageData jarPackage, IStructuredSelection selection) {
        super(PAGE_NAME, selection);
        this.setTitle(JarPackagerMessages.JarPackageWizardPage_title);
        this.setDescription(JarPackagerMessages.JarPackageWizardPage_description);
        this.fJarPackage = jarPackage;
        this.fInitialSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createPlainLabel(composite, JarPackagerMessages.JarPackageWizardPage_whatToExport_label);
        this.createInputGroup(composite);
        this.createExportTypeGroup(composite);
        new Label(composite, 0);
        this.createPlainLabel(composite, JarPackagerMessages.JarPackageWizardPage_whereToExport_label);
        this.createDestinationGroup(composite);
        this.createPlainLabel(composite, JarPackagerMessages.JarPackageWizardPage_options_label);
        this.createOptionsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.fInitialSelection != null) {
            BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    RemoteJarExportWizardMainPage.this.setupBasedOnInitialSelections();
                }
            });
        }
        this.setControl((Control)composite);
        this.update();
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite);
        RSEUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.jar_packager_wizard_page_context");
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.fCompressCheckbox = new Button(optionsGroup, 16416);
        this.fCompressCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_compress_text);
        this.fCompressCheckbox.addListener(13, (Listener)this);
        this.fOverwriteCheckbox = new Button(optionsGroup, 16416);
        this.fOverwriteCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_overwrite_text);
        this.fOverwriteCheckbox.addListener(13, (Listener)this);
    }

    protected String getDestinationValue() {
        String destinationText = this.fDestinationNamesCombo.getText().trim();
        if (destinationText.indexOf(46) < 0) {
            destinationText = String.valueOf(destinationText) + this.getOutputSuffix();
        }
        return destinationText;
    }

    public void setDestinationValue(String value) {
        if (value.length() > 0) {
            String[] currentItems = this.fDestinationNamesCombo.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length && selectionIndex < 0) {
                if (currentItems[i].equals(value)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = value;
                this.fDestinationNamesCombo.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.fDestinationNamesCombo.select(selectionIndex);
        }
    }

    protected String getDestinationLabel() {
        return JarPackagerMessages.JarPackageWizardPage_destination_label;
    }

    protected String getOutputSuffix() {
        return ".jar";
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.fInputGroup.getAllCheckedListItems();
    }

    public final void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES, directoryNames);
            settings.put(STORE_EXPORT_CLASS_FILES, this.fJarPackage.areClassFilesExported());
            settings.put(STORE_EXPORT_OUTPUT_FOLDERS, this.fJarPackage.areOutputFoldersExported());
            settings.put(STORE_EXPORT_JAVA_FILES, this.fJarPackage.areJavaFilesExported());
            settings.put(STORE_COMPRESS, this.fJarPackage.isCompressed());
            settings.put(STORE_OVERWRITE, this.fJarPackage.allowOverwrite());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        String fullyQualifiedPath;
        IRemotePath location;
        String[] directoryNames;
        if (!((RemoteJarExportWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        this.fExportClassFilesCheckbox.setSelection(this.fJarPackage.areClassFilesExported());
        this.fExportOutputFoldersCheckbox.setSelection(this.fJarPackage.areOutputFoldersExported());
        this.fExportJavaFilesCheckbox.setSelection(this.fJarPackage.areJavaFilesExported());
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (directoryNames = settings.getArray(STORE_DESTINATION_NAMES)) != null) {
            int i = 0;
            while (i < directoryNames.length) {
                this.fDestinationNamesCombo.add(directoryNames[i]);
                ++i;
            }
        }
        if ((location = this.fJarPackage.getRemoteJarLocation()) != null && (fullyQualifiedPath = location.getFullyQualifiedPath()) != null) {
            this.setDestinationValue(fullyQualifiedPath);
        }
        this.fCompressCheckbox.setSelection(this.fJarPackage.isCompressed());
        this.fOverwriteCheckbox.setSelection(this.fJarPackage.allowOverwrite());
    }

    protected void initializeJarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fJarPackage.setElements(this.getSelectedElements());
            this.fJarPackage.setExportClassFiles(settings.getBoolean(STORE_EXPORT_CLASS_FILES));
            this.fJarPackage.setExportOutputFolders(settings.getBoolean(STORE_EXPORT_OUTPUT_FOLDERS));
            this.fJarPackage.setExportJavaFiles(settings.getBoolean(STORE_EXPORT_JAVA_FILES));
            this.fJarPackage.setCompress(settings.getBoolean(STORE_COMPRESS));
            this.fJarPackage.setOverwrite(settings.getBoolean(STORE_OVERWRITE));
            String[] destinationNames = settings.getArray(STORE_DESTINATION_NAMES);
            if (destinationNames == null) {
                return;
            }
            this.fJarPackage.setRemoteJarLocation((IRemotePath)new RemotePath(destinationNames[0]));
        }
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        if (this.fExportClassFilesCheckbox.getSelection() && !this.fJarPackage.areClassFilesExported()) {
            this.fExportOutputFoldersCheckbox.setSelection(false);
        }
        if (this.fExportOutputFoldersCheckbox.getSelection() && !this.fJarPackage.areOutputFoldersExported()) {
            this.fExportClassFilesCheckbox.setSelection(false);
        }
        this.fJarPackage.setExportClassFiles(this.fExportClassFilesCheckbox.getSelection());
        this.fJarPackage.setExportOutputFolders(this.fExportOutputFoldersCheckbox.getSelection());
        this.fJarPackage.setExportJavaFiles(this.fExportJavaFilesCheckbox.getSelection());
        this.fJarPackage.setElements(this.getSelectedElements());
        String comboText = this.fDestinationNamesCombo.getText();
        RemotePath path = null;
        path = comboText.trim().equals("") ? null : new RemotePath(comboText);
        if (path != null && path.getFileExtension() == null) {
            path = path.addFileExtension("jar");
        }
        this.fJarPackage.setRemoteJarLocation((IRemotePath)path);
        this.fJarPackage.setCompress(this.fCompressCheckbox.getSelection());
        this.fJarPackage.setOverwrite(this.fOverwriteCheckbox.getSelection());
    }

    protected void createDestinationGroup(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        new Label(destinationSelectionGroup, 0).setText(this.getDestinationLabel());
        this.fDestinationNamesCombo = new Combo(destinationSelectionGroup, 2060);
        this.fDestinationNamesCombo.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fDestinationNamesCombo.setLayoutData((Object)data);
        this.fDestinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.fDestinationBrowseButton.setText(JarPackagerMessages.JarPackageWizardPage_browseButton_text);
        this.fDestinationBrowseButton.setLayoutData((Object)new GridData(256));
        RemoteJavaSWTUtil.setButtonDimensionHint(this.fDestinationBrowseButton);
        this.fDestinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteJarExportWizardMainPage.this.handleDestinationBrowseButtonPressed();
            }
        });
    }

    protected void handleDescriptionFileBrowseButtonPressed() {
        SaveAsDialog dialog = new SaveAsDialog(this.getContainer().getShell());
        dialog.create();
        dialog.getShell().setText(JarPackagerMessages.JarOptionsPage_saveAsDialog_title);
        dialog.setMessage(JarPackagerMessages.JarOptionsPage_saveAsDialog_message);
        dialog.setOriginalFile(this.createFileHandle(this.fJarPackage.getDescriptionLocation()));
        if (dialog.open() == 0) {
            IPath path = dialog.getResult();
            path = path.removeFileExtension().addFileExtension("rmtjardesc");
            this.fDescriptionFileText.setText(path.toString());
        }
    }

    protected void handleDestinationBrowseButtonPressed() {
        IRemoteFile remoteFile;
        int result;
        String dlgTitle = RemoteJavaResources.RESID_RMTJAREXP_FILEDIALOG_TITLE;
        RemoteJarDestinationDialog dialog = new RemoteJarDestinationDialog(this.getShell(), dlgTitle);
        String initialDestination = this.getDestinationValue();
        if (initialDestination != null && initialDestination.length() > 0) {
            RemotePath initialPath = new RemotePath(initialDestination);
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            ISystemProfile profile = registry.getSystemProfile(initialPath.getProfileName());
            if (profile != null) {
                try {
                    IHost conn = registry.getHost(profile, initialPath.getConnectionName());
                    IRemoteFileSubSystem subsystem = RemoteFileUtility.getFileSubSystem((IHost)conn);
                    IRemoteFile sel = subsystem.getRemoteFileObject(initialPath.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
                    if (sel != null) {
                        dialog.setPreSelection(sel);
                    }
                }
                catch (Exception exception) {}
            }
        }
        if ((result = dialog.open()) == 0 && (remoteFile = (IRemoteFile)dialog.getOutputObject()) != null) {
            IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
            RemotePath remotePath = new RemotePath(subsystem.getSystemProfileName(), subsystem.getHostAliasName(), remoteFile.getAbsolutePath());
            this.setDestinationValue(remotePath.getFullyQualifiedPath());
            this.update();
        }
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK() && workspace.getRoot().exists(path)) {
            return workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected void createInputGroup(Composite parent) {
        int labelFlags = 272;
        StandardJavaElementContentProvider treeContentProvider = new StandardJavaElementContentProvider(){

            public boolean hasChildren(Object element) {
                return !(element instanceof IPackageFragment) && super.hasChildren(element);
            }
        };
        this.fInputGroup = new RemoteCheckboxTreeAndListGroup(parent, JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), (ITreeContentProvider)treeContentProvider, (ILabelProvider)new JavaElementLabelProvider(labelFlags), (IStructuredContentProvider)new StandardJavaElementContentProvider(), (ILabelProvider)new JavaElementLabelProvider(labelFlags), 0, 480, 150);
        this.fInputGroup.addTreeFilter((ViewerFilter)new EmptyInnerPackageFilter());
        this.fInputGroup.addTreeFilter(new RemoteContainerFilter(RemoteContainerFilter.FILTER_NON_CONTAINERS));
        this.fInputGroup.addTreeFilter((ViewerFilter)new LibraryFilter());
        this.fInputGroup.addListFilter(new RemoteContainerFilter(RemoteContainerFilter.FILTER_CONTAINERS));
        this.fInputGroup.getTree().addListener(4, (Listener)this);
        this.fInputGroup.getTable().addListener(4, (Listener)this);
    }

    protected void createExportTypeGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout optionsLayout = new GridLayout();
        optionsLayout.marginHeight = 0;
        optionsGroup.setLayout((Layout)optionsLayout);
        this.fExportClassFilesCheckbox = new Button(optionsGroup, 16416);
        this.fExportClassFilesCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportClassFiles_text);
        this.fExportClassFilesCheckbox.addListener(13, (Listener)this);
        this.fExportOutputFoldersCheckbox = new Button(optionsGroup, 16416);
        this.fExportOutputFoldersCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportOutputFolders_text);
        this.fExportOutputFoldersCheckbox.addListener(13, (Listener)this);
        this.fExportJavaFilesCheckbox = new Button(optionsGroup, 16416);
        this.fExportJavaFilesCheckbox.setText(JarPackagerMessages.JarPackageWizardPage_exportJavaFiles_text);
        this.fExportJavaFilesCheckbox.addListener(13, (Listener)this);
    }

    protected void updateWidgetEnablements() {
    }

    public boolean isPageComplete() {
        boolean complete = this.validateSourceGroup();
        complete = this.validateDestinationGroup() && complete;
        boolean bl = complete = this.validateOptionsGroup() && complete;
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    public void handleEvent(Event e) {
        if (this.getControl() == null) {
            return;
        }
        this.update();
    }

    protected void update() {
        this.updateModel();
        this.updateWidgetEnablements();
        this.updatePageCompletion();
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    protected boolean validateDestinationGroup() {
        if (this.fDestinationNamesCombo.getText().length() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if (this.getMessage() != null) {
                this.setMessage(null);
            }
            return false;
        }
        return true;
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected boolean validateSourceGroup() {
        if (!(this.fExportClassFilesCheckbox.getSelection() || this.fExportOutputFoldersCheckbox.getSelection() || this.fExportJavaFilesCheckbox.getSelection())) {
            this.setErrorMessage(JarPackagerMessages.JarPackageWizardPage_error_noExportTypeChecked);
            return false;
        }
        if (this.getSelectedResources().size() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            return false;
        }
        if (this.fExportClassFilesCheckbox.getSelection() || this.fExportOutputFoldersCheckbox.getSelection()) {
            return true;
        }
        Iterator iter = this.getSelectedResourcesIterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IClassFile) {
                IClasspathEntry cpEntry;
                IPackageFragmentRoot root = (IPackageFragmentRoot)((IClassFile)element).getAncestor(3);
                if (root == null) continue;
                try {
                    cpEntry = root.getRawClasspathEntry();
                }
                catch (JavaModelException javaModelException) {
                    continue;
                }
                if (cpEntry.getEntryKind() != 1) continue;
                return true;
            }
            return true;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return false;
    }

    protected IPath getResourcePath() {
        return this.getPathFromText(this.fSourceNameField);
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected void giveFocusToDestination() {
        this.fDestinationNamesCombo.setFocus();
    }

    protected void setupBasedOnInitialSelections() {
        for (Object selectedElement : this.fInitialSelection) {
            IJavaElement je;
            if (selectedElement instanceof IResource && !((IResource)selectedElement).isAccessible() || selectedElement instanceof IJavaElement && !((IJavaElement)selectedElement).exists()) continue;
            if (selectedElement instanceof ICompilationUnit || selectedElement instanceof IClassFile || selectedElement instanceof IFile) {
                this.fInputGroup.initialCheckListItem(selectedElement);
                continue;
            }
            if (selectedElement instanceof IFolder && (je = JavaCore.create((IResource)((IResource)selectedElement))) != null && je.exists() && je.getJavaProject().isOnClasspath((IResource)selectedElement)) {
                selectedElement = je;
            }
            this.fInputGroup.initialCheckTreeItem(selectedElement);
        }
        TreeItem[] items = this.fInputGroup.getTree().getItems();
        int i = 0;
        while (i < items.length && !items[i].getChecked()) {
            ++i;
        }
        if (i < items.length) {
            this.fInputGroup.getTree().setSelection(new TreeItem[]{items[i]});
            this.fInputGroup.getTree().showSelection();
            this.fInputGroup.populateListViewer(items[i].getData());
        }
    }

    @Override
    public void finish() {
        this.saveWidgetValues();
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    Object[] getSelectedElementsWithoutContainedChildren() {
        Set closure = this.removeContainedChildren(this.fInputGroup.getWhiteCheckedTreeItems());
        closure.addAll(this.getExportedNonContainers());
        return closure.toArray();
    }

    private Set removeContainedChildren(Set elements) {
        HashSet newList = new HashSet(elements.size());
        Set javaElementResources = this.getCorrespondingContainers(elements);
        Iterator iter = elements.iterator();
        boolean removedOne = false;
        while (iter.hasNext()) {
            IContainer parent;
            Object element = iter.next();
            if (element instanceof IResource) {
                parent = ((IResource)element).getParent();
            } else if (element instanceof IJavaElement) {
                parent = ((IJavaElement)element).getParent();
                if (parent instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)parent;
                    try {
                        if (pkgRoot.getCorrespondingResource() instanceof IProject) {
                            parent = pkgRoot.getJavaProject();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            } else {
                newList.add(element);
                continue;
            }
            if (element instanceof IJavaModel || !(parent instanceof IJavaModel) && (elements.contains(parent) || javaElementResources.contains(parent))) {
                removedOne = true;
                continue;
            }
            newList.add(element);
        }
        if (removedOne) {
            return this.removeContainedChildren(newList);
        }
        return newList;
    }

    private Set getExportedNonContainers() {
        Set whiteCheckedTreeItems = this.fInputGroup.getWhiteCheckedTreeItems();
        HashSet exportedNonContainers = new HashSet(whiteCheckedTreeItems.size());
        Set javaElementResources = this.getCorrespondingContainers(whiteCheckedTreeItems);
        Iterator iter = this.fInputGroup.getAllCheckedListItems();
        while (iter.hasNext()) {
            Object element = iter.next();
            IContainer parent = null;
            if (element instanceof IResource) {
                parent = ((IResource)element).getParent();
            } else if (element instanceof IJavaElement) {
                parent = ((IJavaElement)element).getParent();
            }
            if (whiteCheckedTreeItems.contains(parent) || javaElementResources.contains(parent)) continue;
            exportedNonContainers.add(element);
        }
        return exportedNonContainers;
    }

    private Set getCorrespondingContainers(Set elements) {
        HashSet<IResource> javaElementResources = new HashSet<IResource>(elements.size());
        for (Object element : elements) {
            IResource resource;
            IJavaElement je;
            int type;
            if (!(element instanceof IJavaElement) || (type = (je = (IJavaElement)element).getElementType()) != 2 && type != 4 && type != 3 || type == 4 && ((IPackageFragment)element).isDefaultPackage()) continue;
            try {
                resource = je.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                resource = null;
            }
            if (resource == null) continue;
            javaElementResources.add(resource);
        }
        return javaElementResources;
    }

    private Object[] getSelectedElements() {
        return this.getSelectedResources().toArray();
    }

    private IPath getWorkspaceLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }
}

