/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.IRemoteJarExportRunnable;
import com.ibm.etools.systems.importexport.jar.IRemoteJarExportWizardPage;
import com.ibm.etools.systems.importexport.jar.RemoteJarExportWizardMainPage;
import com.ibm.etools.systems.importexport.jar.RemoteJarExportWizardManifestPage;
import com.ibm.etools.systems.importexport.jar.RemoteJarExportWizardOptionsPage;
import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class RemoteJarExportWizard
extends Wizard
implements IExportWizard {
    private static String DIALOG_SETTINGS_KEY = "RemoteJarExportWizard";
    private IStructuredSelection fSelection;
    private RemoteJarPackageData fJarExport;
    private RemoteJarExportWizardMainPage fJarExportWizardPage;
    private boolean fHasNewDialogSettings;
    private boolean fInitializeFromJarPackage;

    public RemoteJarExportWizard() {
        IDialogSettings workbenchSettings = RSEUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    public void addPages() {
        super.addPages();
        this.fJarExportWizardPage = new RemoteJarExportWizardMainPage(this.fJarExport, this.fSelection);
        this.addPage((IWizardPage)this.fJarExportWizardPage);
        this.addPage((IWizardPage)new RemoteJarExportWizardOptionsPage(this.fJarExport));
        this.addPage((IWizardPage)new RemoteJarExportWizardManifestPage(this.fJarExport));
    }

    public boolean performFinish() {
        this.fJarExport.setElements(this.fJarExportWizardPage.getSelectedElementsWithoutContainedChildren());
        if (!this.executeExportOperation((IRemoteJarExportRunnable)this.fJarExport.createJarExportRunnable(this.getShell()))) {
            return false;
        }
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = RSEUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            IWizardPage page = pages[i];
            if (page instanceof IRemoteJarExportWizardPage) {
                ((IRemoteJarExportWizardPage)page).finish();
            }
            ++i;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = this.getValidSelection();
        this.fJarExport = new RemoteJarPackageData();
        this.setInitializeFromJarPackage(false);
        this.setWindowTitle(JarPackagerMessages.JarPackageWizard_windowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, RemoteJarPackageData jarExport) {
        Assert.isNotNull((Object)workbench);
        Assert.isNotNull((Object)((Object)jarExport));
        this.fJarExport = jarExport;
        this.setInitializeFromJarPackage(true);
        this.fSelection = new StructuredSelection(this.fJarExport.getElements());
        this.setWindowTitle(JarPackagerMessages.JarPackageWizard_windowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    protected boolean executeExportOperation(IRemoteJarExportRunnable op) {
        block4: {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block4;
                ExceptionHandler.handle((InvocationTargetException)ex, (Shell)this.getShell(), (String)JarPackagerMessages.JarPackageWizard_jarExportError_title, (String)JarPackagerMessages.JarPackageWizard_jarExportError_message);
                return false;
            }
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JarPackagerMessages.JarPackageWizard_jarExport_title, null, (IStatus)status);
            return !status.matches(4);
        }
        return true;
    }

    protected IStructuredSelection getValidSelection() {
        ISelection currentSelection = JavaPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            ArrayList selectedElements = new ArrayList(structuredSelection.size());
            for (Object selectedElement : structuredSelection) {
                if (selectedElement instanceof IProject) {
                    this.addProject(selectedElements, (IProject)selectedElement);
                    continue;
                }
                if (selectedElement instanceof IResource) {
                    this.addResource(selectedElements, (IResource)selectedElement);
                    continue;
                }
                if (!(selectedElement instanceof IJavaElement)) continue;
                this.addJavaElement(selectedElements, (IJavaElement)selectedElement);
            }
            return new StructuredSelection(selectedElements);
        }
        return StructuredSelection.EMPTY;
    }

    private void addResource(List selectedElements, IResource resource) {
        IJavaElement je = JavaCore.create((IResource)resource);
        if (je != null && je.exists() && je.getElementType() == 5) {
            selectedElements.add(je);
        } else {
            selectedElements.add(resource);
        }
    }

    private void addProject(List selectedElements, IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                selectedElements.add(JavaCore.create((IProject)project));
            }
        }
        catch (CoreException coreException) {}
    }

    private void addJavaElement(List selectedElements, IJavaElement je) {
        if (je.getElementType() == 5) {
            selectedElements.add(je);
        } else if (je.getElementType() == 6) {
            selectedElements.add(je);
        } else if (je.getElementType() == 2) {
            selectedElements.add(je);
        } else if (je.getElementType() == 4) {
            if (!JavaModelUtil.getPackageFragmentRoot((IJavaElement)je).isArchive()) {
                selectedElements.add(je);
            }
        } else if (je.getElementType() == 3) {
            if (!((IPackageFragmentRoot)je).isArchive()) {
                selectedElements.add(je);
            }
        } else {
            IOpenable openable = je.getOpenable();
            if (openable instanceof ICompilationUnit) {
                IJavaElement jel = ((ICompilationUnit)openable).getPrimaryElement();
                selectedElements.add(jel);
            } else if (openable instanceof IClassFile && !JavaModelUtil.getPackageFragmentRoot((IJavaElement)je).isArchive()) {
                selectedElements.add(openable);
            }
        }
    }

    boolean isInitializingFromJarPackage() {
        return this.fInitializeFromJarPackage;
    }

    void setInitializeFromJarPackage(boolean state) {
        this.fInitializeFromJarPackage = state;
    }
}

