/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.remoteJava.RemoteJavaResources;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.internal.ui.view.SystemResourceSelectionForm;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ValidatorArchiveName;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemResourceSelectionInputProvider;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteJarDestinationForm
extends SystemResourceSelectionForm {
    protected Text _fileNameText;
    protected Combo _fileTypeCombo;
    protected Label nameAndTypeLabel;
    protected String _fileName;
    protected String _fileType;
    protected String initialFileName;
    protected ValidatorFileName validator = new ValidatorFileName();
    protected ValidatorArchiveName arcvalidator = new ValidatorArchiveName();
    protected boolean _prePop = true;

    public RemoteJarDestinationForm(Shell shell, Composite parent, Object caller, ISystemResourceSelectionInputProvider provider, String verbiage, ISystemMessageLine msgLine) {
        super(shell, parent, caller, provider, verbiage, false, msgLine);
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)1);
        this.nameAndTypeLabel = SystemWidgetHelpers.createLabel((Composite)composite, (String)RemoteJavaResources.RESID_RMTJAREXP_FILEDIALOG_PROMPT_LABEL);
        Composite subcomp1 = SystemWidgetHelpers.createComposite((Composite)composite, (int)2);
        this._fileNameText = SystemWidgetHelpers.createLabeledTextField((Composite)subcomp1, null, (String)RemoteJavaResources.RESID_COMBINE_NAME_LABEL, (String)RemoteJavaResources.RESID_COMBINE_NAME_TOOLTIP);
        this._fileTypeCombo = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)subcomp1, null, (String)RemoteJavaResources.RESID_COMBINE_TYPE_LABEL, (String)RemoteJavaResources.RESID_COMBINE_TYPE_TOOLTIP);
        String[] allowedExtensions = this.getAllowedArchiveExtensions();
        if (allowedExtensions != null && allowedExtensions.length != 0) {
            this._fileTypeCombo.setItems(allowedExtensions);
            this._fileTypeCombo.select(0);
            this._fileType = this._fileTypeCombo.getText();
        }
        this._fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemMessage isValidMsg;
                RemoteJarDestinationForm.this._fileName = RemoteJarDestinationForm.this._fileNameText.getText();
                RemoteJarDestinationForm.this.setPageComplete();
                if (RemoteJarDestinationForm.this._fileName.indexOf(".") != -1 && (isValidMsg = RemoteJarDestinationForm.this.arcvalidator.validate(RemoteJarDestinationForm.this._fileName)) == null) {
                    int i = RemoteJarDestinationForm.this._fileName.lastIndexOf(".");
                    RemoteJarDestinationForm.this._fileType = RemoteJarDestinationForm.this._fileName.substring(i + 1);
                    RemoteJarDestinationForm.this._fileTypeCombo.setText(RemoteJarDestinationForm.this._fileType);
                }
            }
        });
        this._fileTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteJarDestinationForm.this._fileType = RemoteJarDestinationForm.this._fileTypeCombo.getText();
                RemoteJarDestinationForm.this.setPageComplete();
            }
        });
        if (this._fileName != null) {
            this._fileNameText.setText(this._fileName);
        }
    }

    protected String[] getAllowedArchiveExtensions() {
        return new String[]{"jar"};
    }

    public boolean verify() {
        boolean ok = super.verify();
        if (ok) {
            IRemoteFile file = null;
            Object selected = this.getSelectedObject();
            if (selected instanceof IRemoteFile) {
                file = (IRemoteFile)selected;
            } else if (selected instanceof ISystemFilterReference) {
                ISystemFilterReference ref = (ISystemFilterReference)selected;
                file = (IRemoteFile)ref.getSubSystem().getTargetForFilter(ref);
            }
            try {
                file.getParentRemoteFileSubSystem().getRemoteFileObject(file, this.getFileName(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
        }
        return ok;
    }

    public boolean isPageComplete() {
        String nameToCheck = null;
        nameToCheck = this._fileName == null ? "" : this._fileName;
        SystemMessage errMsg = null;
        if (this.validator != null) {
            errMsg = this.validator.validate(nameToCheck);
        }
        if (errMsg != null) {
            this.setErrorMessage(errMsg);
            return false;
        }
        this.clearErrorMessage();
        return this._fileTypeCombo != null && this._fileTypeCombo.getText().length() > 0 && this._fileNameText != null && this._fileNameText.getText().length() > 0 && super.isPageComplete();
    }

    public String getFileName() {
        if (this._fileName.endsWith("." + this._fileType)) {
            return this._fileName;
        }
        return String.valueOf(this._fileName) + "." + this._fileType;
    }

    protected ISystemViewElementAdapter getAdapter(Object o) {
        return SystemAdapterHelpers.getViewAdapter((Object)o);
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)o);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        super.selectionChanged(e);
        this.clearErrorMessage();
        Object selectedObject = this.getFirstSelection(e.getSelection());
        if (selectedObject != null && selectedObject instanceof IRemoteFile) {
            IRemoteFile parentFile;
            IRemoteFile remoteFile = (IRemoteFile)selectedObject;
            ISystemRemoteElementAdapter remoteAdapter = this.getRemoteAdapter(selectedObject);
            if (remoteAdapter != null && (remoteAdapter = this.getRemoteAdapter(parentFile = remoteFile)) != null) {
                String fullPath = remoteAdapter.getAbsoluteName((Object)parentFile);
                this.setPathText(fullPath);
                this.outputObjects = new Object[]{parentFile};
                this.setPageComplete();
            }
        }
    }

    public boolean setPreSelection(Object pselection) {
        boolean result = false;
        if (pselection instanceof IRemoteFile) {
            IRemoteFile parentFile;
            IRemoteFile selection = (IRemoteFile)pselection;
            if (selection.isDirectory()) {
                result = super.setPreSelection((Object)selection);
            } else if (selection.isFile() && (parentFile = selection.getParentRemoteFile()).isDirectory()) {
                result = super.setPreSelection((Object)parentFile);
            }
            if (this._prePop) {
                String file = selection.getName();
                int i = file.lastIndexOf(".");
                if (i == -1) {
                    this._fileName = file;
                    this._fileType = "";
                } else {
                    this._fileName = file.substring(0, i);
                    this._fileType = selection.getExtension();
                }
                if (this._fileNameText != null) {
                    this._fileNameText.setText(this._fileName);
                    this._fileTypeCombo.setText(this._fileType);
                }
            } else {
                this._fileName = "";
            }
        }
        return result;
    }

    public void setPrePopSelection(boolean prePopSelection) {
        this._prePop = prePopSelection;
    }
}

