/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.IRemoteJarDescriptionReader;
import com.ibm.etools.systems.importexport.jar.RemoteJarExportActionDelegate;
import com.ibm.etools.systems.importexport.jar.RemoteJarExportWizard;
import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

public class OpenRemoteJarExportWizardActionDelegate
extends RemoteJarExportActionDelegate {
    private IRemoteJarDescriptionReader fReader;

    public void run(IAction action) {
        Shell parent = this.getShell();
        RemoteJarPackageData jarPackage = null;
        String errorDetail = null;
        try {
            jarPackage = this.readRemoteJarExportData(this.getDescriptionFile(this.getSelection()));
        }
        catch (IOException ex) {
            errorDetail = ex.getLocalizedMessage();
            MessageDialog.openError((Shell)parent, (String)JarPackagerMessages.OpenJarPackageWizardDelegate_error_openJarPackager_title, (String)(String.valueOf(JarPackagerMessages.OpenJarPackageWizardDelegate_error_openJarPackager_message) + errorDetail));
            return;
        }
        catch (CoreException ex) {
            errorDetail = ex.getLocalizedMessage();
            MessageDialog.openError((Shell)parent, (String)JarPackagerMessages.OpenJarPackageWizardDelegate_error_openJarPackager_title, (String)(String.valueOf(JarPackagerMessages.OpenJarPackageWizardDelegate_error_openJarPackager_message) + errorDetail));
            return;
        }
        catch (SAXException ex) {
            errorDetail = ex.getLocalizedMessage();
            MessageDialog.openError((Shell)parent, (String)JarPackagerMessages.OpenJarPackageWizardDelegate_error_openJarPackager_title, (String)(String.valueOf(JarPackagerMessages.OpenJarPackageWizardDelegate_error_openJarPackager_message) + errorDetail));
            return;
        }
        if (this.fReader != null && !this.fReader.getStatus().isOK()) {
            ErrorDialog.openError((Shell)parent, (String)JarPackagerMessages.OpenJarPackageWizardDelegate_jarDescriptionReaderWarnings_title, null, (IStatus)this.fReader.getStatus());
        }
        RemoteJarExportWizard wizard = new RemoteJarExportWizard();
        wizard.init(this.getWorkbench(), jarPackage);
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private RemoteJarPackageData readRemoteJarExportData(IFile description) throws CoreException, IOException, SAXException {
        Assert.isLegal((boolean)description.isAccessible());
        Assert.isNotNull((Object)description.getFileExtension());
        Assert.isLegal((boolean)description.getFileExtension().equals("rmtjardesc"));
        RemoteJarPackageData jarPackage = new RemoteJarPackageData();
        try {
            this.fReader = jarPackage.createJarDescriptionReader(description.getContents());
            this.fReader.read(jarPackage);
        }
        finally {
            if (this.fReader != null) {
                this.fReader.close();
            }
        }
        return jarPackage;
    }
}

