/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.systems.importexport.jar;

import com.ibm.etools.systems.importexport.jar.IRemoteJarDescriptionReader;
import com.ibm.etools.systems.importexport.jar.IRemoteJarExportRunnable;
import com.ibm.etools.systems.importexport.jar.RemoteJarExportActionDelegate;
import com.ibm.etools.systems.importexport.jar.RemoteJarPackageData;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateRemoteJarActionDelegate
extends RemoteJarExportActionDelegate {
    public void run(IAction action) {
        MultiStatus mergedStatus;
        IFile[] descriptions = this.getDescriptionFiles(this.getSelection());
        int length = descriptions.length;
        if (length < 1) {
            return;
        }
        String message = length > 1 ? JarPackagerMessages.JarFileExportOperation_creationOfSomeJARsFailed : JarPackagerMessages.JarFileExportOperation_jarCreationFailed;
        MultiStatus readStatus = new MultiStatus(JavaPlugin.getPluginId(), 0, message, null);
        RemoteJarPackageData[] jarPackages = this.readJarPackages(descriptions, readStatus);
        if (jarPackages.length > 0) {
            IStatus status = this.export(jarPackages);
            if (status == null) {
                return;
            }
            message = readStatus.getSeverity() == 4 ? readStatus.getMessage() : status.getMessage();
            mergedStatus = new MultiStatus(JavaPlugin.getPluginId(), status.getCode(), readStatus.getChildren(), message, null);
            mergedStatus.merge(status);
        } else {
            mergedStatus = readStatus;
        }
        if (!mergedStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JarPackagerMessages.CreateJarActionDelegate_jarExport_title, (String)"", (IStatus)mergedStatus);
        }
    }

    private RemoteJarPackageData[] readJarPackages(IFile[] descriptions, MultiStatus readStatus) {
        ArrayList<RemoteJarPackageData> jarPackagesList = new ArrayList<RemoteJarPackageData>(descriptions.length);
        int i = 0;
        while (i < descriptions.length) {
            RemoteJarPackageData jarPackage = this.readJarPackage(descriptions[i], readStatus);
            if (jarPackage != null) {
                jarPackagesList.add(jarPackage);
            }
            ++i;
        }
        return jarPackagesList.toArray(new RemoteJarPackageData[jarPackagesList.size()]);
    }

    private IStatus export(RemoteJarPackageData[] jarPackages) {
        Shell shell = this.getShell();
        IRemoteJarExportRunnable op = (IRemoteJarExportRunnable)jarPackages[0].createJarExportRunnable(jarPackages, shell);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() != null) {
                ExceptionHandler.handle((InvocationTargetException)ex, (Shell)shell, (String)JarPackagerMessages.CreateJarActionDelegate_jarExportError_title, (String)JarPackagerMessages.CreateJarActionDelegate_jarExportError_message);
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return op.getStatus();
    }

    protected RemoteJarPackageData readJarPackage(IFile description, MultiStatus readStatus) {
        Assert.isLegal((boolean)description.isAccessible());
        Assert.isNotNull((Object)description.getFileExtension());
        Assert.isLegal((boolean)description.getFileExtension().equals("rmtjardesc"));
        RemoteJarPackageData jarPackage = new RemoteJarPackageData();
        IRemoteJarDescriptionReader reader = null;
        try {
            try {
                reader = jarPackage.createJarDescriptionReader(description.getContents());
                reader.read(jarPackage);
                jarPackage.setSaveManifest(false);
                jarPackage.setSaveDescription(false);
            }
            catch (CoreException ex) {
                String message = MessageFormat.format(JarPackagerMessages.JarFileExportOperation_errorReadingFile, description.getFullPath(), ex.getStatus().getMessage());
                this.addToStatus(readStatus, jarPackage, message, ex);
                if (reader != null) {
                    readStatus.addAll(reader.getStatus());
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (CoreException ex2) {
                    String message2 = MessageFormat.format(JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, description.getFullPath());
                    this.addToStatus(readStatus, jarPackage, message2, ex2);
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (reader != null) {
                readStatus.addAll(reader.getStatus());
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (CoreException ex) {
                String message = MessageFormat.format(JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, description.getFullPath());
                this.addToStatus(readStatus, jarPackage, message, ex);
            }
            throw throwable;
        }
        if (reader != null) {
            readStatus.addAll(reader.getStatus());
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (CoreException ex) {
            String message = MessageFormat.format(JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, description.getFullPath());
            this.addToStatus(readStatus, jarPackage, message, ex);
        }
        return jarPackage;
    }

    protected void addToStatus(MultiStatus multiStatus, RemoteJarPackageData jarPackage, String defaultMessage, CoreException ex) {
        IStatus status = ex.getStatus();
        String message = ex.getLocalizedMessage();
        if (message == null || message.length() < 1) {
            status = new Status(status.getSeverity(), status.getPlugin(), status.getCode(), defaultMessage, (Throwable)ex);
        }
        multiStatus.add(status);
    }
}

