/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.xml.schema.ui.wizard.register;

import com.ibm.datatools.common.util.DB2Version;
import com.ibm.datatools.xml.core.ui.util.Xdr2DB2XsrObject;
import com.ibm.datatools.xml.schema.ui.nls.XMLSchemaUIMessages;
import com.ibm.datatools.xml.schema.ui.providers.XMLSchemaDocContentProvider;
import com.ibm.datatools.xml.schema.ui.providers.XMLSchemaDocItemProvider;
import com.ibm.datatools.xml.schema.ui.providers.XMLSchemaDocLabelProvider;
import com.ibm.datatools.xml.schema.ui.wizard.register.RegisterXMLSchemaWizard;
import com.ibm.db.models.db2.DB2XMLSchema;
import com.ibm.db.models.db2.DB2XMLSchemaDocument;
import com.ibm.db2.common.xmlutils.xdr.XdrObject;
import com.ibm.db2.common.xmlutils.xdr.XdrType;
import com.ibm.db2.common.xmlutils.xdr.XdrXMLParserImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

class XMLSchemaDocumentsPage
extends WizardPage
implements SelectionListener,
ModifyListener {
    protected Text txtTargetNamespace;
    protected Text txtSchemaLocation;
    protected Text txtTerminator;
    protected Button btnDecomp;
    protected Button btnPropertyAdd;
    protected Button btnPropertyRemove;
    protected Button btnSetPrimary;
    protected Button btnDependenciesAdd;
    protected Button btnDependenciesRemove;
    protected Button btnDependenciesResolve;
    protected Button btnGenScript;
    protected Table userDefinedPropertiesTable;
    protected TableViewer userDefinedPropertiesTableViewer;
    protected TreeViewer treeViewer;
    protected TreeItem xsdDoc;
    protected ArrayList firstLevelDocuments;
    protected Hashtable dependentDocuments;
    protected DB2XMLSchemaDocument primaryDocument;
    protected ArrayList invalidDocuments;
    protected DB2XMLSchema xmlSchema;
    protected ArrayList firstLevelAndDependentDoc;
    protected boolean projectExplorer;
    protected boolean isGenerate;
    protected boolean isZOS;
    public final String DEFAULT_STMT_TERM = ";";
    protected boolean firstPageEntryOccurred = false;
    private DB2Version db2version = null;

    public XMLSchemaDocumentsPage(String name, boolean projectExplorer, boolean isZOS) {
        this(name, projectExplorer, false, isZOS);
    }

    public void setDB2Version(DB2Version db2version) {
        this.db2version = db2version;
    }

    public XMLSchemaDocumentsPage(String name, boolean projectExplorer, boolean isGenerate, boolean isZOS) {
        super(name);
        this.setTitle(XMLSchemaUIMessages.REGISTER_WIZARD_XML_SCHEMA_DOCUMENT_PAGE_TITLE);
        this.setDescription(XMLSchemaUIMessages.REGISTER_WIZARD_XML_SCHEMA_DOCUMENT_PAGE_DESC);
        this.firstLevelDocuments = new ArrayList();
        this.dependentDocuments = new Hashtable();
        this.firstLevelAndDependentDoc = new ArrayList();
        this.invalidDocuments = new ArrayList();
        this.projectExplorer = projectExplorer;
        this.isGenerate = isGenerate;
        this.isZOS = isZOS;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.verticalSpacing = 10;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1808));
        if (!this.isGenerate) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "com.ibm.datatools.xml.schema.infopop.schema_docs");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "com.ibm.datatools.xml.schema.infopop.schema_docs_gen_only");
        }
        this.createTargetNameSpaceControl(comp);
        this.createSchemaLocationControl(comp);
        this.createXMLSchemaDocDependencies(comp);
        this.createDecompositionControl(comp);
        if (!this.isGenerate) {
            this.createGenerateScriptControl(comp);
        }
        this.createStmtTerminatorControl(comp);
        this.setControl((Control)comp);
    }

    private void createTargetNameSpaceControl(Composite comp) {
        Label lblName = new Label(comp, 0);
        lblName.setText(XMLSchemaUIMessages.REGISTER_WIZARD_TARGET_NAMESPACE);
        GridData gdLblName = new GridData();
        gdLblName.horizontalSpan = 1;
        lblName.setLayoutData((Object)gdLblName);
        this.txtTargetNamespace = new Text(comp, 2052);
        this.txtTargetNamespace.setEnabled(false);
        GridData gdTxtTargetNamespace = new GridData(768);
        this.txtTargetNamespace.setLayoutData((Object)gdTxtTargetNamespace);
    }

    private void createSchemaLocationControl(Composite comp) {
        Label lblName = new Label(comp, 0);
        lblName.setText(XMLSchemaUIMessages.REGISTER_WIZARD_SCHEMA_LOCATION);
        GridData gdLblName = new GridData();
        gdLblName.horizontalSpan = 1;
        lblName.setLayoutData((Object)gdLblName);
        this.txtSchemaLocation = new Text(comp, 2052);
        this.txtSchemaLocation.addModifyListener((ModifyListener)this);
        GridData gdTxtSchemaLocation = new GridData(768);
        this.txtSchemaLocation.setLayoutData((Object)gdTxtSchemaLocation);
    }

    private void createXMLSchemaDocDependencies(Composite comp) {
        Group grpListDependencies = new Group(comp, 16);
        grpListDependencies.setText(XMLSchemaUIMessages.REGISTER_WIZARD_LIST_DEPENDENCIES);
        GridData gdListDependencies = new GridData();
        gdListDependencies.horizontalSpan = 2;
        gdListDependencies.horizontalAlignment = 4;
        gdListDependencies.verticalAlignment = 4;
        gdListDependencies.grabExcessHorizontalSpace = true;
        gdListDependencies.grabExcessVerticalSpace = true;
        grpListDependencies.setLayoutData((Object)gdListDependencies);
        GridLayout glListDependencies = new GridLayout();
        glListDependencies.numColumns = 2;
        grpListDependencies.setLayout((Layout)glListDependencies);
        this.treeViewer = new TreeViewer((Composite)grpListDependencies, 2576);
        GridData gdTreeViewer = new GridData(1808);
        gdTreeViewer.minimumWidth = 160;
        gdTreeViewer.minimumHeight = 90;
        this.treeViewer.getTree().setLayoutData((Object)gdTreeViewer);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)this);
        GridLayout glCButtons = new GridLayout();
        glCButtons.marginHeight = 0;
        glCButtons.marginWidth = 0;
        GridData gdCButtons = new GridData();
        gdCButtons.verticalSpan = 3;
        gdCButtons.verticalAlignment = 1;
        Composite cmpButtons = new Composite((Composite)grpListDependencies, 11);
        cmpButtons.setLayout((Layout)glCButtons);
        cmpButtons.setLayoutData((Object)gdCButtons);
        GridData gdBtnAdd = new GridData();
        gdBtnAdd.horizontalAlignment = 4;
        this.btnDependenciesAdd = new Button(cmpButtons, 8);
        this.btnDependenciesAdd.setText(XMLSchemaUIMessages.REGISTER_WIZARD_DEPENDENCIES_ADD);
        this.btnDependenciesAdd.setLayoutData((Object)gdBtnAdd);
        this.btnDependenciesAdd.addSelectionListener((SelectionListener)this);
        GridData gdBtnRemove = new GridData();
        gdBtnRemove.horizontalAlignment = 4;
        this.btnDependenciesRemove = new Button(cmpButtons, 8);
        this.btnDependenciesRemove.setText(XMLSchemaUIMessages.REGISTER_WIZARD_DEPENDENCIES_REMOVE);
        this.btnDependenciesRemove.setLayoutData((Object)gdBtnRemove);
        this.btnDependenciesRemove.setEnabled(false);
        this.btnDependenciesRemove.addSelectionListener((SelectionListener)this);
        GridData gdBtnPrimary = new GridData();
        gdBtnPrimary.horizontalAlignment = 4;
        this.btnSetPrimary = new Button(cmpButtons, 8);
        this.btnSetPrimary.setText(XMLSchemaUIMessages.REGISTER_WIZARD_DEPENDENCIES_SET_PRIMARY);
        this.btnSetPrimary.setLayoutData((Object)gdBtnPrimary);
        this.btnSetPrimary.setEnabled(false);
        this.btnSetPrimary.addSelectionListener((SelectionListener)this);
        GridData gdBtnResolveDep = new GridData();
        gdBtnResolveDep.horizontalAlignment = 4;
        this.btnDependenciesResolve = new Button(cmpButtons, 8);
        this.btnDependenciesResolve.setText(XMLSchemaUIMessages.REGISTER_WIZARD_DEPENDENCIES_RESOLVE);
        this.btnDependenciesResolve.setLayoutData((Object)gdBtnResolveDep);
        this.btnDependenciesResolve.setEnabled(false);
        this.btnDependenciesResolve.addSelectionListener((SelectionListener)this);
    }

    private void createDecompositionControl(Composite comp) {
        GridData gdEnableDebug = new GridData(32);
        gdEnableDebug.horizontalSpan = 2;
        this.btnDecomp = new Button(comp, 32);
        this.btnDecomp.setText(XMLSchemaUIMessages.REGISTER_WIZARD_DECOMPOSITION);
        this.btnDecomp.setLayoutData((Object)gdEnableDebug);
        this.btnDecomp.addSelectionListener((SelectionListener)this);
        if (this.isZOS && this.db2version.isAtLeast(9)) {
            this.btnDecomp.setVisible(false);
        }
    }

    private void createGenerateScriptControl(Composite comp) {
        GridData gdGenScript = new GridData(32);
        gdGenScript.horizontalSpan = 2;
        this.btnGenScript = new Button(comp, 32);
        this.btnGenScript.setText(XMLSchemaUIMessages.REGISTER_WIZARD_GENERATE_SCRIPT);
        this.btnGenScript.setLayoutData((Object)gdGenScript);
        this.btnGenScript.addSelectionListener((SelectionListener)this);
    }

    private void createStmtTerminatorControl(Composite comp) {
        Label lblName = new Label(comp, 0);
        lblName.setText(XMLSchemaUIMessages.REGISTER_WIZARD_STATEMENT_TERMINATOR);
        GridData gdLblName = new GridData(128);
        gdLblName.horizontalSpan = 1;
        lblName.setLayoutData((Object)gdLblName);
        this.txtTerminator = new Text(comp, 2052);
        this.txtTerminator.setText(";");
        this.txtTerminator.setTextLimit(1);
        GridData gdTxtTerminator = new GridData(32);
        gdTxtTerminator.widthHint = new GC((Drawable)this.txtTerminator).getFontMetrics().getAverageCharWidth() * 2;
        this.txtTerminator.setLayoutData((Object)gdTxtTerminator);
        if (!this.isGenerate) {
            this.txtTerminator.setEnabled(false);
        }
    }

    public void setVisible(boolean visible) {
        if (visible && this.projectExplorer) {
            Collection selectedItems = ((RegisterXMLSchemaWizard)this.getWizard()).getSelectedItems();
            int sItemsSize = selectedItems.size();
            if (selectedItems != null && sItemsSize > 0) {
                Iterator iterator = selectedItems.iterator();
                ArrayList<DB2XMLSchemaDocument> arrayList = new ArrayList<DB2XMLSchemaDocument>(sItemsSize);
                while (iterator.hasNext()) {
                    DB2XMLSchemaDocument doc = (DB2XMLSchemaDocument)iterator.next();
                    if (this.getFirstLevelEquivalent(doc) != null || this.getDependentEquivalent(doc) != null) continue;
                    if (doc == ((RegisterXMLSchemaWizard)this.getWizard()).getPrimarySelectedDocument()) {
                        arrayList.add(0, doc);
                        continue;
                    }
                    arrayList.add(doc);
                }
                Iterator it = arrayList.iterator();
                while (it.hasNext()) {
                    this.addXMLSchemaDocToTree(((DB2XMLSchemaDocument)it.next()).getFileName(), true);
                }
            }
        }
        this.setPageComplete(this.validatePage());
        this.firstPageEntryOccurred = true;
        super.setVisible(visible);
    }

    protected void changePrimary(DB2XMLSchemaDocument pdoc) {
        for (DB2XMLSchemaDocument doc : this.firstLevelDocuments) {
            if (!doc.getName().equalsIgnoreCase(pdoc.getName()) || (doc.getTargetNamespace() == null || pdoc.getTargetNamespace() == null || !doc.getTargetNamespace().equalsIgnoreCase(pdoc.getTargetNamespace())) && (doc.getTargetNamespace() != null || pdoc.getTargetNamespace() != null)) continue;
            this.primaryDocument = doc;
            this.updateProvider();
            break;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.treeViewer.getTree())) {
            int selectedElementsSize = ((IStructuredSelection)this.treeViewer.getSelection()).size();
            if (selectedElementsSize == 1) {
                this.btnDependenciesRemove.setEnabled(true);
                this.btnSetPrimary.setEnabled(true);
                DB2XMLSchemaDocument schemaDoc = (DB2XMLSchemaDocument)((IStructuredSelection)this.treeViewer.getSelection()).iterator().next();
                if (this.isInvalidDocument(schemaDoc)) {
                    this.btnDependenciesResolve.setEnabled(true);
                } else {
                    this.btnDependenciesResolve.setEnabled(false);
                }
                String schemaLocation = schemaDoc.getSchemaLocation();
                if (schemaLocation != null) {
                    this.txtSchemaLocation.setText(schemaLocation);
                } else {
                    this.txtSchemaLocation.setText("");
                }
            } else if (selectedElementsSize == 0) {
                this.btnDependenciesRemove.setEnabled(false);
                this.btnSetPrimary.setEnabled(false);
                this.btnDependenciesResolve.setEnabled(false);
            } else if (selectedElementsSize > 1) {
                this.btnDependenciesRemove.setEnabled(true);
                this.btnSetPrimary.setEnabled(false);
                this.btnDependenciesResolve.setEnabled(false);
            }
            for (Object selectedObject : (IStructuredSelection)this.treeViewer.getSelection()) {
                if (!(selectedObject instanceof DB2XMLSchemaDocument)) continue;
                DB2XMLSchemaDocument xmlSchemaDocument = (DB2XMLSchemaDocument)selectedObject;
                if (this.getFirstLevelEquivalent(xmlSchemaDocument) != null && this.isDependentDocument(xmlSchemaDocument)) {
                    this.btnDependenciesRemove.setEnabled(true);
                    this.btnSetPrimary.setEnabled(false);
                } else if (!this.firstLevelDocuments.contains(xmlSchemaDocument)) {
                    this.btnSetPrimary.setEnabled(false);
                    this.btnDependenciesRemove.setEnabled(false);
                } else {
                    if (xmlSchemaDocument != this.primaryDocument) continue;
                    this.btnSetPrimary.setEnabled(false);
                }
                break;
            }
        } else if (source.equals(this.btnDependenciesAdd)) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
            fileDialog.setText(XMLSchemaUIMessages.REGISTER_FILES_CHOOSER_TITLEJAR);
            String[] extension = new String[]{"*.xsd"};
            fileDialog.setFilterExtensions(extension);
            String fname = fileDialog.open();
            if (fname != null) {
                this.addXMLSchemaDocToTree(fname, false);
            }
            if (this.isZOS && this.firstLevelDocuments.size() > 0) {
                this.btnDependenciesAdd.setEnabled(false);
            }
        } else if (source.equals(this.btnDependenciesRemove)) {
            for (Object object : (IStructuredSelection)this.treeViewer.getSelection()) {
                if (!(object instanceof DB2XMLSchemaDocument)) continue;
                if (((RegisterXMLSchemaWizard)this.getWizard()).getSelectionPage() != null) {
                    this.removeXMLSchemaDocFromTree((DB2XMLSchemaDocument)object, true);
                } else {
                    this.removeXMLSchemaDocFromTree((DB2XMLSchemaDocument)object, false);
                }
                this.txtSchemaLocation.setText("");
            }
            if (this.isZOS && this.firstLevelDocuments.size() == 0) {
                this.btnDependenciesAdd.setEnabled(true);
            }
        } else if (source.equals(this.btnSetPrimary)) {
            Object object;
            Iterator selectedItem = ((IStructuredSelection)this.treeViewer.getSelection()).iterator();
            if (selectedItem.hasNext() && (object = selectedItem.next()) instanceof DB2XMLSchemaDocument) {
                this.primaryDocument = (DB2XMLSchemaDocument)object;
                if (this.primaryDocument.getTargetNamespace() != null) {
                    this.txtTargetNamespace.setText(this.primaryDocument.getTargetNamespace());
                } else {
                    this.txtTargetNamespace.setText("");
                }
                if (((RegisterXMLSchemaWizard)this.getWizard()).getSelectionPage() != null) {
                    ((RegisterXMLSchemaWizard)this.getWizard()).getSelectionPage().changePrimary(this.primaryDocument);
                }
                this.updateProvider();
                this.btnSetPrimary.setEnabled(false);
            }
        } else if (source.equals(this.btnDependenciesResolve)) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
            fileDialog.setText(XMLSchemaUIMessages.REGISTER_FILES_CHOOSER_TITLEJAR);
            String[] extension = new String[]{"*.xsd"};
            fileDialog.setFilterExtensions(extension);
            String fname = fileDialog.open();
            if (fname != null) {
                File aFile = new File(fname);
                String filename = aFile.getName();
                DB2XMLSchemaDocument doc = (DB2XMLSchemaDocument)((IStructuredSelection)this.treeViewer.getSelection()).iterator().next();
                if (doc.getName().equalsIgnoreCase(filename.substring(0, filename.lastIndexOf(".")))) {
                    try {
                        XdrXMLParserImpl xdrParser = new XdrXMLParserImpl(aFile.toURL(), XdrType.WXS);
                        XdrObject xdrObject = xdrParser.getXdrObject();
                        doc.setTargetNamespace(xdrObject.getTargetNamespace());
                        int lastIndexOfSlash = fname.lastIndexOf(File.separator);
                        this.txtSchemaLocation.setText(fname.substring(lastIndexOfSlash + 1));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    DB2XMLSchemaDocument fldDoc = this.getFirstLevelEquivalent(doc);
                    if (fldDoc != null) {
                        DB2XMLSchemaDocument flDoc = this.getFirstLevelEquivalent(doc);
                        this.removeXMLSchemaDocFromTree(fldDoc, true);
                        DB2XMLSchemaDocument fDoc = this.getFirstLevelDocument(doc);
                        ArrayList depDocs = (ArrayList)this.dependentDocuments.get(fDoc);
                        depDocs.remove(doc);
                        depDocs.add(flDoc);
                    } else {
                        doc.setFileName(aFile.getAbsolutePath());
                    }
                    this.invalidDocuments.remove(doc);
                    this.updateProvider();
                    this.btnDependenciesResolve.setEnabled(false);
                }
            }
        } else if (source.equals(this.btnGenScript)) {
            if (this.btnGenScript.getSelection()) {
                this.txtTerminator.setEnabled(true);
            } else {
                this.txtTerminator.setEnabled(false);
            }
        }
        this.setPageComplete(this.validatePage());
    }

    private void addXMLSchemaDocToTree(String fname, boolean fromSelectionList) {
        try {
            File aFile = new File(fname);
            Xdr2DB2XsrObject xdr2Db2Xsrobject = new Xdr2DB2XsrObject(aFile.toURL(), XdrType.WXS);
            DB2XMLSchema db2XmlSchema = xdr2Db2Xsrobject.getDB2XMLSchema();
            if (this.xmlSchema == null) {
                this.xmlSchema = db2XmlSchema;
            }
            EList schemaDocList = db2XmlSchema.getXmlSchemaDocs();
            DB2XMLSchemaDocument firstLevelDocument = (DB2XMLSchemaDocument)schemaDocList.get(0);
            boolean found = false;
            DB2XMLSchemaDocument firstLevelDoc = this.getFirstLevelEquivalent(firstLevelDocument);
            if (firstLevelDoc != null) {
                found = true;
            } else {
                DB2XMLSchemaDocument dependentDoc = this.getDependentEquivalent(firstLevelDocument);
                if (dependentDoc != null) {
                    found = true;
                } else {
                    DB2XMLSchemaDocument iDoc = this.getInvalidEquivalent(firstLevelDocument);
                    if (iDoc != null) {
                        ((ArrayList)this.dependentDocuments.get(this.getFirstLevelDocument(iDoc))).add(firstLevelDocument);
                        this.removeXMLSchemaDocFromTree(iDoc);
                        found = true;
                        if (this.invalidDocuments.size() > 0) {
                            this.setPageComplete(false);
                        }
                    }
                }
            }
            if (!found) {
                this.firstLevelDocuments.add(firstLevelDocument);
                if (this.primaryDocument == null) {
                    this.primaryDocument = firstLevelDocument;
                    if (this.primaryDocument.getTargetNamespace() != null) {
                        this.txtTargetNamespace.setText(this.primaryDocument.getTargetNamespace());
                    }
                }
                ArrayList<Object> dependentDocs = new ArrayList<Object>(db2XmlSchema.getXmlSchemaDocs().size() - 1);
                int i = 1;
                while (i < db2XmlSchema.getXmlSchemaDocs().size()) {
                    DB2XMLSchemaDocument fldDoc = this.getFirstLevelEquivalent((DB2XMLSchemaDocument)schemaDocList.get(i));
                    if (fldDoc != null && fromSelectionList) {
                        fldDoc.setSchemaLocation(fldDoc.getSchemaLocation().substring(fldDoc.getSchemaLocation().lastIndexOf("/") + 1, fldDoc.getSchemaLocation().length()));
                        DB2XMLSchemaDocument first = this.getFirstLevelEquivalent((DB2XMLSchemaDocument)schemaDocList.get(i));
                        dependentDocs.add(first);
                        if (first == this.primaryDocument) {
                            this.primaryDocument = firstLevelDocument;
                        }
                        this.removeXMLSchemaDocFromTree(fldDoc, false);
                    } else {
                        if (fldDoc != null) {
                            this.firstLevelAndDependentDoc.add(fldDoc);
                        }
                        dependentDocs.add(schemaDocList.get(i));
                    }
                    ++i;
                }
                ArrayList unresolvedDependencies = xdr2Db2Xsrobject.getUnresolvedXsrObjects();
                int i2 = 0;
                while (i2 < unresolvedDependencies.size()) {
                    DB2XMLSchemaDocument doc = xdr2Db2Xsrobject.convertUnresolved2DB2(unresolvedDependencies.get(i2));
                    if (doc != null) {
                        DB2XMLSchemaDocument fldDoc = this.getFirstLevelEquivalent(doc);
                        if (fldDoc != null && fromSelectionList) {
                            dependentDocs.add(fldDoc);
                            if (fldDoc == this.primaryDocument) {
                                this.primaryDocument = firstLevelDocument;
                            }
                            this.removeXMLSchemaDocFromTree(fldDoc, false);
                        } else {
                            DB2XMLSchemaDocument flDoc = this.getFirstLevelNameEquivalent(doc);
                            if (flDoc != null && fromSelectionList) {
                                dependentDocs.add(flDoc);
                                if (flDoc == this.primaryDocument) {
                                    this.primaryDocument = firstLevelDocument;
                                }
                                this.removeXMLSchemaDocFromTree(flDoc, false);
                            } else {
                                if (fldDoc != null) {
                                    this.firstLevelAndDependentDoc.add(fldDoc);
                                }
                                this.setPageComplete(false);
                                dependentDocs.add(doc);
                                this.invalidDocuments.add(doc);
                            }
                        }
                    }
                    ++i2;
                }
                this.dependentDocuments.put(firstLevelDocument, dependentDocs);
            }
            this.updateProvider();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
    }

    protected void removeXMLSchemaDocFromTree(DB2XMLSchemaDocument xmlSchemaDocument) {
        this.removeXMLSchemaDocFromTree(xmlSchemaDocument, false);
    }

    private void removeXMLSchemaDocFromTree(DB2XMLSchemaDocument xmlSchemaDocument, boolean deselect) {
        if (this.isDependentDocument(xmlSchemaDocument)) {
            DB2XMLSchemaDocument fdoc = this.getFirstLevelDocument(xmlSchemaDocument);
            ArrayList alDepDocs = (ArrayList)this.dependentDocuments.get(fdoc);
            if (this.invalidDocuments.contains(xmlSchemaDocument)) {
                this.invalidDocuments.remove(xmlSchemaDocument);
            }
            alDepDocs.remove(xmlSchemaDocument);
            if (this.firstLevelAndDependentDoc.contains(fdoc)) {
                this.firstLevelAndDependentDoc.remove(fdoc);
            }
            this.btnDependenciesRemove.setEnabled(false);
            this.btnSetPrimary.setEnabled(false);
        } else {
            ArrayList alDepDocs = (ArrayList)this.dependentDocuments.get(xmlSchemaDocument);
            for (DB2XMLSchemaDocument dDoc : alDepDocs) {
                if (!this.invalidDocuments.contains(dDoc)) continue;
                this.invalidDocuments.remove(dDoc);
            }
            if (xmlSchemaDocument == this.primaryDocument) {
                this.primaryDocument = null;
                this.txtTargetNamespace.setText("");
            }
            if (this.firstLevelAndDependentDoc.contains(xmlSchemaDocument)) {
                this.firstLevelAndDependentDoc.remove(xmlSchemaDocument);
            }
            if (this.dependentDocuments.containsKey(xmlSchemaDocument)) {
                this.dependentDocuments.remove(xmlSchemaDocument);
            }
            this.firstLevelDocuments.remove(xmlSchemaDocument);
            if (this.firstLevelDocuments.isEmpty()) {
                this.btnDependenciesRemove.setEnabled(false);
                this.btnSetPrimary.setEnabled(false);
            }
        }
        this.updateProvider();
        if (deselect) {
            ((RegisterXMLSchemaWizard)this.getWizard()).getSelectionPage().deselectDocument(xmlSchemaDocument);
        }
    }

    protected void updateProvider() {
        XMLSchemaDocItemProvider xmlSchemaItemProvider = new XMLSchemaDocItemProvider(this.treeViewer.getTree(), this.firstLevelDocuments, this.dependentDocuments);
        this.treeViewer.setContentProvider((IContentProvider)new XMLSchemaDocContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new XMLSchemaDocLabelProvider(this.primaryDocument, xmlSchemaItemProvider));
        this.treeViewer.setInput((Object)xmlSchemaItemProvider);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean validatePage() {
        return this.validatePage(true);
    }

    public boolean validatePage(boolean bool) {
        if (this.firstLevelDocuments.size() == 0) {
            if (bool && this.firstPageEntryOccurred) {
                this.setErrorMessage(XMLSchemaUIMessages.REGISTER_MSG_NO_DOCUMENT);
            }
            return false;
        }
        if (this.primaryDocument == null) {
            if (bool) {
                this.setErrorMessage(XMLSchemaUIMessages.REGISTER_MSG_NO_PRIMARY_DOCUMENT);
            }
            return false;
        }
        if (this.invalidDocuments.size() > 0) {
            if (bool) {
                this.setErrorMessage(XMLSchemaUIMessages.REGISTER_MSG_INVALID_DOCUMENT);
            }
            return false;
        }
        if (this.firstLevelAndDependentDoc.size() > 0) {
            if (bool) {
                this.setErrorMessage(XMLSchemaUIMessages.REGISTER_MSG_FIRSTLEVEL_DEPENDENT);
            }
            return false;
        }
        if (this.isZOS && this.firstLevelDocuments.size() > 1) {
            if (bool) {
                this.setErrorMessage(XMLSchemaUIMessages.REGISTER_WIZARD_ERROR_TITLE);
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean isPageComplete() {
        return this.validatePage();
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource().equals(this.txtSchemaLocation) && this.txtSchemaLocation != null && this.txtSchemaLocation.getText().trim().length() > 0 && !this.treeViewer.getSelection().isEmpty()) {
            ((DB2XMLSchemaDocument)((IStructuredSelection)this.treeViewer.getSelection()).iterator().next()).setSchemaLocation(this.txtSchemaLocation.getText().trim());
        }
        this.setPageComplete(this.validatePage());
    }

    public String getTargetNamespace() {
        return this.txtTargetNamespace.getText();
    }

    public boolean isDecomposition() {
        return this.btnDecomp.getSelection();
    }

    public boolean isGenScript() {
        if (this.isGenerate) {
            return true;
        }
        return this.btnGenScript.getSelection();
    }

    public String getStatementTerminator() {
        return this.txtTerminator.getText();
    }

    public Hashtable getDependentDocuments() {
        return this.dependentDocuments;
    }

    public ArrayList getFirstLevelDocuments() {
        return this.firstLevelDocuments;
    }

    public DB2XMLSchemaDocument getPrimaryDocument() {
        return this.primaryDocument;
    }

    public DB2XMLSchema getXmlSchema() {
        return this.xmlSchema;
    }

    protected boolean isDependentDocument(DB2XMLSchemaDocument doc) {
        for (ArrayList dependentDocs : this.dependentDocuments.values()) {
            if (!dependentDocs.contains(doc)) continue;
            return true;
        }
        return false;
    }

    private DB2XMLSchemaDocument getFirstLevelDocument(DB2XMLSchemaDocument doc) {
        for (DB2XMLSchemaDocument fdoc : this.firstLevelDocuments) {
            ArrayList dependentDocs = (ArrayList)this.dependentDocuments.get(fdoc);
            Iterator itDependentDocs = dependentDocs.iterator();
            while (itDependentDocs.hasNext()) {
                if ((DB2XMLSchemaDocument)itDependentDocs.next() != doc) continue;
                return fdoc;
            }
        }
        return null;
    }

    private boolean isInvalidDocument(DB2XMLSchemaDocument idoc) {
        for (DB2XMLSchemaDocument doc : this.invalidDocuments) {
            if (idoc != doc) continue;
            return true;
        }
        return false;
    }

    private DB2XMLSchemaDocument getInvalidEquivalent(DB2XMLSchemaDocument iDoc) {
        Iterator depDocuments = this.dependentDocuments.values().iterator();
        while (depDocuments.hasNext()) {
            for (DB2XMLSchemaDocument doc : (ArrayList)depDocuments.next()) {
                if (!doc.getName().equalsIgnoreCase(iDoc.getName())) continue;
                return doc;
            }
        }
        return null;
    }

    protected DB2XMLSchemaDocument getFirstLevelEquivalent(DB2XMLSchemaDocument fDoc) {
        for (DB2XMLSchemaDocument doc : this.firstLevelDocuments) {
            if (!doc.getName().equalsIgnoreCase(fDoc.getName()) || !doc.getFileName().equalsIgnoreCase(fDoc.getFileName()) || (doc.getTargetNamespace() == null || fDoc.getTargetNamespace() == null || !doc.getTargetNamespace().equalsIgnoreCase(fDoc.getTargetNamespace())) && (doc.getTargetNamespace() != null || fDoc.getTargetNamespace() != null)) continue;
            return doc;
        }
        return null;
    }

    protected DB2XMLSchemaDocument getFirstLevelNameEquivalent(DB2XMLSchemaDocument fDoc) {
        for (DB2XMLSchemaDocument doc : this.firstLevelDocuments) {
            if (!doc.getName().equalsIgnoreCase(fDoc.getName())) continue;
            return doc;
        }
        return null;
    }

    protected DB2XMLSchemaDocument getDependentEquivalent(DB2XMLSchemaDocument dDoc) {
        Iterator depDocuments = this.dependentDocuments.values().iterator();
        while (depDocuments.hasNext()) {
            for (DB2XMLSchemaDocument doc : (ArrayList)depDocuments.next()) {
                if (!doc.getName().equalsIgnoreCase(dDoc.getName()) || (doc.getTargetNamespace() == null || dDoc.getTargetNamespace() == null || !doc.getTargetNamespace().equalsIgnoreCase(dDoc.getTargetNamespace())) && (doc.getTargetNamespace() != null || dDoc.getTargetNamespace() != null)) continue;
                return doc;
            }
        }
        return null;
    }

    private boolean isSingleNamespace() {
        Iterator itFirstLevelDocuments = this.firstLevelDocuments.iterator();
        String targetNamespace = null;
        while (itFirstLevelDocuments.hasNext()) {
            DB2XMLSchemaDocument doc = (DB2XMLSchemaDocument)itFirstLevelDocuments.next();
            if (targetNamespace == null && doc.getTargetNamespace() != null) {
                targetNamespace = doc.getTargetNamespace();
            } else if (doc.getTargetNamespace() != null && targetNamespace != null && !doc.getTargetNamespace().trim().equalsIgnoreCase(targetNamespace)) {
                return false;
            }
            ArrayList al = (ArrayList)this.dependentDocuments.get(doc);
            if (al == null) continue;
            for (DB2XMLSchemaDocument depDoc : al) {
                if (depDoc.getTargetNamespace() == null || targetNamespace == null || depDoc.getTargetNamespace().trim().equalsIgnoreCase(targetNamespace)) continue;
                return false;
            }
        }
        return true;
    }

    public class UserDefinedPropertiesTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object arg0) {
            return ((ArrayList)arg0).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    public class UserDefinedPropertiesTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object object, int columnIndex) {
            String text = null;
            if (columnIndex == 0) {
                text = (String)object;
            }
            if (columnIndex == 1) {
                text = (String)object;
            }
            return text;
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }
    }
}

