/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.xml.schema.ui.wizard.register;

import com.ibm.datatools.common.util.DB2Version;
import com.ibm.datatools.common.util.SQLIdentifier;
import com.ibm.datatools.core.internal.ui.util.EclipseShell;
import com.ibm.datatools.xml.schema.ui.XMLSchemaUIPlugin;
import com.ibm.datatools.xml.schema.ui.nls.XMLSchemaUIMessages;
import com.ibm.datatools.xml.schema.ui.wizard.register.INamePage;
import com.ibm.datatools.xml.schema.ui.wizard.register.ProjectExplorerNamePage;
import com.ibm.datatools.xml.schema.ui.wizard.register.SelectionPage;
import com.ibm.datatools.xml.schema.ui.wizard.register.ServerExplorerNamePage;
import com.ibm.datatools.xml.schema.ui.wizard.register.XMLSchemaDocumentsPage;
import com.ibm.datatools.xml.schema.util.XMLSchemaUtility;
import com.ibm.db.models.db2.DB2ModelFactory;
import com.ibm.db.models.db2.DB2Schema;
import com.ibm.db.models.db2.DB2XMLSchema;
import com.ibm.db.models.db2.DB2XMLSchemaDocument;
import com.ibm.db.models.db2.zSeries.ZSeriesDatabase;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Shell;

public class RegisterXMLSchemaWizard
extends Wizard {
    private SelectionPage selPage;
    private INamePage namePage;
    private XMLSchemaDocumentsPage xmlSchemaDocPage;
    private Schema schema;
    private boolean projectExplorer;
    private boolean fromProjectFolder;
    private ArrayList selectedXsdList;
    private ConnectionInfo conInfo;
    private IProject project;
    private boolean isGenerate;
    private boolean isZOS;
    private static final String ZOS_SCHEMA_FOR_XML_SCHEMA = "SYSXSR";

    public RegisterXMLSchemaWizard(Schema schema, boolean projectExplorer, ArrayList selectedXsdList, ConnectionInfo conInfo, IProject project, boolean fromProjectFolder) {
        this(schema, projectExplorer, selectedXsdList, conInfo, project, fromProjectFolder, false);
    }

    public RegisterXMLSchemaWizard(Schema schema, boolean projectExplorer, ArrayList selectedXsdList, ConnectionInfo conInfo, IProject project, boolean fromProjectFolder, boolean isGenerate) {
        if (isGenerate) {
            this.setWindowTitle(XMLSchemaUIMessages.GENERATE_REGISTER_SCRIPT_WIZARD_TITLE);
        } else {
            this.setWindowTitle(XMLSchemaUIMessages.REGISTER_WIZARD_TITLE);
        }
        this.setDefaultPageImageDescriptor(XMLSchemaUIPlugin.getDefault().getImageDescriptor("xmlschema_wiz"));
        this.schema = schema;
        this.projectExplorer = projectExplorer;
        this.selectedXsdList = selectedXsdList;
        this.conInfo = conInfo;
        this.project = project;
        this.isGenerate = isGenerate;
        this.fromProjectFolder = fromProjectFolder;
    }

    public void addPages() {
        if (this.projectExplorer) {
            if (this.selectedXsdList.size() > 0 && this.fromProjectFolder) {
                this.selPage = new SelectionPage(this.selectedXsdList);
                this.addPage((IWizardPage)this.selPage);
            }
            this.namePage = new ProjectExplorerNamePage("NamePage", this.conInfo, this.project);
            this.addPage((IWizardPage)((ProjectExplorerNamePage)this.namePage));
        } else {
            this.namePage = new ServerExplorerNamePage("NamePage");
            this.addPage((IWizardPage)((ServerExplorerNamePage)this.namePage));
        }
        DB2Version db2Version = DB2Version.getSharedInstance((ConnectionInfo)this.conInfo);
        this.isZOS = false;
        if (db2Version.isDB390()) {
            this.isZOS = true;
        }
        this.xmlSchemaDocPage = new XMLSchemaDocumentsPage("XMLSchemaDocumentsPage", this.projectExplorer, this.isGenerate, this.isZOS);
        if (this.isZOS && db2Version.isDB390()) {
            this.xmlSchemaDocPage.setDB2Version(db2Version);
        }
        this.addPage((IWizardPage)this.xmlSchemaDocPage);
    }

    public Collection getSelectedItems() {
        if (this.selPage != null) {
            return this.selPage.getCheckedItems();
        }
        if (this.selectedXsdList != null) {
            return this.selectedXsdList;
        }
        return null;
    }

    public DB2XMLSchemaDocument getPrimarySelectedDocument() {
        if (this.selPage != null) {
            return this.selPage.getPrimaryDocument();
        }
        return null;
    }

    public SelectionPage getSelectionPage() {
        return this.selPage;
    }

    public INamePage getNamePage() {
        return this.namePage;
    }

    public XMLSchemaDocumentsPage getXMLSchemaDocPage() {
        return this.xmlSchemaDocPage;
    }

    private DB2Schema getDB2Schema(String name) {
        if (this.conInfo != null && !this.conInfo.getName().equals("")) {
            Database db = this.conInfo.getSharedDatabase();
            for (Object o : db.getSchemas()) {
                Schema schema;
                if (!(o instanceof Schema) || !(schema = (Schema)o).getName().equals(name)) continue;
                return (DB2Schema)schema;
            }
            return this.createSchemaForDatabase(db, name);
        }
        return null;
    }

    private DB2Schema createSchemaForDatabase(Database db, String schemaName) {
        DB2Schema newSchema = DB2ModelFactory.eINSTANCE.createDB2Schema();
        newSchema.setName(schemaName.trim());
        if (db != null) {
            newSchema.setDatabase(db);
            db.getSchemas().add((Object)newSchema);
        }
        return newSchema;
    }

    private boolean isZOSXMLSchemaAlreadyExists(String xmlSchemaName) {
        Database db;
        if (this.conInfo != null && !this.conInfo.getName().equals("") && (db = this.conInfo.getSharedDatabase()) instanceof ZSeriesDatabase) {
            ZSeriesDatabase catalogDb = (ZSeriesDatabase)db;
            for (DB2XMLSchema schema : this.getXMLSchema(catalogDb)) {
                if (!schema.getName().trim().equals(xmlSchemaName.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isXMLSchemaAlreadyExists(String xmlSchemaName, String relationalSchemaName) {
        if (this.conInfo != null && !this.conInfo.getName().equals("")) {
            Database db = this.conInfo.getSharedDatabase();
            for (Object o : db.getSchemas()) {
                Schema schema;
                if (!(o instanceof Schema) || !(schema = (Schema)o).getName().equals(relationalSchemaName)) continue;
                for (Object obj : ((DB2Schema)schema).getXsrObjects()) {
                    DB2XMLSchema xmlschema;
                    if (!(obj instanceof DB2XMLSchema) || !xmlSchemaName.equals((xmlschema = (DB2XMLSchema)obj).getName().trim())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean performFinish() {
        DB2Version db2Version = DB2Version.getSharedInstance((ConnectionInfo)this.conInfo);
        boolean continueRegistering = true;
        boolean drop = false;
        String schemaName = null;
        DB2XMLSchema db2xmlSchema = this.xmlSchemaDocPage.getXmlSchema();
        db2xmlSchema.setName(SQLIdentifier.toCatalogFormat((String)this.namePage.getName(), (ConnectionInfo)this.conInfo));
        boolean genScript = this.xmlSchemaDocPage.isGenScript();
        if (!this.isZOS) {
            schemaName = this.schema != null ? this.schema.getName() : SQLIdentifier.toCatalogFormat((String)((ProjectExplorerNamePage)this.namePage).getSchemaName(), (ConnectionInfo)this.conInfo);
            if (this.isXMLSchemaAlreadyExists(db2xmlSchema.getName(), schemaName)) {
                boolean bl = continueRegistering = this.isGenerate || MessageDialog.openConfirm((Shell)XMLSchemaUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)XMLSchemaUIMessages.REGISTER_WIZARD_ERROR_TITLE, (String)NLS.bind((String)XMLSchemaUIMessages.REGISTER_ALREADY_EXISTS, (Object[])new Object[]{db2xmlSchema.getName()}));
                if (continueRegistering) {
                    drop = true;
                }
            }
            if (this.schema == null) {
                this.schema = this.getDB2Schema(schemaName);
            }
            Schema copyOfSchema = (Schema)EcoreUtil.copy((EObject)this.schema);
            db2xmlSchema.setSchema((DB2Schema)copyOfSchema);
        } else {
            if (this.schema == null) {
                this.schema = this.getDB2Schema(ZOS_SCHEMA_FOR_XML_SCHEMA);
            }
            if (this.isZOSXMLSchemaAlreadyExists(db2xmlSchema.getName())) {
                boolean bl = continueRegistering = this.isGenerate || MessageDialog.openConfirm((Shell)XMLSchemaUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)XMLSchemaUIMessages.REGISTER_WIZARD_ERROR_TITLE, (String)NLS.bind((String)XMLSchemaUIMessages.REGISTER_ALREADY_EXISTS, (Object[])new Object[]{db2xmlSchema.getName()}));
                if (continueRegistering) {
                    drop = true;
                }
            }
        }
        if (continueRegistering) {
            final DB2XMLSchema fDb2XMLSchema = db2xmlSchema;
            final boolean fIsGenerate = this.isGenerate;
            final boolean fDrop = drop;
            final boolean fIsZOS = this.isZOS;
            final boolean fGenScript = genScript;
            final String fSchemaName = schemaName;
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    block42: {
                        ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
                        String key = XMLSchemaUIMessages.REGISTER_ACTION;
                        if (fIsGenerate) {
                            key = XMLSchemaUIMessages.GENERATE_ACTION;
                        }
                        String displayName = fSchemaName == null ? fDb2XMLSchema.getName() : String.valueOf(fSchemaName) + '.' + fDb2XMLSchema.getName();
                        StringBuffer displayStrBuffer = new StringBuffer(key.length() + " - ".length() + displayName.length());
                        displayStrBuffer.append(key).append(" - ").append(displayName);
                        OperationCommand cmd = new OperationCommand(4, displayStrBuffer.toString(), displayName, RegisterXMLSchemaWizard.this.conInfo.getName(), RegisterXMLSchemaWizard.this.conInfo.getDatabaseName());
                        resultsView.createNewInstance(cmd, null);
                        ArrayList dependencyList = new ArrayList();
                        ArrayList firstLevelDocs = RegisterXMLSchemaWizard.this.xmlSchemaDocPage.getFirstLevelDocuments();
                        Hashtable dependentDocuments = RegisterXMLSchemaWizard.this.xmlSchemaDocPage.getDependentDocuments();
                        int i = 0;
                        while (i < firstLevelDocs.size()) {
                            dependencyList.add(firstLevelDocs.get(i));
                            ArrayList dl = (ArrayList)dependentDocuments.get(firstLevelDocs.get(i));
                            int j = 0;
                            while (j < dl.size()) {
                                dependencyList.add(dl.get(j));
                                ++j;
                            }
                            ++i;
                        }
                        Connection connection = RegisterXMLSchemaWizard.this.conInfo.getSharedConnection();
                        boolean savedAutoCommitFlag = false;
                        boolean isAutoCommit = false;
                        try {
                            try {
                                isAutoCommit = connection.getAutoCommit();
                                savedAutoCommitFlag = true;
                                connection.setAutoCommit(false);
                                try {
                                    if (fDrop) {
                                        try {
                                            XMLSchemaUtility.deregisterXMLSchema((Schema)RegisterXMLSchemaWizard.this.schema, (ConnectionInfo)RegisterXMLSchemaWizard.this.conInfo, (DB2XMLSchema)fDb2XMLSchema, (boolean)true, (boolean)true);
                                            if (!fIsGenerate) {
                                                ResultsViewAPI.getInstance().appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_SUCCESS, (Object[])new Object[]{displayName}));
                                            }
                                        }
                                        catch (Exception e) {
                                            ResultsViewAPI.getInstance().appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_FAILURE, (Object[])new Object[]{displayName}));
                                            throw e;
                                        }
                                    }
                                    XMLSchemaUtility.registerXMLSchema((ConnectionInfo)RegisterXMLSchemaWizard.this.conInfo, dependencyList, (DB2XMLSchemaDocument)RegisterXMLSchemaWizard.this.xmlSchemaDocPage.getPrimaryDocument(), (Schema)RegisterXMLSchemaWizard.this.schema, (String)fDb2XMLSchema.getName(), (String)RegisterXMLSchemaWizard.this.namePage.getComment(), (boolean)RegisterXMLSchemaWizard.this.xmlSchemaDocPage.isDecomposition());
                                }
                                catch (ClassNotFoundException e) {
                                    ResultsViewAPI.getInstance().appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_DRIVER_OV_ERROR, (Object[])new Object[]{displayName}));
                                    throw e;
                                }
                                catch (NoSuchMethodException e) {
                                    ResultsViewAPI.getInstance().appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_DRIVER_OV_ERROR, (Object[])new Object[]{displayName}));
                                    throw e;
                                }
                                catch (IllegalAccessException e) {
                                    ResultsViewAPI.getInstance().appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_DRIVER_OV_ERROR, (Object[])new Object[]{displayName}));
                                    throw e;
                                }
                                catch (ClassCastException e) {
                                    ResultsViewAPI.getInstance().appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_DRIVER_OV_ERROR, (Object[])new Object[]{displayName}));
                                    throw e;
                                }
                                if (!fIsGenerate) {
                                    ResultsViewAPI.getInstance().appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_SUCCESS, (Object[])new Object[]{displayName}));
                                }
                                if (fIsGenerate) {
                                    connection.rollback();
                                } else {
                                    connection.commit();
                                }
                                if (fGenScript) {
                                    String scriptContent = XMLSchemaUtility.generateRegisterXMLSchemaDdlContent(dependencyList, (DB2XMLSchemaDocument)RegisterXMLSchemaWizard.this.xmlSchemaDocPage.getPrimaryDocument(), (Schema)RegisterXMLSchemaWizard.this.schema, (String)SQLIdentifier.toSQLFormat((String)fDb2XMLSchema.getName(), (ConnectionInfo)RegisterXMLSchemaWizard.this.conInfo), (String)RegisterXMLSchemaWizard.this.namePage.getComment(), (boolean)RegisterXMLSchemaWizard.this.xmlSchemaDocPage.isDecomposition(), (boolean)fIsZOS, (String)RegisterXMLSchemaWizard.this.xmlSchemaDocPage.getStatementTerminator());
                                    File tempFile = File.createTempFile("xsr", null);
                                    tempFile.deleteOnExit();
                                    FileWriter tempFileWriter = new FileWriter(tempFile);
                                    tempFileWriter.write(scriptContent);
                                    tempFileWriter.close();
                                    EclipseShell.getInstance().openTextFile(tempFile);
                                    resultsView.appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.GENERATE_SUCCESS, (Object[])new Object[]{displayName}));
                                }
                                resultsView.updateStatus(cmd, 3);
                                if (savedAutoCommitFlag) {
                                    connection.setAutoCommit(isAutoCommit);
                                }
                                if (!fIsZOS) {
                                    if (RegisterXMLSchemaWizard.this.schema != null) {
                                        IServicesManager.INSTANCE.getServerExplorerRefreshService().refresh((Object)RegisterXMLSchemaWizard.this.schema);
                                    }
                                } else if (RegisterXMLSchemaWizard.this.conInfo.getSharedDatabase() != null) {
                                    IServicesManager.INSTANCE.getServerExplorerRefreshService().refresh((Object)RegisterXMLSchemaWizard.this.conInfo.getSharedDatabase());
                                }
                            }
                            catch (Exception e) {
                                XMLSchemaUIPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
                                if (RegisterXMLSchemaWizard.this.schema != null && ((DB2Schema)RegisterXMLSchemaWizard.this.schema).getXsrObjects().contains((Object)fDb2XMLSchema)) {
                                    ((DB2Schema)RegisterXMLSchemaWizard.this.schema).getXsrObjects().remove((Object)fDb2XMLSchema);
                                }
                                if (e.getMessage() != null && e.getMessage().length() > 0) {
                                    resultsView.appendThrowable(cmd, (Throwable)e);
                                    resultsView.appendStatusMessage(cmd, e.getLocalizedMessage());
                                }
                                if (fIsGenerate) {
                                    resultsView.appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.GENERATE_FAILURE, (Object[])new Object[]{displayName}));
                                } else {
                                    resultsView.appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_FAILURE, (Object[])new Object[]{displayName}));
                                }
                                resultsView.updateStatus(cmd, 6);
                                try {
                                    connection.rollback();
                                    resultsView.appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.ROLLBACK_SUCCESS, (Object[])new Object[]{displayName}));
                                }
                                catch (Exception e1) {
                                    if (e1.getMessage() != null && e1.getMessage().length() > 0) {
                                        resultsView.appendThrowable(cmd, (Throwable)e1);
                                        resultsView.appendStatusMessage(cmd, e1.getMessage());
                                    }
                                    resultsView.appendStatusMessage(cmd, NLS.bind((String)XMLSchemaUIMessages.ROLLBACK_FAILURE, (Object[])new Object[]{displayName}));
                                }
                                if (savedAutoCommitFlag) {
                                    try {
                                        connection.setAutoCommit(isAutoCommit);
                                    }
                                    catch (SQLException sQLException) {}
                                }
                                break block42;
                            }
                        }
                        catch (Throwable throwable) {
                            if (savedAutoCommitFlag) {
                                try {
                                    connection.setAutoCommit(isAutoCommit);
                                }
                                catch (SQLException sQLException) {}
                            }
                            throw throwable;
                        }
                        if (savedAutoCommitFlag) {
                            try {
                                connection.setAutoCommit(isAutoCommit);
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    private List<DB2XMLSchema> getXMLSchema(ZSeriesDatabase database) {
        ArrayList<DB2XMLSchema> schemaList = new ArrayList<DB2XMLSchema>();
        for (Object o : database.getSchemas()) {
            DB2Schema s = (DB2Schema)o;
            EList schemas = s.getXsrObjects();
            if (schemas.isEmpty()) continue;
            schemaList.addAll((Collection<DB2XMLSchema>)schemas);
        }
        return schemaList;
    }
}

