/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.xml.schema.ui.wizard.register;

import com.ibm.datatools.common.ui.controls.SmartCombo;
import com.ibm.datatools.common.ui.controls.support.SmartFactory;
import com.ibm.datatools.common.ui.diagnoser.handler.WizardPageDiagnosisHandler;
import com.ibm.datatools.common.ui.diagnoser.util.DiagnosisHandler;
import com.ibm.datatools.common.ui.diagnoser.util.SmartConstants;
import com.ibm.datatools.common.ui.diagnoser.util.SmartConstraints;
import com.ibm.datatools.common.ui.diagnoser.util.SmartUtil;
import com.ibm.datatools.common.util.DB2Version;
import com.ibm.datatools.common.util.SQLIdentifier;
import com.ibm.datatools.project.dev.util.ProjectHelper;
import com.ibm.datatools.xml.schema.ui.nls.XMLSchemaUIMessages;
import com.ibm.datatools.xml.schema.ui.wizard.register.INamePage;
import com.ibm.datatools.xml.schema.ui.wizard.register.RegisterXMLSchemaWizard;
import com.ibm.db.models.db2.DB2Schema;
import com.ibm.db.models.db2.DB2XMLSchema;
import com.ibm.db.models.db2.DB2XMLSchemaDocument;
import com.ibm.db.models.db2.zSeries.ZSeriesDatabase;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class ProjectExplorerNamePage
extends WizardPage
implements SelectionListener,
ModifyListener,
INamePage {
    protected final int MIN_ID_LENGTH = 1;
    protected final int MAX_ID_LENGTH = 128;
    protected Label lblRName;
    protected Label lblSName;
    protected Label lblComment;
    protected SmartCombo cRName;
    protected SmartCombo cSName;
    protected DiagnosisHandler diagHandler = new WizardPageDiagnosisHandler((WizardPage)this);
    protected Text txtComment;
    protected ConnectionInfo conInfo;
    protected IProject project;
    protected DB2XMLSchema selectedXmlSchema;
    protected boolean isZOS = false;

    public ProjectExplorerNamePage(String name, ConnectionInfo conInfo, IProject project) {
        super(name);
        this.setTitle(XMLSchemaUIMessages.REGISTER_WIZARD_NAMES_AND_COMMENT_PAGE_TITLE);
        this.setDescription(XMLSchemaUIMessages.REGISTER_WIZARD_NAMES_AND_COMMENT_PAGE_DESC);
        this.conInfo = conInfo;
        this.project = project;
        DB2Version db2Version = DB2Version.getSharedInstance((ConnectionInfo)conInfo);
        if (db2Version.isDB390()) {
            this.isZOS = true;
        }
    }

    public void createControl(Composite parent) {
        SmartConstraints c;
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.verticalSpacing = 10;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "com.ibm.datatools.xml.schema.infopop.schema_name");
        if (!this.isZOS) {
            this.lblRName = new Label(comp, 0);
            this.lblRName.setText(XMLSchemaUIMessages.REGISTER_WIZARD_RELATIONAL_SCHEMA_NAME);
            GridData gdRLblName = new GridData();
            gdRLblName.horizontalSpan = 1;
            this.lblRName.setLayoutData((Object)gdRLblName);
            this.cRName = SmartFactory.createSmartCombo((Composite)comp, (int)4, (BitSet)SmartConstants.SQL_IDENTIFIER_QUALIFY_NEVER);
            c = this.cRName.getConstraints();
            c.setRequired(true);
            c.setDescription(SmartUtil.stripMnemonic((String)this.lblRName.getText()));
            c.setConnectionInfo(this.conInfo);
            c.setSubtype((Object)"Schema");
            c.setMinMaxLength(1, 128);
            this.cRName.addSelectionListener((SelectionListener)this);
            GridData gdRTxtName = new GridData(768);
            this.cRName.setLayoutData((Object)gdRTxtName);
        }
        this.lblSName = new Label(comp, 0);
        this.lblSName.setText(XMLSchemaUIMessages.REGISTER_WIZARD_XML_SCHEMA_NAME);
        GridData gdSLblName = new GridData();
        gdSLblName.horizontalSpan = 1;
        this.lblSName.setLayoutData((Object)gdSLblName);
        this.cSName = SmartFactory.createSmartCombo((Composite)comp, (int)4, (BitSet)SmartConstants.SQL_IDENTIFIER_QUALIFY_NEVER);
        c = this.cSName.getConstraints();
        c.setRequired(true);
        c.setDescription(SmartUtil.stripMnemonic((String)this.lblSName.getText()));
        c.setConnectionInfo(this.conInfo);
        c.setMinMaxLength(1, 128);
        this.cSName.addSelectionListener((SelectionListener)this);
        GridData gdSTxtName = new GridData(768);
        this.cSName.setLayoutData((Object)gdSTxtName);
        this.lblComment = new Label(comp, 0);
        this.lblComment.setText(XMLSchemaUIMessages.REGISTER_WIZARD_XML_SCHEMA_COMMENT);
        GridData gdLblComment = new GridData(2);
        gdLblComment.horizontalSpan = 1;
        this.lblComment.setLayoutData((Object)gdLblComment);
        this.txtComment = new Text(comp, 2114);
        GridData gdTxtComment = new GridData(768);
        gdTxtComment.horizontalAlignment = 4;
        gdTxtComment.heightHint = 50;
        gdTxtComment.verticalAlignment = 3;
        this.txtComment.setLayoutData((Object)gdTxtComment);
        this.setControl((Control)comp);
        if (!this.isZOS) {
            this.initializeRelationalSchemaList();
        }
        this.updateXMLSchemaList();
        if (!this.isZOS) {
            this.diagHandler.handleDiagnosis((Drawable)this.cRName);
        }
        this.diagHandler.handleDiagnosis((Drawable)this.cSName);
        if (this.cRName != null && this.cRName.getText().length() == 0 || this.cSName.getText().length() == 0) {
            this.setPageComplete(false);
        }
        this.cSName.addModifyListener((ModifyListener)this);
        if (this.cRName != null) {
            this.cRName.addModifyListener((ModifyListener)this);
        }
        this.txtComment.addModifyListener((ModifyListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.cRName != null) {
            if (e.getSource().equals(this.cRName.getChild())) {
                this.updateXMLSchemaList();
            }
        } else if (e.getSource().equals(this.cSName.getChild())) {
            this.updateSchemaDocList();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void initializeRelationalSchemaList() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.conInfo != null && !this.conInfo.getName().equals("")) {
            Database db = this.conInfo.getSharedDatabase();
            for (Object o : db.getSchemas()) {
                Schema schema;
                if (!(o instanceof Schema) || (schema = (Schema)o).getName().startsWith("SYS")) continue;
                names.add(SQLIdentifier.toSQLFormat((String)schema.getName().trim(), (ConnectionInfo)this.conInfo));
            }
            String currentSchema = ProjectHelper.getCurrentSchema((IProject)this.project);
            if (!(currentSchema == null || names.contains(currentSchema) || currentSchema.trim().equals("") || currentSchema.startsWith("SYS"))) {
                names.add(currentSchema);
            }
            Object[] nameList = new String[names.size()];
            Iterator it2 = names.iterator();
            int i = 0;
            while (it2.hasNext()) {
                nameList[i] = ((String)it2.next()).trim();
                ++i;
            }
            Arrays.sort(nameList);
            this.cRName.setItems((String[])nameList);
            String[] items = this.cRName.getItems();
            int selectedIndex = 0;
            String compareSchema = "";
            if (currentSchema != null && !currentSchema.equalsIgnoreCase("")) {
                compareSchema = currentSchema.trim();
            } else if (this.conInfo.getUserName() != null && !this.conInfo.getUserName().trim().equalsIgnoreCase("")) {
                compareSchema = SQLIdentifier.convertAuthID((String)this.conInfo.getUserName().trim(), (ConnectionInfo)this.conInfo);
            }
            if (!compareSchema.equals("")) {
                int j = 0;
                while (j < items.length) {
                    if (items[j].equals(compareSchema)) {
                        selectedIndex = j;
                        break;
                    }
                    ++j;
                }
            }
            this.cRName.select(selectedIndex);
        } else {
            this.lblRName.setEnabled(false);
        }
    }

    public void updateXMLSchemaList() {
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, DB2XMLSchema> schemaList = new HashMap<String, DB2XMLSchema>();
        if (this.conInfo != null && !this.conInfo.getName().equals("")) {
            Database db = this.conInfo.getSharedDatabase();
            if (!this.isZOS) {
                for (Object o : db.getSchemas()) {
                    Schema schema;
                    String schemaNameInSQLFormat;
                    if (!(o instanceof Schema) || (!this.isIdentifierDelimited(schemaNameInSQLFormat = SQLIdentifier.toSQLFormat((String)(schema = (Schema)o).getName(), (ConnectionInfo)this.conInfo), this.conInfo) || !schemaNameInSQLFormat.equals(this.cRName.getText())) && !schemaNameInSQLFormat.equalsIgnoreCase(this.cRName.getText()) || schemaNameInSQLFormat.startsWith("SYS")) continue;
                    for (Object obj : ((DB2Schema)schema).getXsrObjects()) {
                        if (!(obj instanceof DB2XMLSchema)) continue;
                        DB2XMLSchema xmlschema = (DB2XMLSchema)obj;
                        schemaList.put(SQLIdentifier.toSQLFormat((String)xmlschema.getName().trim(), (ConnectionInfo)this.conInfo), xmlschema);
                        names.add(SQLIdentifier.toSQLFormat((String)xmlschema.getName().trim(), (ConnectionInfo)this.conInfo));
                    }
                }
            } else {
                ZSeriesDatabase catalogDb = (ZSeriesDatabase)db;
                for (DB2XMLSchema schema : this.getXMLSchema(catalogDb)) {
                    schemaList.put(SQLIdentifier.toSQLFormat((String)schema.getName().trim(), (ConnectionInfo)this.conInfo), schema);
                    names.add(SQLIdentifier.toSQLFormat((String)schema.getName().trim(), (ConnectionInfo)this.conInfo));
                }
            }
            Object[] nameList = new String[names.size()];
            Iterator it2 = names.iterator();
            int i = 0;
            while (it2.hasNext()) {
                nameList[i] = ((String)it2.next()).trim();
                ++i;
            }
            Arrays.sort(nameList);
            this.cSName.setItems((String[])nameList);
            this.cSName.select(0);
            this.selectedXmlSchema = (DB2XMLSchema)schemaList.get(this.cSName.getText());
            if (this.txtComment != null && this.selectedXmlSchema != null) {
                String comment = this.selectedXmlSchema.getDescription();
                if (comment != null) {
                    this.txtComment.setText(comment);
                } else {
                    this.txtComment.setText("");
                }
            } else {
                this.txtComment.setText("");
            }
        } else {
            this.lblSName.setEnabled(false);
        }
    }

    public void updateSchemaDocList() {
        EList schemaDocuments;
        DB2XMLSchema xmlSchema = null;
        if (this.selectedXmlSchema != null && (schemaDocuments = this.selectedXmlSchema.getXmlSchemaDocs()) != null) {
            this.removeXsdFromSchemaDocList(schemaDocuments);
        }
        if (this.conInfo != null && !this.conInfo.getName().equals("")) {
            Database db = this.conInfo.getSharedDatabase();
            if (!this.isZOS) {
                block0: for (Object o : db.getSchemas()) {
                    Schema schema;
                    String schemaNameInSQLFormat;
                    if (!(o instanceof Schema) || (!this.isIdentifierDelimited(schemaNameInSQLFormat = SQLIdentifier.toSQLFormat((String)(schema = (Schema)o).getName(), (ConnectionInfo)this.conInfo), this.conInfo) || !schemaNameInSQLFormat.equals(this.cRName.getText())) && !schemaNameInSQLFormat.equalsIgnoreCase(this.cRName.getText()) || schemaNameInSQLFormat.startsWith("SYS")) continue;
                    for (Object obj : ((DB2Schema)schema).getXsrObjects()) {
                        DB2XMLSchema xmlschema;
                        if (!(obj instanceof DB2XMLSchema) || !SQLIdentifier.toSQLFormat((String)(xmlschema = (DB2XMLSchema)obj).getName().trim(), (ConnectionInfo)this.conInfo).equals(this.cSName.getText())) continue;
                        xmlSchema = xmlschema;
                        continue block0;
                    }
                }
            } else {
                for (DB2XMLSchema schema : this.getXMLSchema((ZSeriesDatabase)db)) {
                    if (!SQLIdentifier.toSQLFormat((String)schema.getName().trim(), (ConnectionInfo)this.conInfo).equals(this.cSName.getText())) continue;
                    xmlSchema = schema;
                    break;
                }
            }
        }
        this.selectedXmlSchema = xmlSchema;
        if (this.txtComment != null && this.selectedXmlSchema != null) {
            String comment = this.selectedXmlSchema.getDescription();
            if (comment != null) {
                this.txtComment.setText(comment);
            } else {
                this.txtComment.setText("");
            }
        }
    }

    private void removeXsdFromSchemaDocList(EList oldList) {
        if (oldList != null) {
            ArrayList<DB2XMLSchemaDocument> schemaDocList = new ArrayList<DB2XMLSchemaDocument>();
            for (DB2XMLSchemaDocument oldNamePageDoc : oldList) {
                if (this.isDocInList(oldNamePageDoc, ((RegisterXMLSchemaWizard)this.getWizard()).getSelectedItems())) continue;
                schemaDocList.add(oldNamePageDoc);
            }
            int i = 0;
            while (i < schemaDocList.size()) {
                DB2XMLSchemaDocument fDoc = ((RegisterXMLSchemaWizard)this.getWizard()).getXMLSchemaDocPage().getFirstLevelEquivalent((DB2XMLSchemaDocument)schemaDocList.get(i));
                DB2XMLSchemaDocument dDoc = ((RegisterXMLSchemaWizard)this.getWizard()).getXMLSchemaDocPage().getDependentEquivalent((DB2XMLSchemaDocument)schemaDocList.get(i));
                if (fDoc != null) {
                    ((RegisterXMLSchemaWizard)this.getWizard()).getXMLSchemaDocPage().removeXMLSchemaDocFromTree(fDoc);
                } else if (dDoc != null) {
                    ((RegisterXMLSchemaWizard)this.getWizard()).getXMLSchemaDocPage().removeXMLSchemaDocFromTree(dDoc);
                }
                ++i;
            }
        }
    }

    protected boolean isIdentifierDelimited(String identifier, ConnectionInfo conInfo) {
        boolean result = false;
        if (identifier != null && identifier.length() > 0 && identifier.charAt(0) == SQLIdentifier.getDelimiter((Connection)conInfo.getSharedConnection())) {
            result = true;
        }
        return result;
    }

    protected boolean isDocInList(DB2XMLSchemaDocument fDoc, Collection col) {
        for (DB2XMLSchemaDocument doc : col) {
            if (!doc.getName().equals(fDoc.getName()) || doc.getTargetNamespace() == null || fDoc.getTargetNamespace() == null || !doc.getTargetNamespace().equals(fDoc.getTargetNamespace())) continue;
            return true;
        }
        return false;
    }

    public void modifyText(ModifyEvent e) {
        if (this.cRName != null && e.getSource().equals(this.cRName.getChild())) {
            this.updateXMLSchemaList();
        }
        if (e.getSource().equals(this.cSName.getChild())) {
            this.updateSchemaDocList();
        }
    }

    public EList getSchemaDocuments() {
        return this.selectedXmlSchema.getXmlSchemaDocs();
    }

    public DB2XMLSchema getSelectedXmlSchema() {
        return this.selectedXmlSchema;
    }

    @Override
    public String getName() {
        return this.cSName.getText();
    }

    public String getSchemaName() {
        if (this.cRName != null) {
            return this.cRName.getText();
        }
        return null;
    }

    @Override
    public String getComment() {
        return this.txtComment.getText();
    }

    public boolean isPageComplete() {
        return this.diagHandler.isPageValid();
    }

    private List<DB2XMLSchema> getXMLSchema(ZSeriesDatabase database) {
        ArrayList<DB2XMLSchema> schemaList = new ArrayList<DB2XMLSchema>();
        for (Object o : database.getSchemas()) {
            DB2Schema s = (DB2Schema)o;
            EList schemas = s.getXsrObjects();
            if (schemas.isEmpty()) continue;
            schemaList.addAll((Collection<DB2XMLSchema>)schemas);
        }
        return schemaList;
    }
}

