/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.xml.schema.ui.projectexplorer;

import com.ibm.datatools.common.util.Utility;
import com.ibm.datatools.project.dev.node.IGenericFolder;
import com.ibm.datatools.project.dev.node.INode;
import com.ibm.datatools.project.dev.util.ProjectHelper;
import com.ibm.datatools.project.internal.dev.explorer.popup.IXMLEnablementActionFilter;
import com.ibm.datatools.project.internal.dev.explorer.providers.content.node.DatabaseDevelopmentProject;
import com.ibm.datatools.project.internal.dev.explorer.providers.content.node.GenericNode;
import com.ibm.datatools.sqlxeditor.util.SQLXDBUtils;
import com.ibm.datatools.xml.core.ui.util.Xdr2DB2XsrObject;
import com.ibm.datatools.xml.schema.ui.XMLSchemaUIPlugin;
import com.ibm.datatools.xml.schema.ui.nls.XMLSchemaUIMessages;
import com.ibm.db.models.db2.DB2XMLSchema;
import com.ibm.db.models.db2.DB2XMLSchemaDocument;
import com.ibm.db2.common.xmlutils.xdr.XdrType;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class XMLSchemaDocumentNode
extends GenericNode
implements IXMLEnablementActionFilter {
    public static final String XSD_EXTENSON = XMLSchemaUIPlugin.getResourceString("%XSD_EXTENSION");

    public XMLSchemaDocumentNode() {
    }

    public XMLSchemaDocumentNode(IGenericFolder parent, IResource res) {
        super(parent, res);
    }

    public Object getModelObject() {
        if (this.modelObject == null) {
            IResource resource = this.getResource();
            String fileName = resource.getLocation().toOSString();
            this.modelObject = XMLSchemaDocumentNode.getXSDFromFile(fileName);
        }
        return this.modelObject;
    }

    public static DB2XMLSchemaDocument getXSDFromFile(String fileName) {
        DB2XMLSchemaDocument rtndoc = null;
        try {
            File file = new File(fileName);
            Xdr2DB2XsrObject xdr2Db2Xsrobject = new Xdr2DB2XsrObject(file.toURL(), XdrType.WXS);
            DB2XMLSchema db2XmlSchema = xdr2Db2Xsrobject.getDB2XMLSchema();
            EList schemaDocList = db2XmlSchema.getXmlSchemaDocs();
            for (Object o : schemaDocList) {
                DB2XMLSchemaDocument doc;
                File docFile;
                boolean isSame;
                if (!(o instanceof DB2XMLSchemaDocument) || !(isSame = file.equals(docFile = new File((doc = (DB2XMLSchemaDocument)o).getFileName())))) continue;
                rtndoc = doc;
                break;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return rtndoc;
    }

    public boolean testAttribute(Object target, String name, String value) {
        boolean result = false;
        if (name.equals("isServerXMLEnabled") && (value.equals("true") || value.equals("false"))) {
            ConnectionInfo conInfo = ProjectHelper.getConnectionInfo((IProject)((DatabaseDevelopmentProject)((INode)target).getParent().getParent()).getProject());
            boolean online = false;
            online = SQLXDBUtils.reestablishConnection((ConnectionInfo)conInfo);
            if (!online) {
                MessageDialog.openError((Shell)XMLSchemaUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)XMLSchemaUIMessages.REGISTER_WIZARD_ERROR_TITLE, (String)XMLSchemaUIMessages.REGISTER_OFFLINE_ERROR);
            } else {
                boolean isXMLSupported = Utility.isXMLSchemaSupported((ConnectionInfo)conInfo);
                result = isXMLSupported == Boolean.valueOf(value);
            }
        }
        return result;
    }
}

