/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.xml.schema.ui.editor;

import com.ibm.datatools.project.dev.node.IDatabaseDevelopmentProject;
import com.ibm.datatools.project.internal.core.ProjectExplorer;
import com.ibm.datatools.project.internal.dev.explorer.providers.dnd.DropXMLDocumentHandler;
import com.ibm.datatools.project.internal.dev.project.wizard.DDPNewOrExistingProjectsWizardPage;
import com.ibm.datatools.xml.schema.ui.XMLSchemaUIPlugin;
import com.ibm.datatools.xml.schema.ui.editor.OpenXSDFromServerProjectPage;
import com.ibm.datatools.xml.schema.ui.nls.XMLSchemaUIMessages;
import com.ibm.db.models.db2.DB2XMLSchemaDocument;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.EclipseUtilities;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class OpenXSDFromServerWizard
extends Wizard {
    protected DDPNewOrExistingProjectsWizardPage projectPage;
    protected IWorkbenchPartSite site;
    protected DB2XMLSchemaDocument xsd;
    protected String projectName;
    protected IProject project;
    protected IDatabaseDevelopmentProject newDDProject;
    protected ConnectionInfo connectionInfo;

    public OpenXSDFromServerWizard(DB2XMLSchemaDocument xsd, ConnectionInfo conInfo) {
        this.xsd = xsd;
        this.connectionInfo = conInfo;
        this.showView();
    }

    public void addPages() {
        this.projectPage = new OpenXSDFromServerProjectPage();
        this.addPage((IWizardPage)this.projectPage);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    protected void setWindowTitleAndPageImage() {
        this.setWindowTitle(XMLSchemaUIMessages.EDITOR_COPY_XSD_TO_PROJECT_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(XMLSchemaUIPlugin.getDefault().getImageDescriptor("xmlschema_wiz"));
    }

    public void showView() {
        WizardDialog dialog = new WizardDialog(XMLSchemaUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this);
        dialog.open();
    }

    public boolean performFinish() {
        boolean ret = true;
        this.projectPage.performFinish();
        this.setProjectName(((OpenXSDFromServerProjectPage)this.getStartingPage()).getProjectName());
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow aw = workbench.getActiveWorkbenchWindow();
        if (aw != null) {
            this.site = aw.getPartService().getActivePart().getSite();
            this.focusExplorer("com.ibm.datatools.project.ui.projectExplorer");
        }
        IPath targetPath = null;
        if (this.projectExists(this.projectName)) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
            OpenXSDFromServerWizard.selectAndReveal((IResource)this.project, aw);
            this.expandProject(this.project, aw);
            targetPath = this.project.getFullPath();
            File f = new File(this.xsd.getFileName());
            targetPath.append(f.getName());
        }
        DropXMLDocumentHandler handler = new DropXMLDocumentHandler();
        Collection newFiles = handler.copyXSDsToProject((IStructuredSelection)new StructuredSelection((Object)this.xsd), this.project);
        for (IFile file : newFiles) {
            this.openEditor(file);
        }
        return ret;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected boolean projectExists(String projName) {
        if (projName != null && projName.trim().length() > 0) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            return proj != null && proj.exists();
        }
        return false;
    }

    public void openEditor(IFile xsdFile) {
        IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)wbPage, (IFile)xsdFile, (boolean)true);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    protected boolean focusExplorer(String explorerID) {
        IViewPart explorer;
        if (EclipseUtilities.getActivePage() != null && (explorer = this.getSite().getPage().findView(explorerID)) != null) {
            EclipseUtilities.getActivePage().activate((IWorkbenchPart)explorer);
            ((ProjectExplorer)explorer).getCommonViewer().getTree().setFocus();
            return true;
        }
        return false;
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    protected static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            if (!(target instanceof ProjectExplorer)) continue;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                @Override
                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }

    public void expandProject(IProject proj, IWorkbenchWindow window) {
        if (window == null || proj == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IViewReference[] refs = page.getViewReferences();
        int refIdx = 0;
        while (refIdx < refs.length) {
            IWorkbenchPart part = refs[refIdx].getPart(false);
            if (part != null && part instanceof ProjectExplorer) {
                ProjectExplorer prjExplorer = (ProjectExplorer)part;
                Tree tree = prjExplorer.getCommonViewer().getTree();
                TreeItem[] treeItems = tree.getItems();
                int i = 0;
                while (i < treeItems.length) {
                    IDatabaseDevelopmentProject ddProject;
                    TreeItem item = treeItems[i];
                    Object itemData = item.getData();
                    if (itemData instanceof IDatabaseDevelopmentProject && (ddProject = (IDatabaseDevelopmentProject)itemData).getProject().equals((Object)proj)) {
                        prjExplorer.getCommonViewer().expandToLevel((Object)ddProject, 1);
                        break;
                    }
                    ++i;
                }
            }
            ++refIdx;
        }
    }
}

