/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.xml.schema.ui.actions;

import com.ibm.datatools.common.util.ConnectionProfileUtility;
import com.ibm.datatools.db2.ui.node.IXMLSchemasFolderNode;
import com.ibm.datatools.internal.core.util.ModelHelper;
import com.ibm.datatools.project.dev.node.IVirtual;
import com.ibm.datatools.project.dev.node.IXSDFolder;
import com.ibm.datatools.project.dev.util.DatabaseResolver;
import com.ibm.datatools.project.dev.util.ProjectHelper;
import com.ibm.datatools.sqlxeditor.util.SQLXDBUtils;
import com.ibm.datatools.xml.schema.ui.XMLSchemaUIPlugin;
import com.ibm.datatools.xml.schema.ui.nls.XMLSchemaUIMessages;
import com.ibm.datatools.xml.schema.ui.projectexplorer.XMLSchemaDocumentFolder;
import com.ibm.datatools.xml.schema.ui.projectexplorer.XMLSchemaDocumentNode;
import com.ibm.datatools.xml.schema.ui.wizard.register.RegisterXMLSchemaWizard;
import com.ibm.db.models.db2.zSeries.ZSeriesDatabase;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class NewXSDRegistrationAction
extends SelectionListenerAction
implements IViewActionDelegate {
    protected IWorkbenchWindow window;
    protected IStructuredSelection selection;
    private boolean isGenerate;

    public NewXSDRegistrationAction(String text, boolean isGenerate) {
        super("RegisterNewXMLSchema");
        if (text != null) {
            this.setText(text);
        }
        this.isGenerate = isGenerate;
    }

    public void init(IViewPart view) {
        this.window = view.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                boolean projectExplorer = false;
                boolean fromProjectFolder = false;
                IProject project = null;
                Object selectedObj = NewXSDRegistrationAction.this.selection.getFirstElement();
                Schema schema = null;
                ConnectionInfo conInfo = null;
                ArrayList<Object> list = new ArrayList<Object>();
                if (selectedObj instanceof IXMLSchemasFolderNode) {
                    Object parent = ((IXMLSchemasFolderNode)selectedObj).getParent();
                    if (parent instanceof Schema) {
                        schema = (Schema)parent;
                        conInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(ModelHelper.getDatabase((Schema)schema));
                    } else if (parent instanceof ZSeriesDatabase && parent instanceof ICatalogObject) {
                        conInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)((ZSeriesDatabase)parent));
                    }
                } else if (selectedObj instanceof XMLSchemaDocumentNode) {
                    projectExplorer = true;
                    conInfo = DatabaseResolver.determineConnectionInfo((IStructuredSelection)NewXSDRegistrationAction.this.selection);
                    project = ProjectHelper.getProject((SQLObject)((SQLObject)((XMLSchemaDocumentNode)((Object)selectedObj)).getModelObject()));
                    for (Object nextSelected : NewXSDRegistrationAction.this.selection) {
                        if (!(nextSelected instanceof XMLSchemaDocumentNode)) continue;
                        list.add(((XMLSchemaDocumentNode)((Object)nextSelected)).getModelObject());
                    }
                } else if (selectedObj instanceof XMLSchemaDocumentFolder) {
                    projectExplorer = true;
                    fromProjectFolder = true;
                    conInfo = DatabaseResolver.determineConnectionInfo((IStructuredSelection)NewXSDRegistrationAction.this.selection);
                    project = ProjectHelper.getProject((IVirtual)((XMLSchemaDocumentFolder)((Object)selectedObj)));
                    for (XMLSchemaDocumentNode xsdNode : ((XMLSchemaDocumentFolder)((Object)selectedObj)).getChildren()) {
                        list.add(xsdNode.getModelObject());
                    }
                } else if (selectedObj instanceof IFile) {
                    projectExplorer = true;
                    project = ((IFile)selectedObj).getProject();
                    conInfo = ProjectHelper.getConnectionInfo((IProject)project);
                    for (Object nextSelected : NewXSDRegistrationAction.this.selection) {
                        if (!(nextSelected instanceof IFile)) continue;
                        list.add(XMLSchemaDocumentNode.getXSDFromFile(((IFile)nextSelected).getLocation().toString()));
                    }
                } else if (selectedObj instanceof IXSDFolder) {
                    projectExplorer = true;
                    fromProjectFolder = true;
                    IXSDFolder xsdFolder = (IXSDFolder)selectedObj;
                    project = ProjectHelper.getProject((IVirtual)((IVirtual)xsdFolder.getParent()));
                    conInfo = ProjectHelper.getConnectionInfo((IProject)project);
                    for (IFile xsdFile : xsdFolder.getChildren()) {
                        list.add(XMLSchemaDocumentNode.getXSDFromFile(xsdFile.getLocation().toString()));
                    }
                }
                boolean online = true;
                online = SQLXDBUtils.reestablishConnection((ConnectionInfo)conInfo);
                if (online) {
                    String driverClassName = ConnectionProfileUtility.getDriverClass((IConnectionProfile)conInfo.getConnectionProfile());
                    if (driverClassName.equals("com.ibm.db2.jcc.DB2Driver")) {
                        RegisterXMLSchemaWizard registerXMLSchemaWizard = new RegisterXMLSchemaWizard(schema, projectExplorer, list, conInfo, project, fromProjectFolder, NewXSDRegistrationAction.this.isGenerate);
                        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getWorkbenchWindow().getShell(), (IWizard)registerXMLSchemaWizard);
                        dialog.setMinimumPageSize(300, 275);
                        dialog.create();
                        if (NewXSDRegistrationAction.this.isGenerate) {
                            dialog.getShell().setText(XMLSchemaUIMessages.GENERATE_REGISTER_SCRIPT_WIZARD_TITLE);
                        } else {
                            dialog.getShell().setText(XMLSchemaUIMessages.REGISTER_WIZARD_TITLE);
                        }
                        dialog.open();
                    } else {
                        MessageDialog.openError((Shell)XMLSchemaUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)XMLSchemaUIMessages.REGISTER_WIZARD_ERROR_TITLE, (String)XMLSchemaUIMessages.REGISTER_DRIVER_ERROR);
                    }
                } else {
                    MessageDialog.openError((Shell)XMLSchemaUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)XMLSchemaUIMessages.REGISTER_WIZARD_ERROR_TITLE, (String)XMLSchemaUIMessages.REGISTER_OFFLINE_ERROR);
                }
            }
        });
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)iSelection;
        }
    }
}

