/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.datatools.xml.schema.ui.actions;

import com.ibm.datatools.common.util.ConnectionProfileUtility;
import com.ibm.datatools.common.util.DB2Version;
import com.ibm.datatools.internal.core.util.ModelHelper;
import com.ibm.datatools.sqlxeditor.util.SQLXDBUtils;
import com.ibm.datatools.xml.schema.ui.XMLSchemaUIPlugin;
import com.ibm.datatools.xml.schema.ui.nls.XMLSchemaUIMessages;
import com.ibm.datatools.xml.schema.util.XMLSchemaUtility;
import com.ibm.datatools.xml.schema.util.XMLUtility;
import com.ibm.db.models.db2.DB2XMLSchema;
import com.ibm.db.models.db2.DB2XMLSchemaDecomposition;
import com.ibm.db.models.db2.DB2XMLSchemaDocument;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DropXSDDocumentAction
extends SelectionListenerAction {
    protected IWorkbenchWindow window;
    protected DB2XMLSchema xmlSchema;
    protected DB2XMLSchemaDocument droppedXSD;
    protected String droppedXSDComponentID;
    protected Set dependentXSDs;
    protected Set remainingXSDs;
    protected Schema schema;
    protected ConnectionInfo conInfo;
    protected Connection con;
    protected Document objectInfoDoc;
    protected String outItemName;
    protected OperationCommand cmd;

    public DropXSDDocumentAction() {
        super(XMLSchemaUIMessages.DROP_SCHEMA_MESSAGE_DIALOG_TITLE);
    }

    public void run() {
        try {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!DropXSDDocumentAction.this.init()) {
                        return;
                    }
                    if (!DropXSDDocumentAction.this.validateConnection()) {
                        return;
                    }
                    if (!DropXSDDocumentAction.this.retrieveXSRObjectInfoDocument()) {
                        return;
                    }
                    if (!DropXSDDocumentAction.this.getDependentDocuments()) {
                        return;
                    }
                    if (DropXSDDocumentAction.this.dropAndReregister()) {
                        DropXSDDocumentAction.this.refreshServerExplorer();
                    }
                }
            });
        }
        finally {
            this.con = null;
            this.conInfo = null;
            this.dependentXSDs = null;
            this.droppedXSD = null;
            this.droppedXSDComponentID = null;
            this.objectInfoDoc = null;
            this.cmd = null;
            this.outItemName = null;
            this.remainingXSDs = null;
            this.schema = null;
            this.xmlSchema = null;
        }
    }

    private boolean init() {
        try {
            IStructuredSelection selection = this.getStructuredSelection();
            Object selectedObj = selection.getFirstElement();
            this.droppedXSD = (DB2XMLSchemaDocument)selectedObj;
            this.xmlSchema = this.droppedXSD.getXmlSchema();
            this.schema = this.xmlSchema.getSchema();
            this.conInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(ModelHelper.getDatabase((Schema)this.schema));
            this.con = this.conInfo.getSharedConnection();
            this.outItemName = this.droppedXSD.getName();
            if (this.con == null) {
                throw new NullPointerException();
            }
            ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
            String uniqueid = XMLSchemaUtility.getXMLSchemaDocumentUniqueID((DB2XMLSchemaDocument)this.droppedXSD);
            String strDrop = XMLSchemaUIMessages.DROP_SCHEMA_MESSAGE_DIALOG_TITLE;
            StringBuffer displayStrBuffer = new StringBuffer(uniqueid.length() + 3 + strDrop.length());
            displayStrBuffer.append(strDrop).append(' ').append('-').append(' ').append(uniqueid);
            this.cmd = new OperationCommand(5, displayStrBuffer.toString(), uniqueid, this.conInfo.getName(), this.conInfo.getDatabaseName());
            resultsView.createNewInstance(this.cmd, null);
        }
        catch (Exception e) {
            XMLSchemaUIPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
            if (this.outItemName == null) {
                this.outItemName = "";
            }
            if (this.cmd != null) {
                ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_EXCEPTION_ERROR, (Object[])new Object[]{this.outItemName}));
                if (e.getMessage() != null && e.getMessage().length() > 0) {
                    resultsView.appendThrowable(this.cmd, (Throwable)e);
                    resultsView.appendStatusMessage(this.cmd, e.getLocalizedMessage());
                }
                resultsView.updateStatus(this.cmd, 6);
            } else {
                String message = e.getMessage() != null ? e.getMessage() : "";
                this.displayErrorMessageBox(NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_GENERIC_MESSAGEBOX_ERROR, (Object[])new Object[]{this.outItemName, message}));
            }
            return false;
        }
        if (this.droppedXSD.isPrimary()) {
            ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_DROP_PRIMARY_DOC_ERROR, (Object[])new Object[]{this.outItemName}));
            resultsView.updateStatus(this.cmd, 6);
            return false;
        }
        return true;
    }

    private boolean validateConnection() {
        if (this.conInfo == null) {
            return false;
        }
        boolean online = true;
        online = SQLXDBUtils.reestablishConnection((ConnectionInfo)this.conInfo);
        ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
        if (!online) {
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_OFFLINE_ERROR, (Object[])new Object[]{this.outItemName}));
            resultsView.updateStatus(this.cmd, 6);
            this.displayErrorMessageBox(XMLSchemaUIMessages.REGISTER_OFFLINE_ERROR);
            return false;
        }
        String driverClassName = ConnectionProfileUtility.getDriverClass((IConnectionProfile)this.conInfo.getConnectionProfile());
        if (!driverClassName.equals("com.ibm.db2.jcc.DB2Driver")) {
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_DRIVER_ERROR, (Object[])new Object[]{this.outItemName}));
            resultsView.updateStatus(this.cmd, 6);
            this.displayErrorMessageBox(XMLSchemaUIMessages.REGISTER_DRIVER_ERROR);
            return false;
        }
        return true;
    }

    private boolean retrieveXSRObjectInfoDocument() {
        this.objectInfoDoc = null;
        ConnectionFilter xmlSchemaDocFilter = this.conInfo.getFilter(String.valueOf(this.xmlSchema.getName()) + "::" + "DatatoolsXMLSchemaDocsFilterPredicate");
        if (xmlSchemaDocFilter == null) {
            xmlSchemaDocFilter = this.conInfo.getFilter("DatatoolsXMLSchemaDocsFilterPredicate");
        }
        String filterStr = "";
        if (xmlSchemaDocFilter != null) {
            filterStr = String.valueOf(filterStr) + "SCHEMALOCATION " + xmlSchemaDocFilter.getPredicate();
            filterStr = " AND (" + filterStr;
            filterStr = String.valueOf(filterStr) + ") ";
        }
        String query = "SELECT XSR.OBJECTINFO, XSR.OBJECTID  FROM SYSCAT.XSROBJECTS XSR WHERE XSR.OBJECTNAME='" + this.xmlSchema.getName() + "' AND" + " XSR.OBJECTSCHEMA='" + this.schema.getName() + "'";
        if (xmlSchemaDocFilter != null) {
            query = String.valueOf(query) + filterStr;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Statement statement2 = null;
        ResultSet resultSet2 = null;
        String xmlSchemaID = null;
        ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
        try {
            statement = this.con.createStatement();
            resultSet = statement.executeQuery(query);
            if (resultSet.next()) {
                String objectInfoString = resultSet.getString("OBJECTINFO");
                xmlSchemaID = resultSet.getString("OBJECTID");
                StringReader reader = new StringReader(objectInfoString);
                InputSource myXMLSource = new InputSource(reader);
                this.objectInfoDoc = XMLUtility.parseXMLDocument((InputSource)myXMLSource);
            }
            String tnsPart = null;
            String slPart = null;
            tnsPart = this.droppedXSD.getTargetNamespace() == null ? " COMP.TARGETNAMESPACE IS NULL " : " COMP.TARGETNAMESPACE='" + this.droppedXSD.getTargetNamespace() + "' ";
            slPart = this.droppedXSD.getSchemaLocation() == null ? " COMP.SCHEMALOCATION IS NULL " : " COMP.SCHEMALOCATION='" + this.droppedXSD.getSchemaLocation() + "' ";
            String query2 = "SELECT COMP.COMPONENTID FROM SYSCAT.XSROBJECTCOMPONENTS COMP WHERE COMP.OBJECTID=" + xmlSchemaID + " AND " + tnsPart + " AND " + slPart;
            statement2 = this.con.createStatement();
            resultSet2 = statement2.executeQuery(query2);
            if (resultSet2.next()) {
                this.droppedXSDComponentID = resultSet2.getString("COMPONENTID");
            }
        }
        catch (SQLException se) {
            XMLSchemaUIPlugin.getDefault().writeLog(4, 0, se.getMessage(), se);
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_EXCEPTION_ERROR, (Object[])new Object[]{this.outItemName}));
            if (se.getMessage() != null && se.getMessage().length() > 0) {
                resultsView.appendThrowable(this.cmd, (Throwable)se);
            }
            resultsView.appendStatusMessage(this.cmd, se.getLocalizedMessage());
            resultsView.updateStatus(this.cmd, 6);
            try {
                resultSet.close();
                resultSet2.close();
                statement.close();
                statement2.close();
            }
            catch (Exception e) {
                XMLSchemaUIPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_EXCEPTION_ERROR, (Object[])new Object[]{this.outItemName}));
                if (e.getMessage() != null && e.getMessage().length() > 0) {
                    resultsView.appendThrowable(this.cmd, (Throwable)e);
                }
                resultsView.appendStatusMessage(this.cmd, e.getLocalizedMessage());
                resultsView.updateStatus(this.cmd, 6);
                return false;
            }
            if (this.objectInfoDoc == null || this.droppedXSDComponentID == null) {
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_NO_METADATA_ERROR, (Object[])new Object[]{this.outItemName}));
                resultsView.updateStatus(this.cmd, 6);
                return false;
            }
            return false;
        }
        catch (Exception e) {
            try {
                XMLSchemaUIPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_NO_METADATA_ERROR, (Object[])new Object[]{this.outItemName}));
                if (e.getMessage() != null && e.getMessage().length() > 0) {
                    resultsView.appendThrowable(this.cmd, (Throwable)e);
                }
                resultsView.appendStatusMessage(this.cmd, e.getLocalizedMessage());
                resultsView.updateStatus(this.cmd, 6);
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    resultSet2.close();
                    statement.close();
                    statement2.close();
                }
                catch (Exception e2) {
                    XMLSchemaUIPlugin.getDefault().writeLog(4, 0, e2.getMessage(), e2);
                    resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_EXCEPTION_ERROR, (Object[])new Object[]{this.outItemName}));
                    if (e2.getMessage() != null && e2.getMessage().length() > 0) {
                        resultsView.appendThrowable(this.cmd, (Throwable)e2);
                    }
                    resultsView.appendStatusMessage(this.cmd, e2.getLocalizedMessage());
                    resultsView.updateStatus(this.cmd, 6);
                    return false;
                }
                if (this.objectInfoDoc == null || this.droppedXSDComponentID == null) {
                    resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_NO_METADATA_ERROR, (Object[])new Object[]{this.outItemName}));
                    resultsView.updateStatus(this.cmd, 6);
                    return false;
                }
                throw throwable;
            }
            try {
                resultSet.close();
                resultSet2.close();
                statement.close();
                statement2.close();
            }
            catch (Exception e3) {
                XMLSchemaUIPlugin.getDefault().writeLog(4, 0, e3.getMessage(), e3);
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_EXCEPTION_ERROR, (Object[])new Object[]{this.outItemName}));
                if (e3.getMessage() != null && e3.getMessage().length() > 0) {
                    resultsView.appendThrowable(this.cmd, (Throwable)e3);
                }
                resultsView.appendStatusMessage(this.cmd, e3.getLocalizedMessage());
                resultsView.updateStatus(this.cmd, 6);
                return false;
            }
            if (this.objectInfoDoc == null || this.droppedXSDComponentID == null) {
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_NO_METADATA_ERROR, (Object[])new Object[]{this.outItemName}));
                resultsView.updateStatus(this.cmd, 6);
                return false;
            }
            return false;
        }
        try {
            resultSet.close();
            resultSet2.close();
            statement.close();
            statement2.close();
        }
        catch (Exception e) {
            XMLSchemaUIPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_EXCEPTION_ERROR, (Object[])new Object[]{this.outItemName}));
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                resultsView.appendThrowable(this.cmd, (Throwable)e);
            }
            resultsView.appendStatusMessage(this.cmd, e.getLocalizedMessage());
            resultsView.updateStatus(this.cmd, 6);
            return false;
        }
        if (this.objectInfoDoc == null || this.droppedXSDComponentID == null) {
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_NO_METADATA_ERROR, (Object[])new Object[]{this.outItemName}));
            resultsView.updateStatus(this.cmd, 6);
            return false;
        }
        return true;
    }

    private boolean getDependentDocuments() {
        String droppedXSDdocID = this.droppedXSDComponentID;
        String dependentXSDsXPath = "//schemaDocInfo/import[@docID='" + droppedXSDdocID + "']/.. | //schemaDocInfo/include[@docID='" + droppedXSDdocID + "']/.. | //schemaDocInfo/redefine[@docID='" + droppedXSDdocID + "']/..";
        NodeList dependentXSDNodeList = XMLUtility.findNodesForXPathExpression((Node)this.objectInfoDoc, (String)dependentXSDsXPath, (Document)this.objectInfoDoc);
        if (dependentXSDNodeList.getLength() != 0) {
            String[] targetNames = new String[dependentXSDNodeList.getLength()];
            String[] schemaLocations = new String[dependentXSDNodeList.getLength()];
            int i = 0;
            while (i < dependentXSDNodeList.getLength()) {
                Node schemaDocInfo = dependentXSDNodeList.item(i);
                NodeList children = schemaDocInfo.getChildNodes();
                int j = 0;
                while (j < children.getLength()) {
                    Node child = children.item(j);
                    if (child.getNodeName().equals("targetNamespace") && child.getFirstChild() != null && child.getFirstChild().getNodeType() == 3) {
                        targetNames[i] = child.getFirstChild().getNodeValue();
                    }
                    if (child.getNodeName().equals("schemaLocation") && child.getFirstChild() != null && child.getFirstChild().getNodeType() == 3) {
                        schemaLocations[i] = child.getFirstChild().getNodeValue();
                    }
                    ++j;
                }
                ++i;
            }
            EList xmlSchemaDocs = this.xmlSchema.getXmlSchemaDocs();
            for (DB2XMLSchemaDocument doc : xmlSchemaDocs) {
                String targetNameSpace = doc.getTargetNamespace();
                String schemaLocation = doc.getSchemaLocation();
                boolean nameSpaceIdentical = false;
                boolean locationIdentical = false;
                int i2 = 0;
                while (i2 < targetNames.length) {
                    if (targetNameSpace == null && targetNames[i2] == null || targetNameSpace != null && targetNameSpace.equals(targetNames[i2])) {
                        nameSpaceIdentical = true;
                    }
                    if (schemaLocation == null && schemaLocations[i2] == null || schemaLocation != null && schemaLocation.equals(schemaLocations[i2])) {
                        locationIdentical = true;
                    }
                    ++i2;
                }
                if (!locationIdentical || !nameSpaceIdentical) continue;
                if (this.dependentXSDs == null) {
                    this.dependentXSDs = new HashSet(dependentXSDNodeList.getLength());
                }
                this.dependentXSDs.add(doc);
            }
            ResultsViewAPI resultsView = ResultsViewAPI.getInstance();
            if (this.dependentXSDs != null && this.dependentXSDs.size() > 0) {
                StringBuffer depDocs = new StringBuffer();
                Iterator depXSDIt = this.dependentXSDs.iterator();
                while (depXSDIt.hasNext()) {
                    DB2XMLSchemaDocument doc = (DB2XMLSchemaDocument)depXSDIt.next();
                    depDocs.append(doc.getName());
                    if (!depXSDIt.hasNext()) continue;
                    depDocs.append(", ");
                }
                depDocs.append(".");
                String arg1 = depDocs.toString();
                String message = NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_DEPENDENT_XSDS, (Object[])new Object[]{this.outItemName, arg1});
                resultsView.appendStatusMessage(this.cmd, message);
                resultsView.updateStatus(this.cmd, 6);
            } else {
                resultsView.appendStatusMessage(this.cmd, XMLSchemaUIMessages.DROP_XSD_DEPENDENT_XSDS);
                resultsView.updateStatus(this.cmd, 6);
            }
            return false;
        }
        boolean deletedTheDropped = false;
        for (DB2XMLSchemaDocument doc : this.xmlSchema.getXmlSchemaDocs()) {
            if (!this.droppedXSD.equals(doc)) {
                if (this.remainingXSDs == null) {
                    this.remainingXSDs = new HashSet();
                }
                this.remainingXSDs.add(doc);
                continue;
            }
            deletedTheDropped = true;
        }
        return deletedTheDropped;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean dropAndReregister() {
        String comment;
        ResultsViewAPI resultsView;
        boolean autoCommitBefore;
        boolean savedAutoCommit;
        block30: {
            boolean reregister = true;
            if (this.remainingXSDs == null || this.remainingXSDs.size() == 0) {
                boolean dropIt = MessageDialog.openConfirm((Shell)this.window.getShell(), (String)XMLSchemaUIMessages.DROP_SCHEMA_MESSAGE_DIALOG_TITLE, (String)NLS.bind((String)XMLSchemaUIMessages.DROP_SCHEMA_MESSAGE_DIALOG, (Object[])new Object[]{this.outItemName, this.xmlSchema.getName()}));
                if (!dropIt) {
                    ResultsViewAPI resultsView2 = ResultsViewAPI.getInstance();
                    resultsView2.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_SCHEMA_CANCELLED_BY_USER, (Object[])new Object[]{this.outItemName}));
                    resultsView2.updateStatus(this.cmd, 6);
                    return false;
                }
                reregister = false;
            }
            savedAutoCommit = false;
            autoCommitBefore = false;
            resultsView = ResultsViewAPI.getInstance();
            autoCommitBefore = this.con.getAutoCommit();
            savedAutoCommit = true;
            this.con.setAutoCommit(false);
            comment = this.xmlSchema.getDescription();
            try {
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_STARTED, (Object[])new Object[]{this.outItemName}));
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_SCHEMADROP_STARTED, (Object[])new Object[]{this.outItemName, this.xmlSchema.getName()}));
                XMLSchemaUtility.deregisterXMLSchema((Schema)this.schema, (ConnectionInfo)this.conInfo, (DB2XMLSchema)this.xmlSchema, (boolean)false, (boolean)true);
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_SCHEMADROP_SUCCESS, (Object[])new Object[]{this.outItemName, this.xmlSchema.getName()}));
            }
            catch (Exception e) {
                resultsView.updateStatus(this.cmd, 6);
                resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_SCHEMADROP_FAILED, (Object[])new Object[]{this.outItemName, this.xmlSchema.getName()}));
                throw e;
            }
            if (reregister) break block30;
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_SUCCESS, (Object[])new Object[]{this.outItemName}));
            resultsView.updateStatus(this.cmd, 3);
            if (!savedAutoCommit) return true;
            try {
                this.con.setAutoCommit(autoCommitBefore);
                return true;
            }
            catch (SQLException sQLException) {}
            return true;
        }
        DB2XMLSchemaDocument primary = null;
        for (DB2XMLSchemaDocument doc : this.remainingXSDs) {
            if (!doc.isPrimary()) continue;
            primary = doc;
            break;
        }
        DB2XMLSchemaDecomposition decomp = this.xmlSchema.getDecomposition();
        boolean isDecomp = true;
        if (decomp != null && decomp.getValue() == 1) {
            isDecomp = false;
        }
        try {
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_SCHEMAREREGISTER_STARTED, (Object[])new Object[]{this.outItemName, this.xmlSchema.getName()}));
            XMLSchemaUtility.registerXMLSchema((ConnectionInfo)this.conInfo, new ArrayList(this.remainingXSDs), (DB2XMLSchemaDocument)primary, (Schema)this.schema, (String)this.xmlSchema.getName(), (String)comment, (boolean)isDecomp);
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_SCHEMAREREGISTER_SUCCESS, (Object[])new Object[]{this.outItemName, this.xmlSchema.getName()}));
        }
        catch (Exception e) {
            resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_SCHEMAREREGISTER_FAILED, (Object[])new Object[]{this.outItemName, this.xmlSchema.getName()}));
            resultsView.appendThrowable(this.cmd, (Throwable)e);
            resultsView.updateStatus(this.cmd, 6);
            throw e;
        }
        this.con.commit();
        resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_SUCCESS, (Object[])new Object[]{this.outItemName}));
        resultsView.updateStatus(this.cmd, 3);
        if (!savedAutoCommit) return true;
        try {
            this.con.setAutoCommit(autoCommitBefore);
            return true;
        }
        catch (SQLException sQLException) {}
        return true;
        catch (ClassNotFoundException e) {
            try {
                try {
                    resultsView.appendThrowable(this.cmd, (Throwable)e);
                    resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_DRIVER_OV_ERROR, (Object[])new Object[]{this.outItemName}));
                    throw e;
                    catch (NoSuchMethodException e2) {
                        resultsView.appendThrowable(this.cmd, (Throwable)e2);
                        resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_DRIVER_OV_ERROR, (Object[])new Object[]{this.outItemName}));
                        throw e2;
                    }
                    catch (IllegalAccessException e3) {
                        resultsView.appendThrowable(this.cmd, (Throwable)e3);
                        resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_DRIVER_OV_ERROR, (Object[])new Object[]{this.outItemName}));
                        throw e3;
                    }
                    catch (ClassCastException e4) {
                        resultsView.appendThrowable(this.cmd, (Throwable)e4);
                        resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.REGISTER_DRIVER_OV_ERROR, (Object[])new Object[]{this.outItemName}));
                        throw e4;
                    }
                }
                catch (Exception exception) {
                    XMLSchemaUIPlugin.getDefault().writeLog(4, 0, exception.getMessage(), exception);
                    resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.DROP_XSD_EXCEPTION_ERROR, (Object[])new Object[]{this.outItemName}));
                    if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                        resultsView.appendThrowable(this.cmd, (Throwable)exception);
                        resultsView.appendStatusMessage(this.cmd, exception.getLocalizedMessage());
                    }
                    resultsView.updateStatus(this.cmd, 6);
                    try {
                        this.con.rollback();
                        resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.ROLLBACK_SUCCESS, (Object[])new Object[]{this.outItemName}));
                    }
                    catch (Exception e5) {
                        XMLSchemaUIPlugin.getDefault().writeLog(4, 0, e5.getMessage(), e5);
                        if (e5.getMessage() != null && e5.getMessage().length() > 0) {
                            resultsView.appendThrowable(this.cmd, (Throwable)e5);
                            resultsView.appendStatusMessage(this.cmd, e5.getLocalizedMessage());
                        }
                        resultsView.appendStatusMessage(this.cmd, NLS.bind((String)XMLSchemaUIMessages.ROLLBACK_FAILURE, (Object[])new Object[]{this.outItemName}));
                    }
                    if (!savedAutoCommit) return true;
                    try {
                        this.con.setAutoCommit(autoCommitBefore);
                        return true;
                    }
                    catch (SQLException sQLException) {}
                    return true;
                }
            }
            catch (Throwable throwable) {
                if (!savedAutoCommit) throw throwable;
                try {
                    this.con.setAutoCommit(autoCommitBefore);
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
        }
    }

    private void displayErrorMessageBox(String message) {
        MessageDialog.openError((Shell)this.window.getShell(), (String)XMLSchemaUIMessages.DROP_XSD_ERROR_TITLE, (String)message);
    }

    private void refreshServerExplorer() {
        DB2Version db2Version = DB2Version.getSharedInstance((ConnectionInfo)this.conInfo);
        if (db2Version.isDB390()) {
            if (this.conInfo.getSharedDatabase() != null) {
                IServicesManager.INSTANCE.getServerExplorerRefreshService().refresh((Object)this.conInfo.getSharedDatabase());
            }
        } else if (this.schema != null) {
            IServicesManager.INSTANCE.getServerExplorerRefreshService().refresh((Object)this.schema);
        }
    }
}

