/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.profiling.extension.object.analysis.agent;

class Util {
    Util() {
    }

    private static boolean isEnabled(String envVar) {
        String trace = System.getenv(envVar);
        return trace != null && !trace.equalsIgnoreCase("false") && !trace.equals("0");
    }

    public static boolean isTrace() {
        return Util.isEnabled("HEAP_OBJ_DATA_TRACE");
    }

    public static boolean isDebug() {
        return Util.isEnabled("HEAP_OBJ_DATA_DEBUG");
    }

    public static boolean isInfo() {
        return Util.isEnabled("HEAP_OBJ_DATA_INFO");
    }

    public static long startTimer() {
        return System.currentTimeMillis();
    }

    public static double elapsed(long since) {
        return (double)(System.currentTimeMillis() - since) / 1000.0;
    }

    public static String humanSize(long size) {
        long kb = 1024L;
        long mb = 1024L * kb;
        long gb = 1024L * mb;
        long tb = 1024L * gb;
        long pb = 1024L * tb;
        if (size > pb) {
            double pbs = (double)size / (double)pb;
            return String.valueOf(pbs) + " PB";
        }
        if (size > tb) {
            double tbs = (double)size / (double)tb;
            return String.valueOf(tbs) + " TB";
        }
        if (size > gb) {
            double gbs = (double)size / (double)gb;
            return String.valueOf(gbs) + " GB";
        }
        if (size > mb) {
            double mbs = (double)size / (double)mb;
            return String.valueOf(mbs) + " MB";
        }
        if (size > kb) {
            double kbs = (double)size / (double)kb;
            return String.valueOf(kbs) + " KB";
        }
        return String.valueOf(size) + " B";
    }
}

