/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.profiling.extension.object.analysis.agent;

import com.ibm.rational.profiling.extension.object.analysis.agent.Util;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ObjectAnalysisAgent {
    public static final String TPTP_JVMTI_IID = "org.eclipse.tptp.jvmti";
    public static final String GET_REACHABLE_SIZE_CMD = "GetReachableSize";
    private static final String ACCOLLECTOR_AGENTLET_PREFIX = "org.eclipse.tptp.javaprofiler.agentlet";
    private static final String HEAP_OBJ_DATA_CLS = "org.eclipse.tptp.martini.analysis.HeapObjectData";
    private static final boolean TRACE = Util.isTrace();
    private static final boolean DEBUG = Util.isDebug();
    private static final boolean INFO = Util.isInfo();
    private static Instrumentation instrument = null;
    private static Class<?> heapObjectData_cls;
    private static Method getObjectFromTid_method;
    private static Map<Long, Long> cache;
    private static long cacheHits;
    private static long cacheMisses;
    private static long totalSkipped;
    private static long totalProcessed;

    static {
        try {
            heapObjectData_cls = Class.forName(HEAP_OBJ_DATA_CLS);
            getObjectFromTid_method = heapObjectData_cls.getMethod("getObjectByTId", Long.TYPE);
        }
        catch (Exception e) {
            System.err.println("[ObjectAnalysisAgent] Failed to locate class: org.eclipse.tptp.martini.analysis.HeapObjectData");
            System.err.println("[ObjectAnalysisAgent] \"Reachable size\" queries will be unavailable.");
        }
        cache = new HashMap<Long, Long>();
        cacheHits = 0L;
        cacheMisses = 0L;
        totalSkipped = 0L;
        totalProcessed = 0L;
    }

    public static void premain(String agent, Instrumentation instrumentation) {
        System.setProperty("org.eclipse.tptp.javaprofiler.agentlet:org.eclipse.tptp.jvmti#GetReachableSize", ObjectAnalysisAgent.class.getCanonicalName());
        instrument = instrumentation;
        if (TRACE) {
            System.err.println("[ObjectAnalysisAgent] Published agentlet: org.eclipse.tptp.jvmti#GetReachableSize");
        }
    }

    private static Object lookupTid(Long tid) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return getObjectFromTid_method.invoke(heapObjectData_cls, tid);
    }

    public static String agentletHandleCommand(String iid, String cmd, Map<String, String> params) {
        if (!TPTP_JVMTI_IID.equals(iid) || !GET_REACHABLE_SIZE_CMD.equals(cmd)) {
            if (DEBUG) {
                System.err.println("ObjectAnalysisAgent: unknown iid/cmd pair: " + iid + "#" + cmd);
            }
            return null;
        }
        long requestTime = Util.startTimer();
        String[] tids = params.get("TId").split(",");
        if (INFO) {
            System.err.print("[" + Util.elapsed(requestTime) + "s] Requested " + tids.length + " objects" + (DEBUG ? "\n" : " ."));
        }
        try {
            StringBuilder result = new StringBuilder();
            int count = 0;
            result.append("<DeepObjectSize>");
            String[] stringArray = tids;
            int n = tids.length;
            int n2 = 0;
            while (n2 < n) {
                String tidStr = stringArray[n2];
                Long tid = Long.valueOf(tidStr);
                long objectTime = Util.startTimer();
                Object target = ObjectAnalysisAgent.lookupTid(tid);
                if (target == null) {
                    result.append("<object tid=\"");
                    result.append(tid);
                    result.append("\" size=\"0\"/>");
                } else {
                    if (DEBUG) {
                        System.err.print("[" + Util.elapsed(requestTime) + "s ] TId=" + tid + " ");
                    } else if (INFO) {
                        System.err.print(".");
                    }
                    long size = ObjectAnalysisAgent.reachableSize(target, cache);
                    if (DEBUG) {
                        System.err.println(" " + Util.humanSize(size) + " (elapsed: " + Util.elapsed(objectTime) + "s)");
                    }
                    result.append("<object tid=\"");
                    result.append(tid);
                    result.append("\" size=\"");
                    result.append(size);
                    result.append("\"/>");
                    ++count;
                }
                ++n2;
            }
            result.append("</DeepObjectSize>");
            if (DEBUG) {
                System.err.println("[" + Util.elapsed(requestTime) + "s] Processed " + count + " objects (skipped " + (tids.length - count) + ")");
            } else if (INFO) {
                System.err.println(" done. Skipped " + (tids.length - count) + " (elapsed: " + Util.elapsed(requestTime) + "s)");
            }
            if (params.containsKey("endRequest")) {
                if (INFO) {
                    double hitRate = (double)cacheHits / (double)(cacheHits + cacheMisses);
                    System.err.println("[" + Util.elapsed(requestTime) + "s] Purging " + cache.size() + " cached entries (hits: " + cacheHits + " misses: " + cacheMisses + " hitrate: " + hitRate + "). Processed " + totalProcessed + " objects and skipped " + totalSkipped + ".");
                }
                cache.clear();
                cacheHits = 0L;
                cacheMisses = 0L;
                totalProcessed = 0L;
                totalSkipped = 0L;
            } else {
                totalProcessed += (long)count;
                totalSkipped += (long)(tids.length - count);
            }
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "-1";
        }
    }

    private static void queueElements(List<Object> queue, Set<Integer> visited, Object ary, Class<?> objCls) {
        if (!objCls.getComponentType().isPrimitive()) {
            int aryLength = Array.getLength(ary);
            int i = 0;
            while (i < aryLength) {
                Object elem = Array.get(ary, i);
                if (elem != null && visited.add(System.identityHashCode(elem))) {
                    queue.add(elem);
                }
                ++i;
            }
        }
    }

    private static void queueChildren(List<Object> queue, Set<Integer> visited, Object obj, Class<?> objCls) throws IllegalArgumentException, IllegalAccessException {
        while (objCls != null) {
            Field[] fieldArray = objCls.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                Class<?> fieldCls = field.getType();
                if (!fieldCls.isPrimitive() && !Modifier.isStatic(field.getModifiers())) {
                    field.setAccessible(true);
                    Object fieldValue = field.get(obj);
                    if (fieldValue != null && visited.add(System.identityHashCode(fieldValue))) {
                        queue.add(fieldValue);
                    }
                }
                ++n2;
            }
            objCls = objCls.getSuperclass();
        }
    }

    public static long analyzeObject(Object root) throws IllegalArgumentException, IllegalAccessException {
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedList<Object> queue = new LinkedList<Object>();
        if (TRACE) {
            System.err.println("root=" + root.getClass().getCanonicalName() + "(\"" + root + "\")");
        }
        long size = 0L;
        if (root == null) {
            return size;
        }
        queue.add(root);
        visited.add(System.identityHashCode(root));
        while (!queue.isEmpty()) {
            Object obj = queue.remove(0);
            Class<?> objCls = obj.getClass();
            long objSize = instrument.getObjectSize(obj);
            size += objSize;
            if (DEBUG && !TRACE && visited.size() % 1000 == 0) {
                System.err.print(".");
            }
            if (TRACE) {
                System.err.println("\t" + objSize + " " + obj.getClass().getCanonicalName() + " (\"" + obj + "\")");
            }
            if (objCls.isArray()) {
                ObjectAnalysisAgent.queueElements(queue, visited, obj, objCls);
                continue;
            }
            ObjectAnalysisAgent.queueChildren(queue, visited, obj, objCls);
        }
        if (TRACE) {
            System.err.println("total\t" + size);
        }
        return size;
    }

    private static void push(List<Reference> stack, Object ancestor, Object child) {
        stack.add(0, new Reference(ancestor, child));
    }

    private static Reference pop(List<Reference> stack) {
        return stack.remove(0);
    }

    private static Reference peek(List<Reference> stack) {
        return stack.get(0);
    }

    private static long lookupChild(Object ancestor, Object child, List<Reference> stack, Set<Integer> visited, Set<Integer> alreadyHit, Map<Long, Long> cache) {
        Reference ref = new Reference(ancestor, child);
        long key = ref.key();
        Long hit = cache.get(key);
        int childId = System.identityHashCode(child);
        if (hit == null) {
            if (visited.add(childId)) {
                ObjectAnalysisAgent.push(stack, ancestor, child);
                return -1L;
            }
            return 0L;
        }
        if (alreadyHit.add(childId)) {
            if (TRACE) {
                System.err.println("\tcache hit: " + hit + " " + child);
            }
            return hit;
        }
        if (TRACE) {
            System.err.println("\tskipping: " + child + " since we've already counted it");
        }
        return 0L;
    }

    public static long reachableSize(Object root, Map<Long, Long> cache) throws IllegalAccessException {
        long size;
        if (root == null) {
            return 0L;
        }
        if (cache == null) {
            cache = new HashMap<Long, Long>();
        }
        TreeSet<Integer> visited = new TreeSet<Integer>();
        TreeSet<Integer> included = new TreeSet<Integer>();
        LinkedList<Reference> stack = new LinkedList<Reference>();
        ObjectAnalysisAgent.push(stack, null, root);
        while (true) {
            Reference ref = ObjectAnalysisAgent.peek(stack);
            Object obj = ref.referant;
            Class<?> rootCls = obj.getClass();
            int id = System.identityHashCode(obj);
            size = ref.cont == null ? instrument.getObjectSize(obj) : ref.cont.partialSize;
            Long hit = cache.get(ref.key());
            if (DEBUG && !TRACE && visited.size() % 1000 == 0) {
                System.err.print(".");
            }
            visited.add(id);
            if (TRACE) {
                if (ref.cont == null) {
                    System.err.println("beginning: " + size + " " + obj.getClass().getName() + "(\"" + obj + "\")");
                } else {
                    System.err.println("resuming : " + size + " " + obj.getClass().getName() + "(\"" + obj + "\")");
                }
            }
            if (hit != null && included.add(id)) {
                if (TRACE) {
                    System.err.println("\tearly cache hit: " + hit + " " + obj + "(size=" + hit + ")");
                }
                size = hit;
                ++cacheHits;
            } else {
                boolean savedCont;
                if (ref.cont == null) {
                    ++cacheMisses;
                }
                if (rootCls.isArray()) {
                    if (!rootCls.getComponentType().isPrimitive()) {
                        int startIndex = 0;
                        int aryLength = Array.getLength(obj);
                        if (ref.cont != null) {
                            startIndex = ref.cont.index;
                        }
                        savedCont = false;
                        int i = startIndex;
                        while (i < aryLength) {
                            Object elem = Array.get(obj, i);
                            if (elem != null && !java.lang.ref.Reference.class.isAssignableFrom(elem.getClass())) {
                                long result = ObjectAnalysisAgent.lookupChild(obj, elem, stack, visited, included, cache);
                                if (result < 0L) {
                                    if (!savedCont) {
                                        ref.cont = new Continuation(size, i);
                                        savedCont = true;
                                    }
                                } else {
                                    if (ref.cont == null) {
                                        ++cacheHits;
                                    }
                                    size += result;
                                }
                            }
                            ++i;
                        }
                        if (!savedCont) {
                            ref.cont = null;
                        }
                    }
                } else {
                    Class<?> objCls = rootCls;
                    int startIndex = 0;
                    if (ref.cont != null) {
                        objCls = ref.cont.cls;
                        startIndex = ref.cont.index;
                    }
                    savedCont = false;
                    while (objCls != null) {
                        Field[] declaredFields = objCls.getDeclaredFields();
                        int i = startIndex;
                        while (i < declaredFields.length) {
                            Field field = declaredFields[i];
                            Class<?> fieldCls = field.getType();
                            if (!(fieldCls.isPrimitive() || java.lang.ref.Reference.class.isAssignableFrom(fieldCls) || Modifier.isStatic(field.getModifiers()))) {
                                field.setAccessible(true);
                                Object fieldValue = field.get(obj);
                                if (fieldValue != null) {
                                    long result = ObjectAnalysisAgent.lookupChild(obj, fieldValue, stack, visited, included, cache);
                                    if (-1L == result) {
                                        if (!savedCont) {
                                            ref.cont = new Continuation(size, objCls, i);
                                            savedCont = true;
                                        }
                                    } else {
                                        if (ref.cont == null) {
                                            ++cacheHits;
                                        }
                                        size += result;
                                    }
                                }
                            }
                            ++i;
                        }
                        objCls = objCls.getSuperclass();
                        startIndex = 0;
                    }
                    if (!savedCont) {
                        ref.cont = null;
                    }
                }
            }
            if (ref.cont != null) continue;
            cache.put(ref.key(), size);
            if (TRACE) {
                String ancestor = ref.ancestor == null ? "null" : ref.ancestor.getClass().getName();
                System.err.println("\tcache put: " + size + " " + ancestor + " -> " + obj.getClass().getCanonicalName() + " (\"" + obj + "\")");
            }
            ObjectAnalysisAgent.pop(stack);
            if (stack.isEmpty()) break;
        }
        return size;
    }

    public static void main(String[] args) throws IllegalArgumentException, IllegalAccessException, IOException {
        Object[] tests;
        Object[] objectArray = new Object[7];
        objectArray[0] = new Integer(42);
        objectArray[1] = "Hello, world";
        objectArray[2] = "hello";
        objectArray[3] = "world";
        objectArray[4] = new Object[]{"hello", "world"};
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        objectArray[5] = nArray;
        tests[tests.length - 1] = tests = objectArray;
        TreeMap<Long, Long> cache = new TreeMap<Long, Long>();
        Object[] objectArray2 = tests;
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray2[n2];
            if (o != null) {
                long sizeA = ObjectAnalysisAgent.analyzeObject(o);
                long sizeB = ObjectAnalysisAgent.reachableSize(o, cache);
                System.out.printf("sizeof(%s) = %d\t(analyzeObject)\n", o.toString(), sizeA);
                System.out.printf("sizeof(%s) = %d\t(reachableSize)\n", o.toString(), sizeB);
            }
            ++n2;
        }
        System.out.printf("sizeof(tests) = %d\t(analyzeObject)\n", ObjectAnalysisAgent.analyzeObject(tests));
        System.out.printf("sizeof(tests) = %d\t(reachableSize)\n", ObjectAnalysisAgent.reachableSize(tests, cache));
    }

    private static class Continuation {
        public Type type;
        public int index;
        public long partialSize;
        public Class<?> cls;

        public Continuation(long partialSize, int index) {
            this.type = Type.ARRAY;
            this.partialSize = partialSize;
            this.index = index;
        }

        public Continuation(long partialSize, Class<?> cls, int index) {
            this.type = Type.OBJECT;
            this.partialSize = partialSize;
            this.index = index;
            this.cls = cls;
        }

        public static enum Type {
            NONE,
            ARRAY,
            OBJECT;

        }
    }

    private static class Reference {
        public Object ancestor;
        public Object referant;
        public Continuation cont;

        public Reference(Object ancestor, Object ref) {
            this.ancestor = ancestor;
            this.referant = ref;
        }

        public long key() {
            return (long)System.identityHashCode(this.ancestor) << 32 | (long)System.identityHashCode(this.referant);
        }
    }
}

