/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdz.devtools.cobol.ui.wizards;

import com.ibm.etools.wdz.devtools.cobol.ui.internal.NLS;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CobolProjectSelectionWizardSelectionPage
extends WizardSelectionPage {
    protected static final String EXTENSION_POINT_NAME = "name";
    protected static final String EXTENSION_POINT_CLASS = "class";
    protected static final String EXTENSION_POINT_ICON = "icon";
    protected static final String EXTENSION_POINT_DESC = "description";
    protected CobolProjectWizardNode[] nodes = null;

    protected CobolProjectSelectionWizardSelectionPage(String pageName, IConfigurationElement[] wizards) {
        super(pageName);
        this.nodes = new CobolProjectWizardNode[wizards.length];
        int i = 0;
        while (i < wizards.length) {
            this.nodes[i] = new CobolProjectWizardNode(wizards[i]);
            ++i;
        }
        Arrays.sort(this.nodes, new Comparator<CobolProjectWizardNode>(){

            @Override
            public int compare(CobolProjectWizardNode c1, CobolProjectWizardNode c2) {
                return c1.getName().compareTo(c2.getName());
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(composite, 0);
        label.setText(NLS.Page2TemplatesLabel);
        label = new Label(composite, 0);
        label.setText(NLS.Page2TemplatesDescLabel);
        Table table = new Table(composite, 2052);
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        int i = 0;
        while (i < this.nodes.length) {
            TableItem item = new TableItem(table, -1);
            item.setImage(this.nodes[i].getIcon());
            item.setText(this.nodes[i].getName());
            item.setData((Object)this.nodes[i]);
            ++i;
        }
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        final Text desc = new Text(composite, 2824);
        desc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CobolProjectSelectionWizardSelectionPage.this.setSelectedNode((IWizardNode)((Table)e.getSource()).getSelection()[0].getData());
                desc.setText(((CobolProjectWizardNode)((Table)e.getSource()).getSelection()[0].getData()).getDescription());
            }
        });
        this.setTitle(NLS.Page2Title);
        this.setDescription(NLS.Page2Description);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    protected class CobolProjectWizardNode
    implements IWizardNode {
        protected IConfigurationElement element = null;
        protected IWizard wizard = null;
        protected Image image = null;

        public CobolProjectWizardNode(IConfigurationElement element) {
            this.element = element;
        }

        public String getDescription() {
            return this.element.getAttribute(CobolProjectSelectionWizardSelectionPage.EXTENSION_POINT_DESC);
        }

        public String getName() {
            return this.element.getAttribute(CobolProjectSelectionWizardSelectionPage.EXTENSION_POINT_NAME);
        }

        public Image getIcon() {
            ImageDescriptor descriptor;
            String icon = this.element.getAttribute(CobolProjectSelectionWizardSelectionPage.EXTENSION_POINT_ICON);
            if (icon != null && !icon.equals("")) {
                String pluginId = this.element.getContributor().getName();
                descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)icon);
            } else {
                icon = "icons/newcobolprj.gif";
                descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.etools.wdz.devtools.cobol.ui", (String)icon);
            }
            if (descriptor != null) {
                this.image = descriptor.createImage();
                return this.image;
            }
            this.image = ImageDescriptor.getMissingImageDescriptor().createImage();
            return this.image;
        }

        public void dispose() {
            if (this.wizard != null) {
                this.wizard.dispose();
            }
            if (this.image != null && !this.image.isDisposed()) {
                this.image.dispose();
            }
        }

        public Point getExtent() {
            return new Point(-1, -1);
        }

        public IWizard getWizard() {
            if (this.wizard == null) {
                try {
                    this.wizard = (IWizard)this.element.createExecutableExtension(CobolProjectSelectionWizardSelectionPage.EXTENSION_POINT_CLASS);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return this.wizard;
        }

        public boolean isContentCreated() {
            return this.wizard != null;
        }
    }
}

