/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wdz.devtools.cobol.ui.wizards;

import com.ibm.etools.wdz.devtools.cobol.ui.ICobolProjectWizard;
import com.ibm.etools.wdz.devtools.cobol.ui.internal.NLS;
import com.ibm.etools.wdz.devtools.cobol.ui.wizards.CobolProjectLocationPage;
import com.ibm.etools.wdz.devtools.cobol.ui.wizards.CobolProjectSelectionWizardSelectionPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CobolProjectSelectionWizard
extends Wizard
implements IWorkbenchWizard {
    private static final String DEFAULT_PAGE_ICON = "icons/newcobolprj_wiz.jpg";
    CobolProjectLocationPage mainPage;
    CobolProjectSelectionWizardSelectionPage selectionPage;

    public CobolProjectSelectionWizard() {
        this.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.etools.wdz.devtools.cobol.ui", (String)DEFAULT_PAGE_ICON));
    }

    public boolean performFinish() {
        final IProject project = this.mainPage.getProjectHandle();
        final IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        if (!this.mainPage.useDefaults()) {
            description.setLocation(this.mainPage.getLocationPath());
        } else {
            description.setLocation(null);
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(NLS.ProjectCreationTaskName, CobolProjectSelectionWizard.this.selectionPage == null ? 100 : 250);
                        project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
                        if (CobolProjectSelectionWizard.this.mainPage.isPushable()) {
                            IProjectDescription description2 = project.getDescription();
                            description2.setNatureIds(new String[]{"com.ibm.etools.pushable.PushableNature"});
                            project.setDescription(description2, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
                        } else {
                            monitor.worked(25);
                        }
                        if (CobolProjectSelectionWizard.this.selectionPage == null || CobolProjectSelectionWizard.this.selectionPage.getSelectedNode() == null) {
                            return;
                        }
                        try {
                            IWizard wizard = CobolProjectSelectionWizard.this.selectionPage.getSelectedNode().getWizard();
                            if (wizard instanceof ICobolProjectWizard && !((ICobolProjectWizard)wizard).performFinish(project, (IProgressMonitor)new SubProgressMonitor(monitor, 150))) {
                                project.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                                throw new InterruptedException();
                            }
                        }
                        catch (CoreException e) {
                            if (e.getStatus().matches(8)) {
                                throw new InterruptedException();
                            }
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void addPages() {
        this.mainPage = new CobolProjectLocationPage("basicNewProjectPage");
        this.mainPage.setTitle(NLS.Page1Title);
        this.mainPage.setDescription(NLS.Page1Description);
        this.addPage((IWizardPage)this.mainPage);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.etools.wdz.devtools.cobol.ui.newCobolProjectWizard");
        IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
        this.selectionPage = null;
        if (elements.length > 0) {
            this.selectionPage = new CobolProjectSelectionWizardSelectionPage(NLS.Page2Name, elements);
            this.addPage((IWizardPage)this.selectionPage);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

