<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html"/>
  <xsl:template match="/">
    <xsl:apply-templates select="threadsafe-report"/>
  </xsl:template>
  <xsl:template match="threadsafe-report">
<!-- NLS_CHARSET=UTF-8 -->
    <html>
      <head>
        <META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8"/>
        <title>スレッド・セーフ・レポート</title>
        <style type="text/css">
        h1
        {
                font-size:20px;
        }
        h2
        {
                font-size:16px;
        }
        p
        {
                font-size:12px;
        }
        table.common
        {
                border-collapse:collapse;
                border:1px solid black;
        }
        table.embedded
        {
                border-collapse:collapse;
                border:1px;
                width:100%
        }
        th
        {
                background-color:gray;
                border:1px solid black;
                padding:2px;
                font-size:"12";
        }
        th.embedded
        {
                background-color:lightgray;
                border:1px solid black;
                padding:2px;
                font-size:"12";
        }
        td.common
        {
                white-space:nowrap;
                border:1px solid black;
                padding:5px;
                font-size:"12";
        }
        td.nopadding
        {
                border:0px;
                padding:0px;
                font-size:"12";
        }
</style>
      </head>
      <body>
        <h1>CICS INTERDEPENDENCY ANALYZER バージョン <xsl:value-of select="@ia-version"/></h1>
        <p>
          <xsl:value-of select="@date"/>
        </p>
        <h2>プログラムの動的分析 - スレッド・セーフ<xsl:choose><xsl:when test="//summary/details">
                        DETAIL
</xsl:when><xsl:otherwise>
                        SUMMARY
</xsl:otherwise></xsl:choose>

リスト (CICS TS)</h2>
        <p>
          <h2>用語の定義:</h2>
          <ul>
            <li><b>スレッド・セーフ</b>呼び出しとは、TCB スワップを発生させない EXEC CALLS コマンドです。</li>
            <li><b>非スレッド・セーフ</b>呼び出しとは、TCB スワップを発生させる EXEC CALLS コマンドです。</li>
            <li><b>不確定スレッド・セーフ</b>呼び出しとは、その呼び出しが TCB スワップが発生させるかどうか判別できない EXEC CALLS コマンドです。</li>
            <li><b>動的呼び出し</b>とは、実行時におけるモジュール呼び出しです。
動的に呼び出されるプログラムは、呼び出し側プログラムと同じ環境の下に置かれます。</li>
            <li><b>スレッド・セーフ抑制呼び出し</b>とは、プログラムをスレッド・セーフとして定義できなくする可能性があるため、追加の調査を必要とする EXEC CICS コマンドです。
このようなコマンドには、<b>ADDRESS CWA</b>、<b>EXTRACT EXIT</b>、<b>GETMAIN SHARED</b>、および <b>LOAD</b> があります。</li>
          </ul>
        </p>
        <xsl:apply-templates select="options">
          <xsl:with-param name="details">
            <xsl:choose>
              <xsl:when test="//summary/details">
はい
</xsl:when>
              <xsl:otherwise>
いいえ
</xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:apply-templates>
        <table class="common" bgcolor="#DDDDDD">
          <th>CICS IA で収集されるリソースのコレクション ID</th>
          <th>CICS TS 領域アプリケーション ID</th>
          <th>プログラム名
</th>
          <th>プログラムのライブラリー・データ・セット名</th>
          <th>プログラムのインストール済み定義 API 属性値</th>
          <th>プログラムのインストール済み定義 CONCURRENCY 属性値</th>
          <th>プログラムのストレージ・コード</th>
          <th>プログラムは再入可能としてリンクされています</th>
          <th>サマリー・スレッド・セーフ・レポート・データが準備される対象となった CICS リリース (640、650 など)</th>
          <th>サマリー・スレッド・セーフ・レポート・データが準備される対象となった CICS リリース (3.2、4.1 など)</th>
          <th>CICS ストレージ保護モード</th>
          <xsl:variable name="colNum">11</xsl:variable>
          <xsl:for-each select="summary">
            <tr>
              <td class="common">
                <xsl:value-of select="collection-id"/>
              </td>
              <td class="common">
                <xsl:value-of select="applid"/>
              </td>
              <td class="common">
                <xsl:value-of select="program"/>
              </td>
              <td class="common">
                <xsl:value-of select="lib-dataset"/>
              </td>
              <td class="common">
                <xsl:value-of select="apist"/>
              </td>
              <td class="common">
                <xsl:value-of select="concurrency"/>
              </td>
              <td class="common">
                <xsl:value-of select="execution-key"/>
              </td>
              <td class="common">
                <xsl:value-of select="reentrant"/>
              </td>
              <td class="common">
                <xsl:value-of select="cics-release-internal"/>
              </td>
              <td class="common">
                <xsl:value-of select="cics-release-external"/>
              </td>
              <td class="common">
                <xsl:value-of select="storage-protect"/>
              </td>
            </tr>
            <xsl:if test="details">
              <tr>
                <td colspan="{$colNum}">
                  <table class="common" bgcolor="#FFFFFF">
                    <th class="embedded">EXEC CICS コマンド名</th>
                    <th class="embedded">リソース・タイプ
</th>
                    <th class="embedded">リソース名
</th>
                    <th class="embedded">プログラム開始からのコマンドのオフセット</th>
                    <th class="embedded">コマンド出現回数の合計</th>
                    <th class="embedded">コマンド・スレッド・セーフ状況</th>
                    <th class="embedded">抑制呼び出しフラグ</th>
                    <xsl:for-each select="details/detail">
                      <tr>
                        <td class="common">
                          <xsl:value-of select="function"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="type"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="object"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="offset"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="use-count"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="threadsafe"/>
                        </td>
                        <td class="common">
                          <xsl:value-of select="inhibitor"/>
                        </td>
                      </tr>
                    </xsl:for-each>
                  </table>
                </td>
              </tr>
            </xsl:if>
            <tr>
              <td colspan="{$colNum}">
                <table class="embedded" bgcolor="#FFFFFF">
                  <tr>
                    <td class="common" width="16%">CICS 呼び出しの総数:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="cics-calls/total-cics-calls"/>
                    </td>
                    <td class="common" width="16%">スレッド・セーフ:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="cics-calls/threadsafe"/>
                    </td>
                    <td class="common" width="16%">非スレッド・セーフ:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="cics-calls/non-threadsafe"/>
                    </td>
                  </tr>
                  <tr>
                    <td class="common" width="16%">不確定スレッド・セーフ:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="db2-mq-calls/indeterminate-threadsafe"/>
                    </td>
                    <td class="common" width="16%">DB2 呼び出しの総数:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="db2-mq-calls/total-db2-calls"/>
                    </td>
                    <td class="common" width="16%">MQ 呼び出しの総数:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="db2-mq-calls/total-mq-calls"/>
                    </td>
                  </tr>
                  <tr>
                    <td class="common" width="16%">IMS 呼び出しの総数:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="ims-calls/total-ims-calls"/>
                    </td>
                    <td class="common" width="16%">動的呼び出しの総数:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="ims-calls/dynamic-calls"/>
                    </td>
                    <td class="common" width="16%">スレッド・セーフ抑制呼び出しの総数:</td>
                    <td class="common" width="16%">
                      <xsl:value-of select="ims-calls/threadsafe-inhibitor-calls"/>
                    </td>
                  </tr>
                  <!-- Only available in 5.2 and later versions -->
                  <xsl:if test="cpsm-calls">
                    <tr>
                      <td class="common" width="16%">CPSM 呼び出しの総数:</td>
                      <td class="common" width="16%">
                        <xsl:value-of select="cpsm-calls/total-cpsm-calls"/>
                      </td>
                      <td class="common" width="16%">スレッド・セーフ:</td>
                      <td class="common" width="16%">
                        <xsl:value-of select="cpsm-calls/threadsafe"/>
                      </td>
                      <td class="common" width="16%">非スレッド・セーフ:</td>
                      <td class="common" width="16%">
                        <xsl:value-of select="cpsm-calls/non-threadsafe"/>
                      </td>
                    </tr>
                  </xsl:if>
                </table>
              </td>
            </tr>
            <tr>
              <td colspan="{$colNum}">
                <br/>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="options">
    <xsl:param name="details"/>
    <table class="common">
      <th colspan="2">レポート・オプション</th>
      <tr>
        <td bgcolor="#DDDDDD" class="common">コレクション ID
</td>
        <td class="common">
          <xsl:value-of select="collection-id"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#DDDDDD" class="common">領域</td>
        <td class="common">
          <xsl:value-of select="region"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#DDDDDD" class="common">
          <xsl:if test="resource/@type = 'PROGRAM'">
プログラム名
                                        </xsl:if>
          <xsl:if test="resource/@type = 'TRANSID'">
トランザクション名
                                        </xsl:if>
        </td>
        <td class="common">
          <xsl:value-of select="resource"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#DDDDDD" class="common">CICS TS レベル</td>
        <td class="common">
          <xsl:value-of select="cics-ts-level"/>
        </td>
      </tr>
      <tr>
        <td bgcolor="#DDDDDD" class="common">詳細</td>
        <td class="common">
          <xsl:value-of select="$details"/>
        </td>
      </tr>
    </table>
    <br/>
  </xsl:template>
</xsl:stylesheet>
