/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ia.handlers.ResourceHandler;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.ui.actions.UsedByTransactionAction;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class UsedByTransactionsHandler
extends ResourceHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(UsedByTransactionsHandler.class.getPackage().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)UsedByTransactionsHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Object object = selection.getFirstElement();
        Resource resource = this.getResource(object);
        if (resource != null) {
            UsedByTransactionAction usedByTransactionAction = new UsedByTransactionAction();
            usedByTransactionAction.setResource(resource);
            String applid = this.getApplid(object);
            if (applid != null) {
                Region region = ResourceFactory.getSingleton().getRegion(applid);
                usedByTransactionAction.setRegion(region);
            }
            usedByTransactionAction.run();
        }
        Debug.exit((Logger)logger, (String)UsedByTransactionsHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return null;
    }
}

