/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ia.handlers.ResourceHandler;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.FindRegionsUsingResourceCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.actions.Messages;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class UsedByRegionsHandler
extends ResourceHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(UsedByRegionsHandler.class.getPackage().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)UsedByRegionsHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Object object = selection.getFirstElement();
        Resource resource = this.getResource(object);
        if (resource != null) {
            FindRegionsUsingResourceCommand findCommand = new FindRegionsUsingResourceCommand(resource);
            String description = MessageFormat.format(Messages.getString((String)"UsedByRegionsAction.title"), resource.toString());
            Presentation presentation = PresentationFactory.getInstance().createPresentation(description, "", "", (Selection)findCommand.getSelectionObject());
            QueryCommand command = new QueryCommand(presentation);
            command.setDescription(description);
            DisplayableData data = (DisplayableData)command.getAdapter(DisplayableData.class);
            data.setDescription(description);
            command.setSaveable(false);
            Activator.executeSearch((Command)command);
        }
        Debug.exit((Logger)logger, (String)UsedByRegionsHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return null;
    }
}

