/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ia.handlers.RegionHandler;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.FindResourcesForRegionCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.controller.DisplayableData;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.query.Messages;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import java.text.MessageFormat;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowResourcesHandler
extends RegionHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowResourcesHandler.class.getPackage().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)ShowResourcesHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Object object = selection.getFirstElement();
        Region region = this.getRegion(object);
        if (region != null) {
            this.executeSearch(region, this.getResourceType());
        }
        Debug.exit((Logger)logger, (String)ShowResourcesHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return null;
    }

    protected void executeSearch(Region region, String resourceType) {
        Debug.enter((Logger)logger, (String)ShowResourcesHandler.class.getName(), (String)"executeSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String resourceDescription = ResourceTypeRenderer.asText((String)resourceType);
        String resourcesForQueryString = Messages.getString((String)"Query.resourcesforregion.msg");
        String resourcesForQueryLabel = MessageFormat.format(resourcesForQueryString, resourceDescription, region.getName());
        FindResourcesForRegionCommand findCommand = new FindResourcesForRegionCommand(region, resourceType);
        Presentation presentation = PresentationFactory.getInstance().createPresentation(resourcesForQueryLabel, "", "", (Selection)findCommand.getSelectionObject());
        QueryCommand command = new QueryCommand(presentation);
        command.setDescription(resourcesForQueryLabel);
        DisplayableData data = (DisplayableData)command.getAdapter(DisplayableData.class);
        data.setDescription(resourcesForQueryLabel);
        command.setSaveable(false);
        Activator.executeSearch((Command)command);
        Debug.exit((Logger)logger, (String)ShowResourcesHandler.class.getName(), (String)"executeSearch", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    protected String getResourceType() {
        return null;
    }
}

