/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.actions.ShowTaskExecutionAction;
import com.ibm.cics.model.ITask;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowExecutionHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ShowExecutionHandler.class.getPackage().getName());

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)ShowExecutionHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        Object object = selection.getFirstElement();
        if (object instanceof ITask) {
            ITask iTask = (ITask)object;
            String transactionName = iTask.getTransactionID();
            Transaction transaction = ResourceFactory.getSingleton().getTransaction(transactionName);
            if (transaction == null) {
                Debug.exit((Logger)logger, (String)ShowExecutionHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
                return null;
            }
            String taskID = iTask.getTaskID();
            Task task = ResourceFactory.getSingleton().getTask(transaction, taskID, iTask.getRegionName());
            if (task == null) {
                Debug.exit((Logger)logger, (String)ShowExecutionHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
                return null;
            }
            ShowTaskExecutionAction showTaskExecutionAction = new ShowTaskExecutionAction(task);
            showTaskExecutionAction.run();
        }
        Debug.exit((Logger)logger, (String)ShowExecutionHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return null;
    }

    public boolean isEnabled() {
        Debug.enter((Logger)logger, (String)ShowExecutionHandler.class.getName(), (String)"isEnabled", (Object)("Thread ID: " + Thread.currentThread().getId()));
        try {
            ITask task;
            String transactionName;
            Object object;
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof ITask && (transactionName = (task = (ITask)object).getTransactionID()) != null) {
                Debug.exit((Logger)logger, (String)ShowExecutionHandler.class.getName(), (String)"isEnabled", (Object)("Thread ID: " + Thread.currentThread().getId()));
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Debug.exit((Logger)logger, (String)ShowExecutionHandler.class.getName(), (String)"isEnabled", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return false;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

