/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ia.actions.IntegrationUtilities;
import com.ibm.cics.eclipse.common.historical.IHistoricalProgram;
import com.ibm.cics.eclipse.common.historical.IHistoricalTransaction;
import com.ibm.cics.eclipse.common.historical.ITokenCICSFile;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ITask;
import java.util.logging.Logger;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.Platform;

public abstract class ResourceHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceHandler.class.getPackage().getName());

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    protected Resource getResource(Object object) {
        Debug.enter((Logger)logger, (String)ResourceHandler.class.getName(), (String)"getResource", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String resourceType = null;
        String resourceName = null;
        if (object instanceof ICICSObject) {
            if (object instanceof ICICSResource) {
                ICICSResource resource = (ICICSResource)object;
                ICICSType cicsType = resource.getObjectType();
                if (resource instanceof ITask) {
                    resourceType = "TRANSID";
                    resourceName = ((ITask)resource).getTransactionID();
                } else {
                    resourceType = IntegrationUtilities.getIAType(cicsType);
                    resourceName = resource.getName();
                }
            } else if (object instanceof ICICSDefinition) {
                ICICSDefinition definition = (ICICSDefinition)object;
                resourceName = definition.getName();
                resourceType = IntegrationUtilities.getIAType(definition.getObjectType());
            }
        } else if (Platform.getAdapterManager().hasAdapter(object, IHistoricalProgram.class.getName())) {
            IHistoricalProgram historicalProgram = (IHistoricalProgram)Platform.getAdapterManager().getAdapter(object, IHistoricalProgram.class);
            resourceName = historicalProgram.getProgram();
            resourceType = "PROGRAM";
        } else if (Platform.getAdapterManager().hasAdapter(object, IHistoricalTransaction.class.getName())) {
            IHistoricalTransaction historicalTransaction = (IHistoricalTransaction)Platform.getAdapterManager().getAdapter(object, IHistoricalTransaction.class);
            resourceName = historicalTransaction.getTransactionName();
            resourceType = "TRANSID";
        } else if (Platform.getAdapterManager().hasAdapter(object, ITokenCICSFile.class.getName())) {
            ITokenCICSFile iFile = (ITokenCICSFile)Platform.getAdapterManager().getAdapter(object, ITokenCICSFile.class);
            resourceName = iFile.getHostName();
            resourceType = "FILE";
        }
        if (resourceName != null && resourceType != null) {
            Resource iaResource = ResourceFactory.getSingleton().getResource(resourceType, resourceName);
            Debug.exit((Logger)logger, (String)ResourceHandler.class.getName(), (String)"getResource", (Object)("Thread ID: " + Thread.currentThread().getId()));
            return iaResource;
        }
        Debug.exit((Logger)logger, (String)ResourceHandler.class.getName(), (String)"getResource", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return null;
    }

    protected String getApplid(Object object) {
        Region region;
        ITokenCICSFile iFile;
        String applidName;
        Debug.enter((Logger)logger, (String)ResourceHandler.class.getName(), (String)"getApplid", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String regionName = null;
        if (object instanceof ICICSResource) {
            ICICSResource resource = (ICICSResource)object;
            regionName = resource.getRegionName();
        } else if (Platform.getAdapterManager().hasAdapter(object, ITokenCICSFile.class.getName()) && (applidName = (iFile = (ITokenCICSFile)Platform.getAdapterManager().getAdapter(object, ITokenCICSFile.class)).getApplid()) != null && (region = ResourceFactory.getSingleton().getRegion(applidName)) != null) {
            regionName = region.getName();
        }
        Debug.exit((Logger)logger, (String)ResourceHandler.class.getName(), (String)"getApplid", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return IntegrationUtilities.getApplid(regionName);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

