/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ia.handlers.ShowResourcesHandler;
import com.ibm.cics.core.model.ModelUtilities;
import com.ibm.cics.eclipse.common.historical.IHistoricalApplid;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.model.IManagedRegion;
import java.util.logging.Logger;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public abstract class RegionHandler
implements IHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(RegionHandler.class.getPackage().getName());

    protected Region getRegion(Object object) {
        IHistoricalApplid historicalApplid;
        Debug.enter((Logger)logger, (String)ShowResourcesHandler.class.getName(), (String)"getRegion", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String applid = null;
        Region region = null;
        if (object instanceof IManagedRegion) {
            IManagedRegion managedRegion = (IManagedRegion)object;
            applid = ModelUtilities.findApplID((IManagedRegion)managedRegion);
        } else if (Platform.getAdapterManager().hasAdapter(object, IHistoricalApplid.class.getName()) && (historicalApplid = (IHistoricalApplid)Platform.getAdapterManager().getAdapter(object, IHistoricalApplid.class.getName())) != null) {
            applid = historicalApplid.getApplid();
        }
        if (applid != null) {
            region = ResourceFactory.getSingleton().getRegion(applid);
        }
        Debug.exit((Logger)logger, (String)ShowResourcesHandler.class.getName(), (String)"getRegion", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return region;
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public boolean isEnabled() {
        try {
            IManagedRegion managedRegion;
            Object object;
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IManagedRegion && (managedRegion = (IManagedRegion)object).getState() != IManagedRegion.StateValue.ACTIVE) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

