/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ia.handlers.ResourceHandler;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.wsaa.LaunchProgramDetailsObjectActionDelegate;
import com.ibm.cics.ia.ui.wsaa.LaunchTransactionDetailsObjectActionDelegate;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AssetDetailsHandler
extends ResourceHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AssetDetailsHandler.class.getPackage().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)AssetDetailsHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object object = selection.getFirstElement();
        Resource resource = this.getResource(object);
        if (resource != null) {
            if (resource instanceof Program) {
                LaunchProgramDetailsObjectActionDelegate action = new LaunchProgramDetailsObjectActionDelegate();
                action.setProgramName(resource.getName());
                action.run(null);
            } else if (resource instanceof Transaction) {
                LaunchTransactionDetailsObjectActionDelegate action = new LaunchTransactionDetailsObjectActionDelegate();
                action.setTransactionName(resource.getName());
                action.run(null);
            }
        }
        Debug.exit((Logger)logger, (String)AssetDetailsHandler.class.getName(), (String)"execute", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return null;
    }

    @Override
    public boolean isEnabled() {
        return "true".equals(System.getProperty("wsaa.active"));
    }
}

