/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.decorators;

import com.ibm.cics.core.model.ModelUtilities;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.ia.commands.FindRegionsCommand;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.model.ICICSRegionDefinition;
import com.ibm.cics.model.IManagedRegion;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class IARegionLabelDecorator
implements ILightweightLabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(IARegionLabelDecorator.class.getPackage().getName());
    private static ImageDescriptor iaRegionImageDescriptor;
    private List applids;

    static {
        try {
            iaRegionImageDescriptor = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.ibm.cics.core.ia/icons/full/cview16/ia_region.gif"));
        }
        catch (MalformedURLException e) {
            logger.logp(Level.SEVERE, IARegionLabelDecorator.class.getName(), "getIARegionImageDescriptor", e.getLocalizedMessage(), e);
        }
    }

    public IARegionLabelDecorator() {
        DB2Host.addListener((DB2Host.Listener)new DB2Host.Listener(){

            public void hostConnected(DB2Host host) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void hostReset(DB2Host host) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    IARegionLabelDecorator.this.applids = null;
                }
            }

            public void hostConnectionException(DB2Host host, Exception e) {
            }
        });
    }

    public void decorate(Object element, IDecoration decoration) {
        String applID = null;
        if (element instanceof ICICSRegionDefinition) {
            applID = ((ICICSRegionDefinition)element).getApplID().trim();
        } else if (element instanceof IManagedRegion) {
            applID = ModelUtilities.findApplID((IManagedRegion)((IManagedRegion)element));
        }
        if (applID != null && this.isIARegion(applID)) {
            decoration.addOverlay(IARegionLabelDecorator.getIARegionImageDescriptor(), 3);
        }
    }

    private boolean isIARegion(String applID) {
        return this.getIAApplids().indexOf(applID) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getIAApplids() {
        if (this.applids == null && DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").getConnectionStatus() == DB2Host.CONNECTED) {
            IARegionLabelDecorator iARegionLabelDecorator = this;
            synchronized (iARegionLabelDecorator) {
                this.applids = new ArrayList();
                FindRegionsCommand cmd = new FindRegionsCommand();
                cmd.setAsync(false);
                cmd.start();
                for (Region region : cmd.getResults()) {
                    this.applids.add(region.getName().trim());
                }
            }
        }
        return this.applids == null ? Collections.EMPTY_LIST : this.applids;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private static ImageDescriptor getIARegionImageDescriptor() {
        return iaRegionImageDescriptor;
    }
}

