/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ia.actions;

import com.ibm.cics.core.model.DB2EntryDefinitionType;
import com.ibm.cics.core.model.DB2EntryType;
import com.ibm.cics.core.model.DB2TransactionDefinitionType;
import com.ibm.cics.core.model.DB2TransactionType;
import com.ibm.cics.core.model.DocumentTemplateDefinitionType;
import com.ibm.cics.core.model.DocumentTemplateType;
import com.ibm.cics.core.model.ExtrapartitionTDQueueType;
import com.ibm.cics.core.model.FileDefinitionType;
import com.ibm.cics.core.model.IndirectTDQueueType;
import com.ibm.cics.core.model.IntrapartitionTDQueueType;
import com.ibm.cics.core.model.JVMProfileType;
import com.ibm.cics.core.model.LocalFileType;
import com.ibm.cics.core.model.LocalTransactionType;
import com.ibm.cics.core.model.ModelUtilities;
import com.ibm.cics.core.model.PipelineDefinitionType;
import com.ibm.cics.core.model.PipelineType;
import com.ibm.cics.core.model.ProcessTypeDefinitionType;
import com.ibm.cics.core.model.ProcessTypeType;
import com.ibm.cics.core.model.ProgramDefinitionType;
import com.ibm.cics.core.model.ProgramType;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.model.RemoteFileType;
import com.ibm.cics.core.model.RemoteTDQueueType;
import com.ibm.cics.core.model.RemoteTransactionType;
import com.ibm.cics.core.model.TCPIPServiceDefinitionType;
import com.ibm.cics.core.model.TCPIPServiceType;
import com.ibm.cics.core.model.TDQueueDefinitionType;
import com.ibm.cics.core.model.TSModelDefinitionType;
import com.ibm.cics.core.model.TSModelType;
import com.ibm.cics.core.model.TSQueueType;
import com.ibm.cics.core.model.TransactionDefinitionType;
import com.ibm.cics.core.model.URIMapDefinitionType;
import com.ibm.cics.core.model.URIMapType;
import com.ibm.cics.core.model.UnitOfWorkEnqueueType;
import com.ibm.cics.core.model.WebServiceDefinitionType;
import com.ibm.cics.core.model.WebServiceType;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IRegion;
import java.util.HashMap;
import java.util.Map;

public class IntegrationUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Map<ICICSType<?>, String> cicsTypesToIATypes = new HashMap();

    static {
        cicsTypesToIATypes.put((ICICSType<?>)LocalFileType.getInstance(), "FILE");
        cicsTypesToIATypes.put((ICICSType<?>)RemoteFileType.getInstance(), "FILE");
        cicsTypesToIATypes.put((ICICSType<?>)LocalTransactionType.getInstance(), "TRANSID");
        cicsTypesToIATypes.put((ICICSType<?>)RemoteTransactionType.getInstance(), "TRANSID");
        cicsTypesToIATypes.put((ICICSType<?>)ProgramType.getInstance(), "PROGRAM");
        cicsTypesToIATypes.put((ICICSType<?>)IndirectTDQueueType.getInstance(), "TDQUEUE");
        cicsTypesToIATypes.put((ICICSType<?>)IntrapartitionTDQueueType.getInstance(), "TDQUEUE");
        cicsTypesToIATypes.put((ICICSType<?>)ExtrapartitionTDQueueType.getInstance(), "TDQUEUE");
        cicsTypesToIATypes.put((ICICSType<?>)RemoteTDQueueType.getInstance(), "TDQUEUE");
        cicsTypesToIATypes.put((ICICSType<?>)RegionType.getInstance(), "APPLID");
        cicsTypesToIATypes.put((ICICSType<?>)DB2EntryType.getInstance(), "DB2ENTRY");
        cicsTypesToIATypes.put((ICICSType<?>)DB2TransactionType.getInstance(), "DB2TRAN");
        cicsTypesToIATypes.put((ICICSType<?>)DocumentTemplateType.getInstance(), "DOCTEMP");
        cicsTypesToIATypes.put((ICICSType<?>)JVMProfileType.getInstance(), "JVMPROFILE");
        cicsTypesToIATypes.put((ICICSType<?>)PipelineType.getInstance(), "PIPELINE");
        cicsTypesToIATypes.put((ICICSType<?>)ProcessTypeType.getInstance(), "PROCESS");
        cicsTypesToIATypes.put((ICICSType<?>)TCPIPServiceType.getInstance(), "TCPIPSERVICE");
        cicsTypesToIATypes.put((ICICSType<?>)TSQueueType.getInstance(), "TSQUEUE");
        cicsTypesToIATypes.put((ICICSType<?>)TSModelType.getInstance(), "TSMODEL");
        cicsTypesToIATypes.put((ICICSType<?>)UnitOfWorkEnqueueType.getInstance(), "UOW");
        cicsTypesToIATypes.put((ICICSType<?>)URIMapType.getInstance(), "URIMAP");
        cicsTypesToIATypes.put((ICICSType<?>)WebServiceType.getInstance(), "WEBSERVICE");
        cicsTypesToIATypes.put((ICICSType<?>)TransactionDefinitionType.getInstance(), "TRANSID");
        cicsTypesToIATypes.put((ICICSType<?>)ProgramDefinitionType.getInstance(), "PROGRAM");
        cicsTypesToIATypes.put((ICICSType<?>)FileDefinitionType.getInstance(), "FILE");
        cicsTypesToIATypes.put((ICICSType<?>)TDQueueDefinitionType.getInstance(), "TDQUEUE");
        cicsTypesToIATypes.put((ICICSType<?>)DB2EntryDefinitionType.getInstance(), "DB2ENTRY");
        cicsTypesToIATypes.put((ICICSType<?>)DB2TransactionDefinitionType.getInstance(), "DB2TRAN");
        cicsTypesToIATypes.put((ICICSType<?>)DocumentTemplateDefinitionType.getInstance(), "DOCTEMP");
        cicsTypesToIATypes.put((ICICSType<?>)PipelineDefinitionType.getInstance(), "PIPELINE");
        cicsTypesToIATypes.put((ICICSType<?>)ProcessTypeDefinitionType.getInstance(), "PROCESS");
        cicsTypesToIATypes.put((ICICSType<?>)TCPIPServiceDefinitionType.getInstance(), "TCPIPSERVICE");
        cicsTypesToIATypes.put((ICICSType<?>)TSModelDefinitionType.getInstance(), "TSMODEL");
        cicsTypesToIATypes.put((ICICSType<?>)URIMapDefinitionType.getInstance(), "URIMAP");
        cicsTypesToIATypes.put((ICICSType<?>)WebServiceDefinitionType.getInstance(), "WEBSERVICE");
    }

    public static String getApplid(String regionName) {
        ICICSplex[] cicsPlexes = UIPlugin.getCPSM().getCICSplexes();
        int i = 0;
        while (i < cicsPlexes.length) {
            IRegion region = ModelUtilities.findRegion((ICICSplex)cicsPlexes[i], (String)regionName);
            if (region != null) {
                return region.getApplID();
            }
            ++i;
        }
        return null;
    }

    public static String getIAType(ICICSType<?> cicsType) {
        return cicsTypesToIATypes.get(cicsType);
    }
}

