/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.wsaa;

import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.wsaa.Messages;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class WSAAPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text urlAddressText;
    private Preferences pluginPreferences = IAPlugin.getDefault().getPluginPreferences();
    private Text portText;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group urlArea = new Group(composite, 0);
        urlArea.setText(Messages.getString("WSAAPreferencePage.groupTextLocation"));
        GridData data = new GridData(4, 0, true, false);
        urlArea.setLayoutData((Object)data);
        urlArea.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)urlArea, 0);
        l.setText(Messages.getString("WSAAPreferencePage.labelTextServer"));
        this.urlAddressText = new Text((Composite)urlArea, 2048);
        TextInput.setAccessibleLabel((Text)this.urlAddressText, (Label)l);
        this.urlAddressText.forceFocus();
        data = new GridData(4, 0x1000000, true, false);
        this.urlAddressText.setLayoutData((Object)data);
        l = new Label((Composite)urlArea, 0);
        l.setText(Messages.getString("WSAAPreferencePage.labelTextPort"));
        this.portText = new Text((Composite)urlArea, 2048);
        TextInput.setAccessibleLabel((Text)this.portText, (Label)l);
        data = new GridData(0, 0, false, false);
        data.widthHint = 50;
        this.portText.setLayoutData((Object)data);
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSAAPreferencePage.this.validate();
            }
        });
        this.urlAddressText.setText(this.pluginPreferences.getString("WSAA_SERVER_NAME"));
        this.portText.setText(Integer.toString(this.pluginPreferences.getInt("WSAA_PORT_NUMBER")));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.ia.help.wsaa_preference_page");
        return composite;
    }

    protected void validate() {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            int parseInt = Integer.parseInt(this.portText.getText());
            if (parseInt < 0) {
                this.setErrorMessage(Messages.getString("WSAAPreferencePage.errorPortNumNegative"));
                this.setValid(false);
            } else if (parseInt > 65535) {
                this.setMessage(Messages.getString("WSAAPreferencePage.warningPortNum"), 2);
                this.setValid(true);
            } else {
                this.setValid(true);
            }
        }
        catch (NumberFormatException e) {
            this.setErrorMessage(Messages.getString("WSAAPreferencePage.errorPortNum"));
            this.setValid(false);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.pluginPreferences.setValue("WSAA_SERVER_NAME", this.urlAddressText.getText());
        this.pluginPreferences.setValue("WSAA_PORT_NUMBER", Integer.parseInt(this.portText.getText()));
        IAPlugin.getDefault().savePluginPreferences();
        Activator.getDefault().setSystemActiveProperty();
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.urlAddressText.setText(this.pluginPreferences.getDefaultString("WSAA_SERVER_NAME"));
        this.portText.setText(Integer.toString(this.pluginPreferences.getDefaultInt("WSAA_PORT_NUMBER")));
    }
}

