/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui.viz.layoutmanagers;

import com.ibm.cics.ia.model.viz.CommandNode;
import com.ibm.cics.ia.model.viz.NestedNode;
import com.ibm.cics.ia.model.viz.RootNode;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.viz.FontFactory;
import com.ibm.cics.ia.ui.viz.editparts.SortedGraphEdgeEditPart;
import com.ibm.cics.ia.ui.viz.editparts.SortedGraphEditPart;
import com.ibm.cics.ia.ui.viz.editparts.SortedGraphRootEditPart;
import com.ibm.cics.ia.ui.viz.figures.Messages;
import com.ibm.cics.ia.ui.viz.layoutmanagers.SortedGraphEdge;
import com.ibm.cics.ia.ui.viz.layoutmanagers.SortedGraphNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.AbstractEditPart;

public class TimelineGraphLayoutManager
extends AbstractLayout {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int DEFAULT_MARGIN_LEFT = 80;
    public static final int REGION_MARGIN_LEFT = 130;
    public static final int DEFAULT_MARGIN_TOP = 20;
    public static final int DEFAULT_MARGIN_RIGHT = 20;
    public static final int DEFAULT_MARGIN_BOTTOM = -20;
    public static final int DEFAULT_HORIZONTAL_SPACING = 15;
    public static final int DEFAULT_VERTICAL_SPACING = 40;
    private int marginLeft = 80;
    private SortedGraphRootEditPart rootEditPart;
    private SortedGraphNode sortedRootNode;
    private HashMap<SortedGraphEditPart, SortedGraphNode> editPartsToNodes = new HashMap();
    private ArrayList<SortedGraphEdge> edges = new ArrayList();
    private HashMap<SortedGraphEdgeEditPart, SortedGraphEdge> editPartsToEdges = new HashMap();
    private HashMap<Object, Integer> timelineObjectsToRows = new HashMap();
    private ArrayList<Integer> rowLocations = new ArrayList();
    private HashMap<Integer, Object> rowsToTimelineObjects = new HashMap();
    private int commandItemWidth;
    private int direction;

    public TimelineGraphLayoutManager(SortedGraphRootEditPart rootEditPart) {
        this.rootEditPart = rootEditPart;
    }

    public void layout(IFigure arg0) {
        this.initializeNodes(this.rootEditPart);
        this.initializeEdges(this.sortedRootNode);
        Collections.sort(this.edges);
        this.processEdges(this.edges);
        this.rootEditPart.applyGraphResuts(this.editPartsToNodes);
        Set<SortedGraphEdgeEditPart> edges = this.editPartsToEdges.keySet();
        for (SortedGraphEdgeEditPart edge : edges) {
            edge.applyGraphResuts(this.editPartsToEdges);
        }
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.editPartsToNodes.clear();
        this.edges.clear();
        this.editPartsToEdges.clear();
        this.timelineObjectsToRows.clear();
        this.rowLocations.clear();
        this.rowsToTimelineObjects.clear();
        this.rootEditPart.getFigure().revalidate();
    }

    public int getDirection() {
        return this.direction;
    }

    private void processEdges(ArrayList<SortedGraphEdge> edges) {
        int i = 0;
        for (SortedGraphEdge edge : edges) {
            ++i;
            SortedGraphNode sourceNode = edge.getSourceNode();
            SortedGraphNode targetNode = edge.getTargetNode();
            Point start = null;
            Point end = null;
            switch (this.direction) {
                case 16: {
                    start = new Point((sourceNode.getAnchorRight().x + targetNode.getAnchorLeft().x) / 2, sourceNode.getAnchorRight().y);
                    end = new Point((sourceNode.getAnchorRight().x + targetNode.getAnchorLeft().x) / 2, targetNode.getAnchorLeft().y);
                    break;
                }
                case 4: {
                    int y = (sourceNode.getAnchorBottom().y + targetNode.getAnchorTop().y) / 2;
                    start = new Point(sourceNode.getAnchorBottom().x, y);
                    end = new Point(targetNode.getAnchorTop().x, y);
                }
            }
            edge.getBends().add(start);
            edge.getBends().add(end);
        }
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }

    private void initializeNodes(SortedGraphRootEditPart rootEditPart) {
        Point location = new Point(0, 0);
        this.initializeRootNode(location);
        this.calculateLeftMargin();
        switch (this.direction) {
            case 16: {
                this.initializeChildNodesForHorizontalLayout(this.sortedRootNode);
                break;
            }
            case 4: {
                this.initializeChildNodesForVerticalLayout(this.sortedRootNode);
            }
        }
    }

    private void initializeRootNode(Point location) {
        this.sortedRootNode = new SortedGraphNode();
        this.sortedRootNode.setIndex(0);
        this.sortedRootNode.setLevel(0);
        this.sortedRootNode.setLocation(location);
        this.sortedRootNode.setParent(null);
        this.sortedRootNode.setSiblings(null);
        this.sortedRootNode.setEditPart(this.rootEditPart);
        this.sortedRootNode.setDirection(131072);
        this.editPartsToNodes.put(this.rootEditPart, this.sortedRootNode);
    }

    private void calculateLeftMargin() {
        LinkedList<String> columnTexts = new LinkedList<String>();
        RootNode rootNode = (RootNode)this.rootEditPart.getModel();
        List programEditParts = this.sortedRootNode.getEditPart().getChildren();
        for (AbstractEditPart abstractEditPart : programEditParts) {
            SortedGraphEditPart programEditPart;
            if (!(abstractEditPart instanceof SortedGraphEditPart) || !((programEditPart = (SortedGraphEditPart)abstractEditPart).getModel() instanceof NestedNode)) continue;
            List childEditParts = programEditPart.getChildren();
            for (AbstractEditPart childEditPart : childEditParts) {
                SortedGraphEditPart editPart;
                if (!(childEditPart instanceof SortedGraphEditPart) || !((editPart = (SortedGraphEditPart)childEditPart).getModel() instanceof CommandNode)) continue;
                CommandNode commandNode = (CommandNode)editPart.getModel();
                Object timelineObject = commandNode.getTimeLineRowObject();
                columnTexts.add(timelineObject.toString());
            }
        }
        int longestRowDescription = UIUtilities.getMaxPixelLength(columnTexts, FontFactory.getInstance().getBoldFont());
        int titlePixelLength = UIUtilities.getPixelLength(Messages.getString(rootNode.getObject().toString()), FontFactory.getInstance().getBoldFont());
        switch (this.direction) {
            case 16: {
                this.marginLeft = Math.max(longestRowDescription, titlePixelLength) + 25;
                break;
            }
            case 4: {
                this.marginLeft = titlePixelLength + 30;
            }
        }
        this.commandItemWidth = Math.max(this.commandItemWidth, longestRowDescription);
    }

    private void initializeChildNodesForHorizontalLayout(SortedGraphNode parentNode) {
        SortedGraphEditPart parentEditPart = parentNode.getEditPart();
        List programEditParts = parentEditPart.getChildren();
        int maxVerticalOffset = parentNode.getLocation().y + 60;
        int horisontalOffset = parentNode.getLocation().x + this.marginLeft;
        for (AbstractEditPart abstractEditPart : programEditParts) {
            SortedGraphEditPart programEditPart;
            if (!(abstractEditPart instanceof SortedGraphEditPart) || !((programEditPart = (SortedGraphEditPart)abstractEditPart).getModel() instanceof NestedNode)) continue;
            NestedNode programNode = (NestedNode)programEditPart.getModel();
            SortedGraphNode programGraphNode = new SortedGraphNode();
            programGraphNode.setDirection(131072);
            programGraphNode.setParent(parentNode);
            parentNode.getChildren().add(programGraphNode);
            programGraphNode.setEditPart(programEditPart);
            this.editPartsToNodes.put(programEditPart, programGraphNode);
            programGraphNode.setLocation(new Point(horisontalOffset, parentNode.getLocation().y + 20));
            List childEditParts = programEditPart.getChildren();
            horisontalOffset += 30;
            for (AbstractEditPart childEditPart : childEditParts) {
                SortedGraphEditPart editPart;
                if (!(childEditPart instanceof SortedGraphEditPart) || !((editPart = (SortedGraphEditPart)childEditPart).getModel() instanceof CommandNode)) continue;
                CommandNode commandNode = (CommandNode)editPart.getModel();
                SortedGraphNode childNode = new SortedGraphNode();
                childNode.setDirection(131072);
                childNode.setParent(programGraphNode);
                programGraphNode.getChildren().add(childNode);
                childNode.setEditPart(editPart);
                this.editPartsToNodes.put(editPart, childNode);
                Object timelineObject = commandNode.getTimeLineRowObject();
                Integer timelineRow = this.timelineObjectsToRows.get(timelineObject);
                if (this.commandItemWidth < childNode.getWidth()) {
                    this.commandItemWidth = childNode.getWidth();
                }
                if (timelineRow == null) {
                    timelineRow = this.rowLocations.size();
                    this.rowLocations.add(maxVerticalOffset);
                    this.timelineObjectsToRows.put(timelineObject, timelineRow);
                    this.rowsToTimelineObjects.put(timelineRow, timelineObject);
                    maxVerticalOffset += 40 + childNode.getHeight();
                }
                int verticalOffset = this.rowLocations.get(timelineRow);
                childNode.setLocation(new Point(horisontalOffset, verticalOffset));
                Dimension size = new Dimension(childNode.getWidth(), childNode.getHeight());
                childNode.setSize(size);
                this.createAnchors(childNode);
                Rectangle outerBounds = new Rectangle(horisontalOffset - 15, verticalOffset - 40, size.width + 30, size.height + 80);
                childNode.setOuterBounds(outerBounds);
                horisontalOffset = horisontalOffset + size.width + 30;
            }
            Dimension size = new Dimension(horisontalOffset - programGraphNode.getLocation().x, 0);
            programGraphNode.setSize(size);
            horisontalOffset += 30;
        }
        ArrayList<SortedGraphNode> programNodes = parentNode.getChildren();
        for (SortedGraphNode programGraphNode : programNodes) {
            programGraphNode.setSize(new Dimension(programGraphNode.getSize().width, maxVerticalOffset));
        }
        parentNode.setSize(new Dimension(horisontalOffset, maxVerticalOffset += 40));
    }

    private void initializeChildNodesForVerticalLayout(SortedGraphNode parentNode) {
        SortedGraphEditPart parentEditPart = parentNode.getEditPart();
        List programEditParts = parentEditPart.getChildren();
        int maxHorizontalOffset = parentNode.getLocation().x + 15 + this.marginLeft;
        int verticalOffset = parentNode.getLocation().y + 60;
        for (AbstractEditPart abstractEditPart : programEditParts) {
            SortedGraphEditPart programEditPart;
            if (!(abstractEditPart instanceof SortedGraphEditPart) || !((programEditPart = (SortedGraphEditPart)abstractEditPart).getModel() instanceof NestedNode)) continue;
            NestedNode programNode = (NestedNode)programEditPart.getModel();
            SortedGraphNode programGraphNode = new SortedGraphNode();
            programGraphNode.setDirection(131072);
            programGraphNode.setParent(parentNode);
            parentNode.getChildren().add(programGraphNode);
            programGraphNode.setEditPart(programEditPart);
            this.editPartsToNodes.put(programEditPart, programGraphNode);
            programGraphNode.setLocation(new Point(parentNode.getLocation().x + this.marginLeft, verticalOffset));
            List childEditParts = programEditPart.getChildren();
            verticalOffset += 40;
            for (AbstractEditPart childEditPart : childEditParts) {
                SortedGraphEditPart editPart;
                if (!(childEditPart instanceof SortedGraphEditPart) || !((editPart = (SortedGraphEditPart)childEditPart).getModel() instanceof CommandNode)) continue;
                CommandNode commandNode = (CommandNode)editPart.getModel();
                SortedGraphNode childNode = new SortedGraphNode();
                childNode.setDirection(131072);
                childNode.setParent(programGraphNode);
                programGraphNode.getChildren().add(childNode);
                childNode.setEditPart(editPart);
                this.editPartsToNodes.put(editPart, childNode);
                Object timelineObject = commandNode.getTimeLineRowObject();
                Integer timelineRow = this.timelineObjectsToRows.get(timelineObject);
                if (timelineRow == null) {
                    timelineRow = this.rowLocations.size();
                    this.rowLocations.add(maxHorizontalOffset);
                    this.timelineObjectsToRows.put(timelineObject, timelineRow);
                    this.rowsToTimelineObjects.put(timelineRow, timelineObject);
                    maxHorizontalOffset += this.commandItemWidth + 30;
                }
                int horizontalOffset = this.rowLocations.get(timelineRow);
                childNode.setLocation(new Point(horizontalOffset, verticalOffset));
                Dimension size = new Dimension(this.commandItemWidth, childNode.getHeight());
                childNode.setSize(size);
                this.createAnchors(childNode);
                Rectangle outerBounds = new Rectangle(horizontalOffset - 15, verticalOffset - 40, size.width + 30, size.height + 40);
                childNode.setOuterBounds(outerBounds);
                verticalOffset += size.height + 40;
            }
            Dimension size = new Dimension(0, verticalOffset - programGraphNode.getLocation().y);
            programGraphNode.setSize(size);
            verticalOffset += 40;
        }
        maxHorizontalOffset -= 15;
        ArrayList<SortedGraphNode> programNodes = parentNode.getChildren();
        for (SortedGraphNode programGraphNode : programNodes) {
            programGraphNode.setSize(new Dimension(maxHorizontalOffset - this.marginLeft, programGraphNode.getSize().height));
        }
        parentNode.setSize(new Dimension(maxHorizontalOffset += this.marginLeft / 2, verticalOffset));
    }

    private void createAnchors(SortedGraphNode node) {
        Point location = node.getLocation();
        Dimension size = node.getSize();
        Point topAnchor = location.getCopy();
        topAnchor.translate(size.width / 2, 0);
        Point rightAnchor = location.getCopy();
        rightAnchor.translate(size.width - 2, size.height / 2);
        Point bottomAnchor = location.getCopy();
        bottomAnchor.translate(size.width / 2, size.height - 2);
        Point leftAnchor = location.getCopy();
        leftAnchor.translate(0, size.height / 2);
        node.setAnchorBottom(bottomAnchor);
        node.setAnchorLeft(leftAnchor);
        node.setAnchorRight(rightAnchor);
        node.setAnchorTop(topAnchor);
    }

    private void initializeEdges(SortedGraphNode parentNode) {
        SortedGraphEditPart editPart = parentNode.getEditPart();
        List connections = editPart.getSourceConnections();
        for (Object object : connections) {
            if (!(object instanceof SortedGraphEdgeEditPart)) continue;
            SortedGraphEdgeEditPart edgeEditPart = (SortedGraphEdgeEditPart)((Object)object);
            SortedGraphEditPart sourcePart = (SortedGraphEditPart)edgeEditPart.getSource();
            SortedGraphEditPart targetPart = (SortedGraphEditPart)edgeEditPart.getTarget();
            SortedGraphEdge sortedGraphEdge = new SortedGraphEdge(this.editPartsToNodes.get((Object)sourcePart), this.editPartsToNodes.get((Object)targetPart));
            this.editPartsToEdges.put(edgeEditPart, sortedGraphEdge);
            this.edges.add(sortedGraphEdge);
        }
        for (SortedGraphNode child : parentNode.getChildren()) {
            this.initializeEdges(child);
        }
    }

    private Dimension recalculateSize(SortedGraphNode parentNode) {
        int width = parentNode.getBottomRight().x - parentNode.getLocation().x;
        int height = parentNode.getBottomRight().y - parentNode.getLocation().y;
        int horizontalShift = 0;
        int verticalShift = 0;
        for (SortedGraphNode node : parentNode.getChildren()) {
            if (width < node.getOuterBounds().right() - parentNode.getLocation().x) {
                width = node.getOuterBounds().right() - parentNode.getLocation().x;
                horizontalShift = width - parentNode.getSize().width;
            }
            if (height >= node.getOuterBounds().bottom() - parentNode.getLocation().y) continue;
            height = node.getOuterBounds().bottom() - parentNode.getLocation().y;
            verticalShift = height - parentNode.getSize().height;
        }
        parentNode.setSize(new Dimension(width += 20, height -= 20));
        Dimension shift = new Dimension(horizontalShift, verticalShift);
        return shift;
    }

    public int getRowCount() {
        return this.rowLocations.size();
    }

    public Rectangle getRowRectangle(int row) {
        Rectangle rectangle = new Rectangle();
        if (row < 0 || row >= this.rowLocations.size()) {
            return rectangle;
        }
        switch (this.direction) {
            case 16: {
                rectangle.setLocation(1, this.rowLocations.get(row).intValue()).translate(0, -20);
                if (row + 1 < this.rowLocations.size()) {
                    rectangle.setHeight(this.rowLocations.get(row + 1) - this.rowLocations.get(row));
                } else {
                    rectangle.setHeight(this.sortedRootNode.getBottomRight().y - (this.rowLocations.get(row) + 40));
                }
                rectangle.setWidth(this.sortedRootNode.getSize().width - 1);
                break;
            }
            case 4: {
                rectangle.setLocation(this.rowLocations.get(row).intValue(), 1).translate(-15, 0);
                rectangle.setSize(this.commandItemWidth + 30, this.sortedRootNode.getSize().height - 1);
            }
        }
        return rectangle;
    }

    public Object getTimelineObject(int row) {
        return this.rowsToTimelineObjects.get(row);
    }
}

